/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.connections.ssh;

import com.intellij.cvsSupport2.connections.ssh.SshAuthentication;
import com.intellij.cvsSupport2.connections.ssh.SshProxyFactory;
import com.trilead.ssh2.Connection;
import com.trilead.ssh2.ProxyData;
import com.trilead.ssh2.transport.ClientServerHello;
import java.io.IOException;
import org.netbeans.lib.cvsclient.connection.AuthenticationException;
import org.netbeans.lib.cvsclient.connection.ConnectionSettings;

public class SshConnectionUtils {
    private static final int SSH_DEFAULT_PORT = 22;

    private SshConnectionUtils() {
    }

    public static Connection openConnection(ConnectionSettings connectionSettings, SshAuthentication authentication) throws AuthenticationException, IOException {
        int port = connectionSettings.getPort() == -1 ? 22 : connectionSettings.getPort();
        Connection connection = new Connection(connectionSettings.getHostName(), port);
        ProxyData proxy = SshProxyFactory.createAndRegister(connectionSettings);
        if (proxy != null) {
            connection.setProxyData(proxy);
        }
        connection.connect(null, connectionSettings.getConnectionTimeout(), connectionSettings.getConnectionTimeout());
        authentication.authenticate(connection);
        return connection;
    }

    public static boolean connectionSupportsPing(Connection connection) {
        ClientServerHello csh = connection.getClientServerHello();
        return csh != null && csh.getServerString() != null && new String(csh.getServerString()).contains("OpenSSH");
    }
}

