/*
 * Decompiled with CFR 0.152.
 */
package com.yourkit.util;

import com.yourkit.util.Strings;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.util.HashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Util {
    public static void no_op() {
    }

    public static <T> T notNull(@Nullable T value, @NotNull T defaultValue) {
        if (defaultValue == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        return value != null ? value : defaultValue;
    }

    public static int compare(long v1, long v2) {
        return v1 < v2 ? -1 : (v1 > v2 ? 1 : 0);
    }

    public static int compare(int v1, int v2) {
        return v1 < v2 ? -1 : (v1 > v2 ? 1 : 0);
    }

    public static int compare(double v1, double v2) {
        return Double.compare(v1, v2);
    }

    public static int compareIgnoreCase(@Nullable String s1, @Nullable String s2) {
        if (s1 == null) {
            return s2 == null ? 0 : -1;
        }
        if (s2 == null) {
            return 1;
        }
        return s1.compareToIgnoreCase(s2);
    }

    public static boolean equalsNullable(@Nullable Object o1, @Nullable Object o2) {
        if (o1 == null || o2 == null) {
            return o1 == o2;
        }
        return o1.equals(o2);
    }

    public static void sleep(long milliseconds) {
        try {
            Thread.sleep(milliseconds);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static void forceGC() {
        Util.forceGC(3);
    }

    public static void forceGC(int count) {
        for (int i = 0; i < count; ++i) {
            System.gc();
        }
    }

    public static void parseKeyValuePair(@NotNull HashMap<String, String> key2value, @NotNull String keyAndValue) {
        if (key2value == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (keyAndValue == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        int idx = keyAndValue.indexOf(61);
        if (idx == -1) {
            return;
        }
        String key = keyAndValue.substring(0, idx);
        String value = keyAndValue.substring(idx + 1);
        key2value.put(key, value);
    }

    public static int minInt(int a, long b) {
        return (int)Math.min((long)a, b);
    }

    public static int minInt(long a, int b) {
        return (int)Math.min(a, (long)b);
    }

    @NotNull
    public static String getStackTrace(@NotNull Throwable e) {
        if (e == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        StringBuilder result = new StringBuilder();
        Util.printStackTrace(result, e);
        String string = result.toString();
        if (string == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return string;
    }

    @NotNull
    public static String composeErrorMessage(@NotNull String msg, @NotNull Throwable e) {
        if (msg == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (e == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        String string = msg + ": " + Util.getStackTrace(e);
        if (string == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return string;
    }

    public static void clearQuick(@NotNull HashMap<?, ?> map) {
        if (map == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (!map.isEmpty()) {
            map.clear();
        }
    }

    private static void printStackTrace(@NotNull StringBuilder result, @NotNull Throwable e) {
        if (result == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (e == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        result.append(e.toString());
        result.append('\n');
        StackTraceElement[] trace = e.getStackTrace();
        Util.printStackTraceElementArray(result, trace, 0);
        Throwable cause = e.getCause();
        if (cause != null) {
            Util.printStackTraceAsCause(result, cause, trace);
        }
    }

    @NotNull
    public static String getCurrentStackTrace(int wrappingCallCount) {
        StackTraceElement[] trace = new Exception().getStackTrace();
        StringBuilder result = new StringBuilder();
        Thread thread = Thread.currentThread();
        result.append("Thread \"");
        result.append(thread.getName());
        result.append("\" #");
        result.append(thread.getId());
        if (thread.isDaemon()) {
            result.append(" daemon");
        }
        result.append("\n");
        Util.printStackTraceElementArray(result, trace, wrappingCallCount + 1);
        String string = result.toString();
        if (string == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return string;
    }

    public static void printStackTraceElementArray(@NotNull StringBuilder result, @NotNull StackTraceElement[] trace, int elementsToSkip) {
        if (result == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (trace == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        for (int i = elementsToSkip; i < trace.length; ++i) {
            result.append("\tat ");
            result.append(trace[i].toString());
            result.append('\n');
        }
    }

    private static void printStackTraceAsCause(@NotNull StringBuilder result, @NotNull Throwable e, @NotNull StackTraceElement[] causedTrace) {
        Throwable ourCause;
        if (result == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (e == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        if (causedTrace == null) {
            throw new IllegalArgumentException("Parameter 3 must not be null");
        }
        StackTraceElement[] trace = e.getStackTrace();
        int m = trace.length - 1;
        for (int n = causedTrace.length - 1; m >= 0 && n >= 0 && trace[m].equals(causedTrace[n]); --m, --n) {
        }
        int framesInCommon = trace.length - 1 - m;
        result.append("Caused by: ");
        result.append(e.toString());
        result.append('\n');
        for (int i = 0; i <= m; ++i) {
            result.append("\tat ");
            result.append(trace[i].toString());
            result.append('\n');
        }
        if (framesInCommon != 0) {
            result.append("\t... ");
            result.append(String.valueOf(framesInCommon));
            result.append(" more");
            result.append('\n');
        }
        if ((ourCause = e.getCause()) != null) {
            Util.printStackTraceAsCause(result, ourCause, trace);
        }
    }

    @NotNull
    public static String getCommandLineSpaceSeparated(@NotNull String[] cmd) {
        if (cmd == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        StringBuilder buf = new StringBuilder(80);
        for (int i = 0; i < cmd.length; ++i) {
            String s;
            if (i > 0) {
                buf.append(' ');
            }
            if ((s = cmd[i]).indexOf(32) >= 0 || s.indexOf(9) >= 0) {
                if (s.charAt(0) != '\"') {
                    buf.append('\"');
                    buf.append(s);
                    if (s.endsWith("\\")) {
                        buf.append("\\");
                    }
                    buf.append('\"');
                    continue;
                }
                if (!s.endsWith("\"")) continue;
                buf.append(s);
                continue;
            }
            buf.append(s);
        }
        String string = buf.toString();
        if (string == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return string;
    }

    @NotNull
    public static String getCommandLineNewLineSeparated(@NotNull String[] cmd) {
        if (cmd == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        String string = Strings.join("", cmd, "\n", false);
        if (string == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return string;
    }

    @Nullable
    public static <T> T callInstanceMethod(@Nullable Object obj, @NotNull String methodName) {
        if (methodName == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        if (obj == null) {
            return null;
        }
        Class<?> aClass = obj.getClass();
        try {
            Method m = aClass.getMethod(methodName, new Class[0]);
            m.setAccessible(true);
            return (T)m.invoke(obj, new Object[0]);
        }
        catch (Throwable ignored) {
            return null;
        }
    }

    @Nullable
    public static <T> T getInstanceField(@Nullable Object obj, @NotNull String fieldName) {
        if (fieldName == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        if (obj == null) {
            return null;
        }
        try {
            Field f = obj.getClass().getDeclaredField(fieldName);
            f.setAccessible(true);
            return (T)f.get(obj);
        }
        catch (Throwable ignored) {
            return null;
        }
    }

    @NotNull
    public static String getStringViaInstanceMethod(@Nullable Object obj, @NotNull String methodName) {
        if (methodName == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        Object o = Util.callInstanceMethod(obj, methodName);
        String string = o instanceof String ? (String)o : "";
        if (string == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return string;
    }

    @NotNull
    public static String getAbsolutePathOrEmpty(@Nullable Object fileObj) {
        String string = fileObj instanceof File ? ((File)fileObj).getAbsolutePath() : "";
        if (string == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public static String getPresentableAddress(@Nullable InetAddress requesterAddress) {
        String hostName;
        if (requesterAddress == null) {
            return "null";
        }
        String hostAddress = requesterAddress.getHostAddress();
        String string = hostAddress.equals(hostName = requesterAddress.getHostName()) ? hostAddress : hostName + "(" + hostAddress + ")";
        String string2 = string;
        if (string == null) throw new IllegalStateException("Method must not return null");
        return string2;
    }

    public static String getNameWithoutMnemonic(@NotNull String nameAndMnemonic) {
        if (nameAndMnemonic == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        int mnemonicIndex = Util.getMnemonicIndexImpl(nameAndMnemonic);
        if (mnemonicIndex == -1) {
            return nameAndMnemonic;
        }
        return nameAndMnemonic.substring(0, mnemonicIndex) + nameAndMnemonic.substring(mnemonicIndex + 1);
    }

    public static int getMnemonicIndexImpl(@NotNull String nameAndMnemonic) {
        if (nameAndMnemonic == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        int mnemonicIndex = nameAndMnemonic.indexOf("_");
        return mnemonicIndex == -1 || mnemonicIndex == nameAndMnemonic.length() - 1 ? -1 : mnemonicIndex;
    }
}

