#!/bin/sh

set -e

platform=linux
if [ "$(uname)" = "Darwin" ]; then
  platform=macos
fi

root=$(cd "$(dirname "$0")"; pwd)
mono="$root/$platform-x64/mono"

export RIDER_ORIGINAL_MONO_GAC_PREFIX="$MONO_GAC_PREFIX"
export RIDER_ORIGINAL_MONO_PATH="$MONO_PATH"
export RIDER_ORIGINAL_MONO_CONFIG="$MONO_CONFIG"
export RIDER_ORIGINAL_MONO_CFG_DIR="$MONO_CFG_DIR"

export MONO_GAC_PREFIX="$root/UnixGAC"
export MONO_PATH="$mono/lib/mono/4.5"
export MONO_CONFIG="$mono/etc/mono/config"
export MONO_CFG_DIR="$mono/etc"

export RIDER_ORIGINAL_DYLD_LIBRARY_PATH="$DYLD_LIBRARY_PATH"
export RIDER_ORIGINAL_LD_LIBRARY_PATH="$LD_LIBRARY_PATH"

# Custom local machine trust store (bundled in)
export MONO_LOCAL_MACHINE_CERTS="$root/UnixGAC/certs"
export RIDER_ORIGINAL_MONO_LOCAL_MACHINE_CERTS=

# Find libMonoPosixHelper.dylib on Mac
export DYLD_LIBRARY_PATH="$mono/lib"

# Find libMonoPosixHelper.so on Linux
export LD_LIBRARY_PATH="$mono/lib:$LD_LIBRARY_PATH"

exec "$mono/bin/mono-sgen" "$@"
