/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.psi.DbElement;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.util.ObjectUtils;

public class ShowSchemasAction
extends DumbAwareAction {
    public void update(AnActionEvent e) {
        DbElement element = (DbElement)ObjectUtils.tryCast((Object)e.getData(CommonDataKeys.PSI_ELEMENT), DbElement.class);
        DasModel model = element == null ? null : DbImplUtil.getBaseDataSource((DatabaseSystem)element.getDataSource()).getModel();
        boolean enabled = model == DasUtil.emptyModel() || model instanceof BasicModModel;
        e.getPresentation().setEnabledAndVisible(enabled);
    }

    public void actionPerformed(AnActionEvent e) {
        LocalDataSource dataSource;
        DbElement element = (DbElement)ObjectUtils.tryCast((Object)e.getData(CommonDataKeys.PSI_ELEMENT), DbElement.class);
        LocalDataSource localDataSource = dataSource = element == null ? null : (LocalDataSource)((Object)ObjectUtils.tryCast((Object)DbImplUtil.getBaseDataSource((DatabaseSystem)element.getDataSource()), LocalDataSource.class));
        if (dataSource == null) {
            return;
        }
        DataSourceUiUtil.buildHiddenNamespacesPopup(element.getProject(), dataSource).showInBestPositionFor(e.getDataContext());
    }
}

