/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.csv.ui;

import com.intellij.database.csv.CsvFormat;
import com.intellij.database.csv.ui.CsvFormatUISettings;
import com.intellij.database.csv.ui.CsvFormatsUI;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbarPosition;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.AnActionButtonUpdater;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PlatformIcons;
import javax.swing.JTable;
import org.jetbrains.annotations.NotNull;

public class CsvFormatsSettingsUI
extends CsvFormatsUI {
    private static final String ADD_NAME = "Add Format";
    private static final String REMOVE_NAME = "Remove Format";
    private static final String COPY_NAME = "Copy Format";

    public CsvFormatsSettingsUI(@NotNull Disposable parent) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/database/csv/ui/CsvFormatsSettingsUI", "<init>"));
        }
        this(true, parent, CsvFormatUISettings.DEFAULT);
    }

    public CsvFormatsSettingsUI(boolean allowNameEditing, @NotNull Disposable parent, @NotNull CsvFormatUISettings settings) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/database/csv/ui/CsvFormatsSettingsUI", "<init>"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/database/csv/ui/CsvFormatsSettingsUI", "<init>"));
        }
        super(allowNameEditing, settings);
        Disposer.register((Disposable)parent, (Disposable)this);
    }

    @Override
    @NotNull
    protected ToolbarDecorator createFormatListDecorator() {
        ToolbarDecorator toolbarDecorator = ToolbarDecorator.createDecorator((JTable)this.getFormatsListComponent().getComponent()).setToolbarPosition(ActionToolbarPosition.TOP).setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                CsvFormatsSettingsUI.this.addNewAndEditName(DatabaseSettings.TSV_FORMAT);
            }
        }).setEditAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                CsvFormatsSettingsUI.this.editName(CsvFormatsSettingsUI.this.getNotNullSelectedFormat());
            }
        }).setEditActionUpdater(new AnActionButtonUpdater(){

            public boolean isEnabled(AnActionEvent e) {
                return CsvFormatsSettingsUI.this.getFormatsListComponent().getSelected() != null;
            }
        }).addExtraAction((AnActionButton)new CopyFormatAction()).setAddActionName(ADD_NAME).setRemoveActionName(REMOVE_NAME).setButtonComparator(new String[]{ADD_NAME, REMOVE_NAME, COPY_NAME});
        if (toolbarDecorator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/csv/ui/CsvFormatsSettingsUI", "createFormatListDecorator"));
        }
        return toolbarDecorator;
    }

    @NotNull
    private CsvFormat getNotNullSelectedFormat() {
        CsvFormat csvFormat = (CsvFormat)ObjectUtils.assertNotNull((Object)this.getFormatsListComponent().getSelected());
        if (csvFormat == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/csv/ui/CsvFormatsSettingsUI", "getNotNullSelectedFormat"));
        }
        return csvFormat;
    }

    private void addNewAndEditName(@NotNull CsvFormat templateFormat) {
        if (templateFormat == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "templateFormat", "com/intellij/database/csv/ui/CsvFormatsSettingsUI", "addNewAndEditName"));
        }
        this.editName(this.getFormatsListComponent().newFormat(templateFormat));
    }

    private void editName(@NotNull CsvFormat format) {
        if (format == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "format", "com/intellij/database/csv/ui/CsvFormatsSettingsUI", "editName"));
        }
        this.getFormatsListComponent().editFormatName(format, null);
    }

    private class CopyFormatAction
    extends AnActionButton {
        public CopyFormatAction() {
            super(CsvFormatsSettingsUI.COPY_NAME, PlatformIcons.COPY_ICON);
        }

        public void updateButton(AnActionEvent e) {
            e.getPresentation().setEnabled(CsvFormatsSettingsUI.this.getSelectedFormat() != null);
        }

        public void actionPerformed(AnActionEvent e) {
            CsvFormatsSettingsUI.this.addNewAndEditName(CsvFormatsSettingsUI.this.getNotNullSelectedFormat());
        }

        public ShortcutSet getShortcut() {
            return ActionManager.getInstance().getAction("EditorDuplicate").getShortcutSet();
        }
    }
}

