/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.data.types.domain;

import com.intellij.database.data.types.ConversionPoint;
import com.intellij.database.data.types.DomainRegistry;
import com.intellij.database.data.types.SizeProvider;
import com.intellij.database.data.types.domain.Domain;
import com.intellij.database.data.types.domain.FloatDomain;
import com.intellij.database.data.types.domain.NumberDomain;
import org.jetbrains.annotations.NotNull;

public class Float1Domain
extends FloatDomain {
    private final DomainRegistry.Limits myLimits;

    public Float1Domain(@NotNull String name, @NotNull ConversionPoint descriptor, @NotNull DomainRegistry.Limits limits) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/data/types/domain/Float1Domain", "<init>"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/database/data/types/domain/Float1Domain", "<init>"));
        }
        if (limits == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "limits", "com/intellij/database/data/types/domain/Float1Domain", "<init>"));
        }
        super(name, descriptor, limits.min().doubleValue(), limits.max().doubleValue());
        this.myLimits = limits;
    }

    /*
     * WARNING - void declaration
     */
    public Float1Domain(@NotNull String name, @NotNull ConversionPoint descriptor, double min, double max, @NotNull DomainRegistry.Limits limits) {
        void limits2;
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/data/types/domain/Float1Domain", "<init>"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/database/data/types/domain/Float1Domain", "<init>"));
        }
        if (limits == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "limits", "com/intellij/database/data/types/domain/Float1Domain", "<init>"));
        }
        super(name, descriptor, min, max);
        this.myLimits = limits2;
    }

    @Override
    @NotNull
    public Float1Domain narrow(@NotNull Domain domain) {
        if (domain == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "domain", "com/intellij/database/data/types/domain/Float1Domain", "narrow"));
        }
        if (!(domain instanceof NumberDomain)) {
            Float1Domain float1Domain = this;
            if (float1Domain == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/data/types/domain/Float1Domain", "narrow"));
            }
            return float1Domain;
        }
        Float1Domain float1Domain = this.singleParameter((NumberDomain)domain);
        if (float1Domain == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/data/types/domain/Float1Domain", "narrow"));
        }
        return float1Domain;
    }

    @NotNull
    private Float1Domain singleParameter(@NotNull NumberDomain domain) {
        if (domain == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "domain", "com/intellij/database/data/types/domain/Float1Domain", "singleParameter"));
        }
        Float1Domain float1Domain = new Float1Domain(this.simpleName(), this.getPoint(), domain.getMinValue(), domain.getMaxValue(), this.myLimits);
        if (float1Domain == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/data/types/domain/Float1Domain", "singleParameter"));
        }
        return float1Domain;
    }

    @Override
    @NotNull
    public Float1Domain narrow(@NotNull SizeProvider provider) {
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/database/data/types/domain/Float1Domain", "narrow"));
        }
        int size = provider.getSize();
        double min = this.myLimits.minValue(size).doubleValue();
        double max = this.myLimits.maxValue(size).doubleValue();
        Float1Domain float1Domain = new Float1Domain(this.simpleName(), this.getPoint(), min, max, this.myLimits);
        if (float1Domain == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/data/types/domain/Float1Domain", "narrow"));
        }
        return float1Domain;
    }

    @Override
    @NotNull
    public String name() {
        String string = super.name() + "(" + this.myLimits.parameterValueFromMax(this.getMaxValue()).intValue() + ")";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/data/types/domain/Float1Domain", "name"));
        }
        return string;
    }
}

