/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.srcStorage;

import com.intellij.database.dataSource.srcStorage.DbSrcFileStatus;
import com.intellij.database.dataSource.srcStorage.DbSrcFileSystem;
import com.intellij.database.dataSource.srcStorage.DbSrcStorage;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.changes.TextRevisionNumber;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.impl.FileStatusProvider;
import com.intellij.openapi.vcs.impl.VcsBaseContentProvider;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ThreeState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbSrcFileStatusProvider
implements FileStatusProvider,
VcsBaseContentProvider {
    public FileStatus getFileStatus(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/database/dataSource/srcStorage/DbSrcFileStatusProvider", "getFileStatus"));
        }
        return DbSrcStorage.isWritable() && !virtualFile.isDirectory() && virtualFile.getFileSystem() instanceof DbSrcFileSystem ? (FileStatus)ObjectUtils.chooseNotNull((Object)DbSrcFileStatus.getInstance().getStatus(virtualFile).getStatus(), (Object)FileStatus.NOT_CHANGED) : null;
    }

    public void refreshFileStatusFromDocument(@NotNull VirtualFile virtualFile, @NotNull Document doc) {
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/database/dataSource/srcStorage/DbSrcFileStatusProvider", "refreshFileStatusFromDocument"));
        }
        if (doc == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "doc", "com/intellij/database/dataSource/srcStorage/DbSrcFileStatusProvider", "refreshFileStatusFromDocument"));
        }
    }

    @NotNull
    public ThreeState getNotChangedDirectoryParentingStatus(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/database/dataSource/srcStorage/DbSrcFileStatusProvider", "getNotChangedDirectoryParentingStatus"));
        }
        ThreeState threeState = ThreeState.NO;
        if (threeState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcFileStatusProvider", "getNotChangedDirectoryParentingStatus"));
        }
        return threeState;
    }

    @Nullable
    public VcsBaseContentProvider.BaseContent getBaseRevision(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/dataSource/srcStorage/DbSrcFileStatusProvider", "getBaseRevision"));
        }
        final VirtualFile baseFile = DbSrcFileSystem.getInstance().getBaseFile(file, false);
        if (baseFile == null) {
            return null;
        }
        return new VcsBaseContentProvider.BaseContent(){
            private final VcsRevisionNumber myRevisionNumber;
            {
                this.myRevisionNumber = new TextRevisionNumber("remote " + baseFile.getModificationStamp());
            }

            @NotNull
            public VcsRevisionNumber getRevisionNumber() {
                VcsRevisionNumber vcsRevisionNumber = this.myRevisionNumber;
                if (vcsRevisionNumber == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcFileStatusProvider$1", "getRevisionNumber"));
                }
                return vcsRevisionNumber;
            }

            @Nullable
            public String loadContent() {
                return DbSrcFileStatus.getContent(baseFile);
            }
        };
    }

    public boolean isSupported(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/dataSource/srcStorage/DbSrcFileStatusProvider", "isSupported"));
        }
        return DbSrcStorage.isWritable() && file.getFileSystem() instanceof DbSrcFileSystem;
    }
}

