/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.srcStorage;

import com.intellij.coding.CompositeText;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.srcStorage.DbDataSourceLayout;
import com.intellij.database.dataSource.srcStorage.DbSrcChangesTracker;
import com.intellij.database.dataSource.srcStorage.DbSrcFileSystem;
import com.intellij.database.dataSource.srcStorage.DbSrcPath;
import com.intellij.database.dataSource.srcStorage.DbSrcStorageDsMetadata;
import com.intellij.database.dataSource.srcStorage.DbSrcStorageLayout;
import com.intellij.database.dataSource.srcStorage.DbSrcUtils;
import com.intellij.database.dataSource.srcStorage.PersistentMarkup;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicSchemaObject;
import com.intellij.database.model.basic.BasicSourceAware;
import com.intellij.database.scripting.ScriptingFactory;
import com.intellij.database.scripting.ScriptingService;
import com.intellij.database.scripting.ScriptingTask;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.TransactionGuardImpl;
import com.intellij.openapi.application.TransactionId;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.SqlPsiFacade;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class DbSrcModificationSession {
    private static final Logger LOG = Logger.getInstance(DbSrcModificationSession.class);
    private static final CountedThreadExecutor ourStorageWriter = new CountedThreadExecutor(10);
    @Nullable
    private final Project myProject;
    private final List<DbSrcPath> myRemoveQueue;
    private Couple<DbSrcStorageLayout.WriteSession> mySessions;
    private int myBalanceCheck;
    private volatile Pair<BasicSourceAware, CompositeText> myCurrentSource;
    private final DbDataSourceLayout myLayout;
    private boolean myLayoutInitialized;
    private final SqlLanguageDialect myDialect;
    private final ScriptingFactory myScriptingFactory;

    public DbSrcModificationSession(@Nullable Project project, @NotNull DbDataSourceLayout layout) {
        if (layout == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "layout", "com/intellij/database/dataSource/srcStorage/DbSrcModificationSession", "<init>"));
        }
        this.myRemoveQueue = ContainerUtil.newArrayList();
        this.myBalanceCheck = 0;
        this.myCurrentSource = null;
        this.myLayoutInitialized = false;
        this.myProject = project;
        this.myLayout = layout;
        this.myDialect = this.findDialect();
        this.myScriptingFactory = (ScriptingFactory)ServiceManager.getService(ScriptingFactory.class);
    }

    public synchronized void save(@NotNull BasicSourceAware object, @Nullable CompositeText text) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/dataSource/srcStorage/DbSrcModificationSession", "save"));
        }
        if (this.myBalanceCheck <= 0) {
            LOG.error("ModelTextStorage.beginWrite should be called");
        }
        if (this.mySessions == null) {
            this.initSessions();
        }
        this.flushDeleteQueue();
        DbSrcPath srcPath = DbSrcPath.of(object);
        Couple<DbSrcStorageLayout.WriteSession> sessions = this.mySessions;
        if (text == null) {
            this.dropMetadata(srcPath);
            ourStorageWriter.execute(() -> this.processDelete(sessions, srcPath));
        } else {
            CompositeText generated = this.generate(object, text);
            ourStorageWriter.execute(() -> this.processSave(sessions, srcPath, generated));
        }
    }

    public synchronized void queueDelete(@NotNull BasicSourceAware object) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/dataSource/srcStorage/DbSrcModificationSession", "queueDelete"));
        }
        if (this.mySessions == null) {
            DbSrcPath srcPath = DbSrcPath.of(object);
            this.dropMetadata(srcPath);
            this.myRemoveQueue.add(srcPath);
        } else {
            this.save(object, null);
        }
    }

    private void dropMetadata(@NotNull DbSrcPath srcPath) {
        if (srcPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "srcPath", "com/intellij/database/dataSource/srcStorage/DbSrcModificationSession", "dropMetadata"));
        }
        this.myLayout.putMetaData(srcPath, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private CompositeText generate(@NotNull BasicSourceAware object, @NotNull CompositeText text) {
        CompositeText compositeText;
        BasicSchemaObject so;
        BasicModel model;
        block11: {
            if (object == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/dataSource/srcStorage/DbSrcModificationSession", "generate"));
            }
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/database/dataSource/srcStorage/DbSrcModificationSession", "generate"));
            }
            this.myCurrentSource = Pair.create((Object)object, (Object)text);
            model = object.getModel();
            so = (BasicSchemaObject)ObjectUtils.tryCast((Object)object, BasicSchemaObject.class);
            if (model != null && so != null) break block11;
            CompositeText compositeText2 = text;
            this.myCurrentSource = null;
            CompositeText compositeText3 = compositeText2;
            if (compositeText3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcModificationSession", "generate"));
            }
            return compositeText3;
        }
        try {
            ScriptingService service = this.myScriptingFactory.createScriptingService(model, null, null);
            service.makeScript(ScriptingTask.CREATE_COMPLETE, Collections.singleton(so), false);
            CompositeText compositeText4 = service.getScript();
            this.myCurrentSource = null;
            compositeText = compositeText4;
        }
        catch (Throwable e) {
            CompositeText compositeText5;
            try {
                LOG.warn("Code generation failed", e);
                CompositeText compositeText6 = text;
                compositeText5 = compositeText6;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                this.myCurrentSource = null;
            }
            if (compositeText5 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcModificationSession", "generate"));
            }
            return compositeText5;
        }
        if (compositeText == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcModificationSession", "generate"));
        }
        return compositeText;
    }

    private void initSessions() {
        if (this.mySessions != null) {
            throw new AssertionError((Object)"Session already initialized");
        }
        this.mySessions = Couple.of((Object)this.myLayout.createWriteSession(true), (Object)this.myLayout.createWriteSession(false));
        ourStorageWriter.acquire();
    }

    private void flushDeleteQueue() {
        if (this.mySessions == null) {
            throw new AssertionError((Object)"Session should be initialized");
        }
        if (this.myRemoveQueue.isEmpty()) {
            return;
        }
        ArrayList toRemove = ContainerUtil.newArrayList(this.myRemoveQueue);
        this.myRemoveQueue.clear();
        Couple<DbSrcStorageLayout.WriteSession> sessions = this.mySessions;
        ourStorageWriter.execute(() -> this.runWriteAction(() -> {
            for (DbSrcPath path : toRemove) {
                try {
                    this.processDelete(sessions, path);
                }
                catch (Throwable e) {
                    LOG.warn(e);
                }
            }
        }));
    }

    public synchronized void beginWrite() {
        ++this.myBalanceCheck;
    }

    public synchronized void endWrite() {
        --this.myBalanceCheck;
        if (this.myBalanceCheck != 0) {
            return;
        }
        if (this.mySessions == null) {
            if (this.myRemoveQueue.isEmpty()) {
                return;
            }
            this.initSessions();
            this.flushDeleteQueue();
        }
        Couple<DbSrcStorageLayout.WriteSession> sessions = this.mySessions;
        this.mySessions = null;
        ourStorageWriter.execute(() -> this.processCloseSessions(sessions));
        ourStorageWriter.release();
    }

    @Nullable
    public CompositeText getTmpSource(@NotNull BasicSourceAware object) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/dataSource/srcStorage/DbSrcModificationSession", "getTmpSource"));
        }
        Pair<BasicSourceAware, CompositeText> src = this.myCurrentSource;
        return src == null || src.first != object ? null : (CompositeText)src.second;
    }

    private void ensureLayoutInitialized() {
        if (this.myLayoutInitialized) {
            return;
        }
        this.myLayoutInitialized = true;
        try {
            this.myLayout.initForce(this.myDialect);
        }
        catch (IOException e) {
            LOG.warn("Storage initialization failed", (Throwable)e);
        }
    }

    @NotNull
    private Project getAnyProject() {
        if (this.myProject != null && !this.myProject.isDisposed()) {
            Project project = this.myProject;
            if (project == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcModificationSession", "getAnyProject"));
            }
            return project;
        }
        Project[] projects = ProjectManager.getInstance().getOpenProjects();
        Project project = projects.length != 0 ? projects[0] : ProjectManager.getInstance().getDefaultProject();
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcModificationSession", "getAnyProject"));
        }
        return project;
    }

    @NotNull
    private SqlLanguageDialect findDialect() {
        Project project = this.getAnyProject();
        LocalDataSource dataSource = DbSrcUtils.findDataSource(project, this.myLayout.getDataSourceId());
        SqlLanguageDialect sqlLanguageDialect = DbSqlUtil.getSqlDialect(project, dataSource);
        if (sqlLanguageDialect == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcModificationSession", "findDialect"));
        }
        return sqlLanguageDialect;
    }

    private void processDelete(@NotNull Couple<DbSrcStorageLayout.WriteSession> sessions, @NotNull DbSrcPath srcPath) {
        if (sessions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sessions", "com/intellij/database/dataSource/srcStorage/DbSrcModificationSession", "processDelete"));
        }
        if (srcPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "srcPath", "com/intellij/database/dataSource/srcStorage/DbSrcModificationSession", "processDelete"));
        }
        DbSrcStorageLayout.Item baseItem = this.myLayout.getPath(srcPath, false);
        DbSrcStorageLayout.Item stagingItem = this.myLayout.getPath(srcPath, true);
        this.runWriteAction(() -> {
            boolean stagingFileExists;
            if (srcPath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "srcPath", "com/intellij/database/dataSource/srcStorage/DbSrcModificationSession", "lambda$processDelete$5"));
            }
            if (sessions == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sessions", "com/intellij/database/dataSource/srcStorage/DbSrcModificationSession", "lambda$processDelete$5"));
            }
            boolean bl = stagingFileExists = stagingItem != null && stagingItem.getSrcAttributes() != null;
            if (stagingFileExists) {
                DbSrcChangesTracker.markFileDirty(DbSrcFileSystem.getInstance().findFileByPath(DbSrcFileSystem.getPath(this.myProject, this.myLayout.getDataSourceId(), srcPath, true)));
            }
            try {
                if (baseItem != null) {
                    baseItem.delete(this, (DbSrcStorageLayout.WriteSession)sessions.second);
                }
            }
            catch (IOException e) {
                LOG.warn((Throwable)e);
            }
        });
        this.dropMetadata(srcPath);
    }

    @NotNull
    private PersistentMarkup format(@NotNull DbSrcPath srcPath, @NotNull CompositeText text) {
        PersistentMarkup persistentMarkup;
        if (srcPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "srcPath", "com/intellij/database/dataSource/srcStorage/DbSrcModificationSession", "format"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/database/dataSource/srcStorage/DbSrcModificationSession", "format"));
        }
        try {
            Project project = this.getAnyProject();
            DocumentImpl document = new DocumentImpl((CharSequence)"", true);
            ArrayList ranges = ContainerUtil.newArrayList();
            for (CompositeText.Fragment fragment : text.getFragments()) {
                int start = document.getTextLength();
                document.insertString(start, (CharSequence)StringUtil.convertLineSeparators((String)fragment.getText().toString()));
                int end = document.getTextLength();
                CompositeText.Kind kind = fragment.getKind();
                RangeMarker marker = kind.getReformattable() ? document.createRangeMarker(start, end) : document.createGuardedBlock(start, end);
                ranges.add(Pair.create((Object)marker, (Object)((Object)kind)));
            }
            SqlPsiFacade.getInstance((Project)project).format(project, this.myDialect, (Document)document);
            PersistentMarkup.Builder builder = new PersistentMarkup.Builder();
            for (Pair range : ranges) {
                if (!((RangeMarker)range.first).isValid()) {
                    LOG.warn("Range marker died during formatting");
                    continue;
                }
                builder.add((CompositeText.Kind)((Object)range.second), ((RangeMarker)range.first).getStartOffset(), ((RangeMarker)range.first).getEndOffset());
            }
            persistentMarkup = builder.build(document.getText());
        }
        catch (Throwable e) {
            LOG.warn("Formatting for " + srcPath + " failed, passing unformatted", e);
            PersistentMarkup.Builder builder = new PersistentMarkup.Builder();
            for (CompositeText.Fragment f : text.getFragments()) {
                builder.add(f.getKind(), f.getBegin(), f.getEnd());
            }
            PersistentMarkup persistentMarkup2 = builder.build(text.getText());
            if (persistentMarkup2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcModificationSession", "format"));
            }
            return persistentMarkup2;
        }
        if (persistentMarkup == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcModificationSession", "format"));
        }
        return persistentMarkup;
    }

    private void processSave(@NotNull Couple<DbSrcStorageLayout.WriteSession> sessions, @NotNull DbSrcPath srcPath, @NotNull CompositeText text) {
        if (sessions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sessions", "com/intellij/database/dataSource/srcStorage/DbSrcModificationSession", "processSave"));
        }
        if (srcPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "srcPath", "com/intellij/database/dataSource/srcStorage/DbSrcModificationSession", "processSave"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/database/dataSource/srcStorage/DbSrcModificationSession", "processSave"));
        }
        PersistentMarkup sql = this.format(srcPath, text);
        DbSrcStorageDsMetadata.MetaData data = this.myLayout.getMetaData(srcPath);
        DbSrcStorageDsMetadata.MetaData expected = sql.getExpectedMetaData(data);
        this.runWriteAction(() -> {
            if (srcPath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "srcPath", "com/intellij/database/dataSource/srcStorage/DbSrcModificationSession", "lambda$processSave$6"));
            }
            if (sessions == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sessions", "com/intellij/database/dataSource/srcStorage/DbSrcModificationSession", "lambda$processSave$6"));
            }
            this.ensureLayoutInitialized();
            boolean skipWrite = Comparing.equal((Object)data, (Object)expected);
            DbSrcStorageLayout.Item item = this.myLayout.getPath(srcPath, false);
            if (item == null) {
                LOG.warn("Uninitialized storage");
                return;
            }
            if (skipWrite &= item.getSrcAttributes() != null) {
                return;
            }
            try (OutputStreamWriter out = new OutputStreamWriter(item.getOutputStream(this, (DbSrcStorageLayout.WriteSession)sessions.second), CharsetToolkit.UTF8_CHARSET);){
                ((Writer)out).append(sql.getText());
                this.myLayout.putMetaData(srcPath, expected);
            }
            catch (IOException e) {
                LOG.warn((Throwable)e);
            }
        });
    }

    private void processCloseSessions(@NotNull Couple<DbSrcStorageLayout.WriteSession> sessions) {
        if (sessions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sessions", "com/intellij/database/dataSource/srcStorage/DbSrcModificationSession", "processCloseSessions"));
        }
        this.runWriteAction(() -> {
            if (sessions == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sessions", "com/intellij/database/dataSource/srcStorage/DbSrcModificationSession", "lambda$processCloseSessions$7"));
            }
            try {
                ((DbSrcStorageLayout.WriteSession)sessions.first).close();
            }
            catch (IOException e) {
                LOG.warn("Error closing session", (Throwable)e);
            }
            try {
                ((DbSrcStorageLayout.WriteSession)sessions.second).close();
            }
            catch (IOException e) {
                LOG.warn("Error closing session", (Throwable)e);
            }
        });
        DbSrcUtils.refresh();
    }

    private void runWriteAction(@NotNull Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/database/dataSource/srcStorage/DbSrcModificationSession", "runWriteAction"));
        }
        Application app = ApplicationManager.getApplication();
        if (app.isDispatchThread()) {
            app.runWriteAction(runnable);
        } else {
            UIUtil.invokeAndWaitIfNeeded(() -> {
                if (runnable == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/database/dataSource/srcStorage/DbSrcModificationSession", "lambda$runWriteAction$11"));
                }
                ModalityState current = ModalityState.current();
                TransactionGuardImpl guard = (TransactionGuardImpl)TransactionGuard.getInstance();
                TransactionGuardImpl.TransactionIdImpl context = guard.getModalityTransaction(current);
                guard.wrapLaterInvocation(() -> this.lambda$null$10(guard, app, (TransactionId)context, runnable), current).run();
            });
        }
    }

    public void waitForWriteFinished() {
        if (!ourStorageWriter.isRunning()) {
            return;
        }
        CountDownLatch latch = new CountDownLatch(1);
        ourStorageWriter.acquire();
        try {
            ourStorageWriter.execute(latch::countDown);
        }
        finally {
            ourStorageWriter.release();
        }
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private /* synthetic */ void lambda$null$10(TransactionGuardImpl guard, Application app, TransactionId context, @NotNull Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/database/dataSource/srcStorage/DbSrcModificationSession", "lambda$null$10"));
        }
        guard.submitTransaction((Disposable)(this.myProject == null ? app : this.myProject), context, () -> {
            if (runnable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/database/dataSource/srcStorage/DbSrcModificationSession", "lambda$null$9"));
            }
            WriteAction.run(() -> {
                if (runnable == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/database/dataSource/srcStorage/DbSrcModificationSession", "lambda$null$8"));
                }
                runnable.run();
            });
        });
    }

    private static class CountedThreadExecutor
    implements Executor {
        private final Logger LOG = Logger.getInstance(CountedThreadExecutor.class);
        private final BlockingQueue<Runnable> myQueue = new LinkedBlockingQueue<Runnable>(100);
        private final int myTimeoutSec;
        private volatile int myRefCount = 0;
        private volatile boolean myRunning = false;

        private CountedThreadExecutor(int timeoutSec) {
            this.myTimeoutSec = timeoutSec;
        }

        public boolean isRunning() {
            return this.myRunning;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void acquire() {
            BlockingQueue<Runnable> blockingQueue = this.myQueue;
            synchronized (blockingQueue) {
                ++this.myRefCount;
                if (!this.myRunning) {
                    this.myRunning = true;
                    ApplicationManager.getApplication().executeOnPooledThread(this::processQueue);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void release() {
            BlockingQueue<Runnable> blockingQueue = this.myQueue;
            synchronized (blockingQueue) {
                assert (this.myRefCount > 0);
                assert (this.myRunning);
                --this.myRefCount;
            }
        }

        @Override
        public void execute(@NotNull Runnable command) {
            if (command == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/intellij/database/dataSource/srcStorage/DbSrcModificationSession$CountedThreadExecutor", "execute"));
            }
            if (ApplicationManager.getApplication().isDispatchThread()) {
                throw new AssertionError((Object)"Operation not allowed from EDT");
            }
            assert (this.myRefCount > 0);
            assert (this.myRunning);
            try {
                this.myQueue.put(command);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processQueue() {
            block25: {
                boolean running = true;
                block19: while (true) {
                    try {
                        while (true) {
                            Runnable task;
                            if ((task = this.myQueue.poll(this.myTimeoutSec, TimeUnit.SECONDS)) == null) {
                                BlockingQueue<Runnable> blockingQueue = this.myQueue;
                                synchronized (blockingQueue) {
                                    if (this.myQueue.isEmpty() && this.myRefCount == 0) {
                                        running = false;
                                        this.myRunning = false;
                                        break block25;
                                    }
                                    continue block19;
                                }
                            }
                            try {
                                task.run();
                                continue block19;
                            }
                            catch (Throwable e2) {
                                this.LOG.warn(e2);
                                continue;
                            }
                            break;
                        }
                    }
                    catch (InterruptedException e) {
                        BlockingQueue<Runnable> e2 = this.myQueue;
                        synchronized (e2) {
                            running = false;
                            this.myRunning = false;
                        }
                        Thread.currentThread().interrupt();
                        break block25;
                    }
                }
                finally {
                    if (running) {
                        BlockingQueue<Runnable> blockingQueue = this.myQueue;
                        synchronized (blockingQueue) {
                            Application app = ApplicationManager.getApplication();
                            if (this.myRunning) {
                                this.LOG.warn("DbSrcWriter accidentally stopped, rescheduling...");
                                app.invokeLater(() -> app.executeOnPooledThread(this::processQueue), app.getDisposed());
                            }
                        }
                    }
                    this.LOG.info("DbSrcWriter stopped");
                }
            }
        }
    }
}

