/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid.color;

import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.GridMutator;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.color.ColorLayer;
import com.intellij.database.datagrid.color.GridColorModel;
import com.intellij.database.datagrid.color.MarkupColorLayer;
import com.intellij.database.datagrid.color.MutationsColorLayer;
import com.intellij.database.datagrid.color.SearchSessionColorLayer;
import com.intellij.database.datagrid.color.SelectionColorLayer;
import com.intellij.database.run.ui.TableResultPanel;
import com.intellij.database.run.ui.TableResultView;
import com.intellij.util.PairFunction;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Color;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GridColorModelImpl
implements GridColorModel {
    private static final PairFunction<GridMutator.DatabaseMutator<DataConsumer.Row, DataConsumer.Column>, TableResultView, ColorLayer[]> LAYER_CREATOR = (mutator, view2) -> (ColorLayer[])ContainerUtil.ar((Object[])new ColorLayer[]{new MarkupColorLayer(), new MutationsColorLayer((GridMutator.DatabaseMutator<DataConsumer.Row, DataConsumer.Column>)mutator), new SelectionColorLayer((TableResultView)((Object)view2)), new SearchSessionColorLayer()});
    private final TableResultView myView;
    private final ColorLayer[] myLayers;
    private final TableResultPanel myGrid;

    public GridColorModelImpl(@NotNull TableResultPanel grid, @NotNull TableResultView view2, @Nullable GridMutator.DatabaseMutator<DataConsumer.Row, DataConsumer.Column> mutator) {
        if (grid == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/datagrid/color/GridColorModelImpl", "<init>"));
        }
        if (view2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view", "com/intellij/database/datagrid/color/GridColorModelImpl", "<init>"));
        }
        this(grid, view2, (ColorLayer[])LAYER_CREATOR.fun(mutator, (Object)view2));
    }

    public GridColorModelImpl(@NotNull TableResultPanel grid, @NotNull TableResultView view2, ColorLayer ... layers) {
        if (grid == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/datagrid/color/GridColorModelImpl", "<init>"));
        }
        if (view2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view", "com/intellij/database/datagrid/color/GridColorModelImpl", "<init>"));
        }
        if (layers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "layers", "com/intellij/database/datagrid/color/GridColorModelImpl", "<init>"));
        }
        this.myGrid = grid;
        this.myView = view2;
        this.myLayers = layers;
        Arrays.sort(this.myLayers);
    }

    @Override
    @NotNull
    public Color getCellBackground(@NotNull ModelIndex<DataConsumer.Row> row, @NotNull ModelIndex<DataConsumer.Column> column) {
        if (row == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "row", "com/intellij/database/datagrid/color/GridColorModelImpl", "getCellBackground"));
        }
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/datagrid/color/GridColorModelImpl", "getCellBackground"));
        }
        Color color = null;
        for (ColorLayer layer : this.myLayers) {
            color = layer.getCellBackground(row, column, this.myGrid, color);
        }
        Color color2 = this.notNull(color);
        if (color2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/color/GridColorModelImpl", "getCellBackground"));
        }
        return color2;
    }

    @Override
    @NotNull
    public Color getRowHeaderBackground(@NotNull ModelIndex<DataConsumer.Row> row) {
        if (row == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "row", "com/intellij/database/datagrid/color/GridColorModelImpl", "getRowHeaderBackground"));
        }
        Color color = null;
        for (ColorLayer layer : this.myLayers) {
            color = layer.getRowHeaderBackground(row, this.myGrid, color);
        }
        Color color2 = this.notNull(color);
        if (color2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/color/GridColorModelImpl", "getRowHeaderBackground"));
        }
        return color2;
    }

    @Override
    @NotNull
    public Color getColumnHeaderBackground(@NotNull ModelIndex<DataConsumer.Column> column) {
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/datagrid/color/GridColorModelImpl", "getColumnHeaderBackground"));
        }
        Color color = null;
        for (ColorLayer layer : this.myLayers) {
            color = layer.getColumnHeaderBackground(column, this.myGrid, color);
        }
        Color color2 = this.notNull(color);
        if (color2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/color/GridColorModelImpl", "getColumnHeaderBackground"));
        }
        return color2;
    }

    @NotNull
    private Color notNull(@Nullable Color color) {
        Color color2 = color == null ? this.myView.getBackground() : color;
        if (color2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/color/GridColorModelImpl", "notNull"));
        }
        return color2;
    }
}

