/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport.csv;

import com.intellij.database.actions.ImportAction;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.mutating.ColumnDescriptor;
import com.intellij.database.dbimport.ImportInfo;
import com.intellij.database.dbimport.ImportUtil;
import com.intellij.database.dbimport.ReaderTask;
import com.intellij.database.dbimport.csv.CsvInput;
import com.intellij.database.dbimport.csv.CsvPreviewModel;
import com.intellij.database.dbimport.ui.ImportSettingsComponent;
import com.intellij.database.dbimport.ui.component.DdlPreviewComponent;
import com.intellij.database.dbimport.ui.component.ImportComponent;
import com.intellij.database.dbimport.ui.csv.CharsetComponent;
import com.intellij.database.dbimport.ui.csv.CsvFormatComponent;
import com.intellij.database.dbimport.ui.csv.CsvPreviewComponent;
import com.intellij.database.dbimport.ui.csv.CsvTableEditorComponent;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.dialects.GenericDialect;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.schemaEditor.model.DeTable;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CsvInputType
implements ImportAction.InputType {
    private static final String TITLE_MASK = "Import \"%s\" File";
    private final VirtualFile myFile;
    private final int myCharCount;

    public CsvInputType(@NotNull VirtualFile file, int charCountToRead) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/dbimport/csv/CsvInputType", "<init>"));
        }
        this.myFile = file;
        this.myCharCount = charCountToRead;
    }

    @NotNull
    public VirtualFile getFile() {
        VirtualFile virtualFile = this.myFile;
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/csv/CsvInputType", "getFile"));
        }
        return virtualFile;
    }

    @Override
    @NotNull
    public ReaderTask.Input createInput(@NotNull ImportInfo info) throws IOException {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/database/dbimport/csv/CsvInputType", "createInput"));
        }
        CsvInput csvInput = new CsvInput((ThrowableComputable<InputStream, IOException>)((ThrowableComputable)() -> ImportUtil.getInputStream(this.myFile)), this.myFile.getCharset(), info, this.myCharCount, this.myFile.getLength());
        if (csvInput == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/csv/CsvInputType", "createInput"));
        }
        return csvInput;
    }

    @Override
    @NotNull
    public List<ImportComponent<?, ?>> getComponents(@NotNull ImportAction.ImportEditorContext context) throws Exception {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/dbimport/csv/CsvInputType", "getComponents"));
        }
        CsvPreviewModel model = new CsvPreviewModel(this.myFile);
        List list = ContainerUtil.list((Object[])new ImportComponent[]{new CsvPreviewComponent(context, model), new CsvFormatComponent(context, this.myFile), new CsvTableEditorComponent(context), new ImportSettingsComponent(context), new DdlPreviewComponent(context), new CharsetComponent(model)});
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/csv/CsvInputType", "getComponents"));
        }
        return list;
    }

    @Override
    @Nullable
    public DatabaseSystem getProducerSystem() {
        return null;
    }

    @Override
    @NotNull
    public String getDialogTitle() {
        String string = String.format(TITLE_MASK, this.myFile.getName());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/csv/CsvInputType", "getDialogTitle"));
        }
        return string;
    }

    @Override
    @NotNull
    public DatabaseDialectEx getDialect() {
        GenericDialect genericDialect = GenericDialect.INSTANCE;
        if (genericDialect == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/csv/CsvInputType", "getDialect"));
        }
        return genericDialect;
    }

    @Override
    @NotNull
    public DeTable createNewTable(@NotNull ImportAction.ImportEditorContext context, @NotNull List<? extends ColumnDescriptor> descriptors, @Nullable List<DataConsumer.Row> rows) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/dbimport/csv/CsvInputType", "createNewTable"));
        }
        if (descriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptors", "com/intellij/database/dbimport/csv/CsvInputType", "createNewTable"));
        }
        DeTable deTable = ImportUtil.createTable(context, descriptors, rows, (Function<ImportUtil.ColumnTypePredictorInfo, String>)((Function)ImportUtil::getPreferredTypeBasedOnContent));
        if (deTable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/csv/CsvInputType", "createNewTable"));
        }
        return deTable;
    }
}

