/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport.ui.component;

import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.dbimport.ImportInfo;
import com.intellij.database.dbimport.ImportUtil;
import com.intellij.database.dbimport.ui.component.ImportComponent;
import com.intellij.openapi.ui.ValidationInfo;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DataPreviewComponent<T>
implements ImportComponent<T, DataGrid> {
    private static final String EMPTY_DATA = "No data for import";
    protected final ImportInfo.Builder myBuilder;
    private final JPanel myPanel;
    private DataGrid myGrid;

    public DataPreviewComponent(@NotNull ImportInfo.Builder builder) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dbimport/ui/component/DataPreviewComponent", "<init>"));
        }
        this.myPanel = new JPanel(new BorderLayout());
        this.myBuilder = builder;
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ui/component/DataPreviewComponent", "getComponent"));
        }
        return jPanel;
    }

    @Override
    public void build(@NotNull ImportInfo.Builder builder) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dbimport/ui/component/DataPreviewComponent", "build"));
        }
        if (this.myBuilder.getProducers() == null) {
            builder.producers(ImportUtil.getColumns(this.myGrid)).rows(ImportUtil.getRows(this.myGrid));
        }
    }

    @Override
    public boolean isVisible(@NotNull ImportInfo.Builder builder) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dbimport/ui/component/DataPreviewComponent", "isVisible"));
        }
        return builder.getProducers() == null;
    }

    @Override
    @Nullable
    public ValidationInfo validate() {
        if (this.myGrid == null) {
            return null;
        }
        boolean empty = this.myGrid.getVisibleColumns().size() == 0 || this.myBuilder.getImportType().isTableCreated() && this.myGrid.getVisibleRowsCount() == 0;
        return empty ? new ValidationInfo(EMPTY_DATA, this.myGrid.getComponent()) : null;
    }

    @Nullable
    protected final DataGrid getGrid() {
        return this.myGrid;
    }

    protected final void setGrid(@NotNull DataGrid grid) {
        if (grid == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/dbimport/ui/component/DataPreviewComponent", "setGrid"));
        }
        this.myGrid = grid;
        this.myPanel.removeAll();
        this.myPanel.add((Component)grid.getComponent(), "Center");
    }
}

