/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport.ui.csv;

import com.intellij.database.actions.ImportAction;
import com.intellij.database.csv.CsvFormat;
import com.intellij.database.csv.CsvFormatResolver;
import com.intellij.database.csv.ui.CsvFormatsSelectionUI;
import com.intellij.database.dbimport.ImportInfo;
import com.intellij.database.dbimport.graph.GraphObservable;
import com.intellij.database.dbimport.ui.component.ImportComponent;
import com.intellij.database.dbimport.ui.csv.CsvPreviewComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CsvFormatComponent
implements ImportComponent<Object, CsvPreviewComponent.CsvPreviewInfo> {
    private final Disposable myDisposable;
    private final CsvFormatsSelectionUI myForm;
    private final ImportAction.ImportEditorContext myContext;
    private final VirtualFile myFile;

    public CsvFormatComponent(@NotNull ImportAction.ImportEditorContext context, @NotNull VirtualFile file) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/dbimport/ui/csv/CsvFormatComponent", "<init>"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/dbimport/ui/csv/CsvFormatComponent", "<init>"));
        }
        this.myDisposable = context.getDisposable();
        this.myForm = CsvFormatsSelectionUI.createDatabaseSettingsBackedForm(context.getDisposable(), context.getBuilder().getImportType().getCsvFormatSettings());
        this.myContext = context;
        this.myFile = file;
        this.selectMoreSuitableFormat();
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        JComponent jComponent = this.myForm.getComponent();
        if (jComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ui/csv/CsvFormatComponent", "getComponent"));
        }
        return jComponent;
    }

    @Override
    public void addListener(@NotNull GraphObservable.ObserverListener<?> listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/database/dbimport/ui/csv/CsvFormatComponent", "addListener"));
        }
        this.myForm.addFormatChangeListener(source -> {
            if (listener == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/database/dbimport/ui/csv/CsvFormatComponent", "lambda$addListener$0"));
            }
            listener.changed(this, this.getInfo());
        }, this.myDisposable);
    }

    @Override
    @NotNull
    public CompletionStage<CsvPreviewComponent.CsvPreviewInfo> notifyChanged(@Nullable Object object) {
        CompletableFuture<CsvPreviewComponent.CsvPreviewInfo> completableFuture = CompletableFuture.completedFuture(this.getInfo());
        if (completableFuture == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ui/csv/CsvFormatComponent", "notifyChanged"));
        }
        return completableFuture;
    }

    @Override
    public boolean dependsOn(@NotNull GraphObservable.GraphObserver<?, ?> observer) {
        if (observer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "observer", "com/intellij/database/dbimport/ui/csv/CsvFormatComponent", "dependsOn"));
        }
        return observer instanceof CsvPreviewComponent;
    }

    @Override
    public void build(@NotNull ImportInfo.Builder builder) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dbimport/ui/csv/CsvFormatComponent", "build"));
        }
        CsvFormat format = this.myForm.getSelectedFormat();
        builder.csvFormat((CsvFormat)ObjectUtils.assertNotNull((Object)format));
        CsvFormatResolver.saveCsvFormat((CsvFormat)ObjectUtils.assertNotNull((Object)format), this.myFile);
    }

    @Override
    public boolean isVisible(@NotNull ImportInfo.Builder builder) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dbimport/ui/csv/CsvFormatComponent", "isVisible"));
        }
        return builder.getFormat() == null;
    }

    @NotNull
    private CsvPreviewComponent.FormatInfo getInfo() {
        CsvPreviewComponent.FormatInfo formatInfo = new CsvPreviewComponent.FormatInfo((CsvFormat)ObjectUtils.assertNotNull((Object)this.myForm.getSelectedFormat()));
        if (formatInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ui/csv/CsvFormatComponent", "getInfo"));
        }
        return formatInfo;
    }

    private void selectMoreSuitableFormat() {
        Project project = this.myContext.getProject();
        CsvFormat format = CsvFormatResolver.getFormat((Project)ObjectUtils.assertNotNull((Object)project), this.myFile);
        if (format != null) {
            this.myForm.select(format);
        }
    }
}

