/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.diff;

import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.dialects.DialectUtils;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasForeignKey;
import com.intellij.database.model.DasIndex;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DasTableKey;
import com.intellij.database.model.DasTrigger;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbForeignKey;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.util.containers.ContainerUtil;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public abstract class Migrator<T extends DasObject> {
    static final Map<ObjectKind, Migrator<?>> ourRegistry = ContainerUtil.immutableMapBuilder().put((Object)ObjectKind.DATABASE, null).put((Object)ObjectKind.SCHEMA, null).put((Object)ObjectKind.TABLE, null).put((Object)ObjectKind.COLUMN, (Object)new Column()).put((Object)ObjectKind.KEY, (Object)new TableKey()).put((Object)ObjectKind.FOREIGN_KEY, (Object)new ForeignKey()).put((Object)ObjectKind.INDEX, (Object)new Index()).put((Object)ObjectKind.TRIGGER, (Object)new Trigger()).put((Object)ObjectKind.ROUTINE, null).build();

    static <T extends DasObject> Migrator<T> getMigrator(@NotNull T object) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/diff/Migrator", "getMigrator"));
        }
        return ourRegistry.get(object.getKind());
    }

    public abstract void script(T var1, DdlBuilder var2, DdlBuilder var3, DdlBuilder var4, DatabaseDialectEx var5);

    @NotNull
    static DatabaseDialectEx getDialect(DasObject column) {
        DatabaseDialectEx databaseDialectEx = DbImplUtil.getDatabaseDialect((DbElement)column);
        if (databaseDialectEx == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/diff/Migrator", "getDialect"));
        }
        return databaseDialectEx;
    }

    static class Table
    extends Migrator<DasTable> {
        Table() {
        }

        @Override
        public void script(DasTable table, DdlBuilder builder, DdlBuilder addKeyBuilder, DdlBuilder dropKeyBuilder, DatabaseDialectEx targetDialect) {
            if (targetDialect == null) {
                DatabaseDialectEx dialect = Table.getDialect((DasObject)table);
                for (DbForeignKey fk : table.getDbChildren(DbForeignKey.class, ObjectKind.FOREIGN_KEY)) {
                    dialect.sqlDropForeignKey(dropKeyBuilder, table, (DasForeignKey)fk, fk.getName()).newStatement();
                }
                dialect.sqlDropTable(builder, table, true, false, DasUtil.emptyModel()).newStatement();
            } else {
                DialectUtils.getCreateTableSQL(builder, ContainerUtil.list((Object[])new DasTable[]{table}), false, true, targetDialect, null).newStatement();
                DialectUtils.createConstraints(addKeyBuilder, table, ContainerUtil.list((Object[])new DasTable[]{table}), !addKeyBuilder.skipExternalReferences(), targetDialect);
                addKeyBuilder.newStatement();
                DialectUtils.createIndices(addKeyBuilder, table);
                addKeyBuilder.newStatement();
            }
        }
    }

    static class Trigger
    extends Migrator<DasTrigger> {
        Trigger() {
        }

        @Override
        public void script(DasTrigger trigger2, DdlBuilder builder, DdlBuilder addKeyBuilder, DdlBuilder dropKeyBuilder, DatabaseDialectEx targetDialect) {
            if (targetDialect == null) {
                Trigger.getDialect((DasObject)trigger2).sqlDropTrigger(dropKeyBuilder, trigger2).newStatement();
            } else {
                addKeyBuilder.comment("todo: create trigger");
            }
        }
    }

    static class Index
    extends Migrator<DasIndex> {
        Index() {
        }

        @Override
        public void script(DasIndex index, DdlBuilder builder, DdlBuilder addKeyBuilder, DdlBuilder dropKeyBuilder, DatabaseDialectEx targetDialect) {
            if (targetDialect == null) {
                Index.getDialect((DasObject)index).sqlDropIndex(dropKeyBuilder, index.getTable(), index, index.getName(), true).newStatement();
            } else {
                targetDialect.sqlCreateIndex(addKeyBuilder, index, "", "", "").newStatement();
            }
        }
    }

    static class ForeignKey
    extends Migrator<DasForeignKey> {
        ForeignKey() {
        }

        @Override
        public void script(DasForeignKey fk, DdlBuilder builder, DdlBuilder addKeyBuilder, DdlBuilder dropKeyBuilder, DatabaseDialectEx targetDialect) {
            if (targetDialect == null) {
                DatabaseDialectEx dialect = ForeignKey.getDialect((DasObject)fk);
                dialect.sqlDropForeignKey(dropKeyBuilder, fk.getTable(), fk, fk.getName()).newStatement();
            } else {
                targetDialect.sqlAddForeignKey(addKeyBuilder, fk, false, false).newStatement();
            }
        }
    }

    static class TableKey
    extends Migrator<DasTableKey> {
        TableKey() {
        }

        @Override
        public void script(DasTableKey key, DdlBuilder builder, DdlBuilder addKeyBuilder, DdlBuilder dropKeyBuilder, DatabaseDialectEx targetDialect) {
            boolean isPrimary = key.isPrimary();
            if (targetDialect == null) {
                DatabaseDialectEx dialect = TableKey.getDialect((DasObject)key);
                if (isPrimary) {
                    dialect.sqlDropPrimaryKey(dropKeyBuilder, key).newStatement();
                }
            } else if (isPrimary) {
                targetDialect.sqlAddPrimaryKey(addKeyBuilder, key).newStatement();
            }
        }
    }

    static class Column
    extends Migrator<DasColumn> {
        Column() {
        }

        @Override
        public void script(DasColumn column, DdlBuilder builder, DdlBuilder addKeyBuilder, DdlBuilder dropKeyBuilder, DatabaseDialectEx targetDialect) {
            if (targetDialect == null) {
                Column.getDialect((DasObject)column).sqlDropColumn(builder, column);
            } else {
                targetDialect.sqlAddColumn(builder, column, column.getTable().getColumnAttrs(column));
            }
            builder.newStatement();
        }
    }
}

