/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.introspection.jdbcMetadataWrappers;

import com.intellij.database.DatabaseFamilyId;
import com.intellij.database.introspection.GenericIntrospectorLegacyModelUtils;
import com.intellij.database.introspection.jdbcMetadataWrappers.ClosableIt;
import com.intellij.database.introspection.jdbcMetadataWrappers.DatabaseMetaDataWrapper;
import com.intellij.database.introspection.jdbcMetadataWrappers.MetaDataUtil;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.properties.JdbcProcedureType;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RoutineIt
extends ClosableIt.ResultSetClosableIt<DatabaseMetaDataWrapper.Routine> {
    private final DatabaseFamilyId myFamilyId;
    private final DatabaseMetaDataWrapper.Schema mySchema;
    private final boolean myCatIsPkg;
    private final boolean myProc;
    private final MetaDataUtil.SpecNamer namer;

    public RoutineIt(@NotNull ResultSet rs, @NotNull DatabaseFamilyId familyId, @NotNull DatabaseMetaDataWrapper.Schema schema, boolean catIsPkg, boolean proc) throws SQLException {
        if (rs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rs", "com/intellij/database/introspection/jdbcMetadataWrappers/RoutineIt", "<init>"));
        }
        if (familyId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "familyId", "com/intellij/database/introspection/jdbcMetadataWrappers/RoutineIt", "<init>"));
        }
        super(rs);
        this.namer = new MetaDataUtil.SpecNamer();
        this.myFamilyId = familyId;
        this.mySchema = schema;
        this.myCatIsPkg = catIsPkg;
        this.myProc = proc;
    }

    @Override
    protected @NotNull DatabaseMetaDataWrapper.Routine createStorage() {
        return new DatabaseMetaDataWrapper.Routine(this.mySchema, "", "");
    }

    @Override
    protected DatabaseMetaDataWrapper.Routine calcValue() throws SQLException {
        DatabaseMetaDataWrapper.Routine res = (DatabaseMetaDataWrapper.Routine)this.getStorageToFill();
        try {
            String cat = this.getCatalog();
            String database = !this.myCatIsPkg ? StringUtil.nullize((String)cat) : null;
            String string = res.pkg = this.myCatIsPkg ? StringUtil.nullize((String)cat) : null;
            if (!StringUtil.equalsIgnoreCase((CharSequence)this.mySchema.schema, (CharSequence)this.getSchema())) {
                return (DatabaseMetaDataWrapper.Routine)this.skip();
            }
            String origName = this.getName();
            Pair<String, Short> name = GenericIntrospectorLegacyModelUtils.fixProcedureName(this.mySchema.schema, this.myFamilyId, origName);
            if (name == null || StringUtil.isEmpty((String)((String)name.first))) {
                return (DatabaseMetaDataWrapper.Routine)this.skip();
            }
            res.name = (String)name.first;
            res.number = (Short)name.second;
            String spec = this.getSpecificName();
            res.specificName = this.namer.getSpecName(spec, res.name, res.pkg);
            this.namer.finish(spec, res.name, res.pkg);
            res.comment = this.getRemarks();
            if (this.myProc) {
                res.kind = this.getType();
                if (this.myFamilyId.isSybase()) {
                    res.kind = DasRoutine.Kind.PROCEDURE;
                }
            } else {
                res.kind = DasRoutine.Kind.FUNCTION;
            }
        }
        catch (SQLException e) {
            this.onError(res, e);
            return (DatabaseMetaDataWrapper.Routine)this.skip();
        }
        return res;
    }

    private DasRoutine.Kind getType() throws SQLException {
        return JdbcProcedureType.findByID(this.myRs.getShort("PROCEDURE_TYPE", 8)).getKind();
    }

    private String getRemarks() throws SQLException {
        return this.myRs.getString("REMARKS", this.myProc ? 7 : 4);
    }

    private String getSpecificName() throws SQLException {
        return this.myRs.getString("SPECIFIC_NAME", this.myProc ? 9 : 6);
    }

    private String getName() throws SQLException {
        return this.myRs.getString(this.myProc ? "PROCEDURE_NAME" : "FUNCTION_NAME", 3);
    }

    @NotNull
    private String getSchema() throws SQLException {
        String string = StringUtil.notNullize((String)this.myRs.getString(this.myProc ? "PROCEDURE_SCHEM" : "FUNCTION_SCHEM", 2), (String)this.mySchema.schema);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/introspection/jdbcMetadataWrappers/RoutineIt", "getSchema"));
        }
        return string;
    }

    @Nullable
    private String getCatalog() throws SQLException {
        return this.myRs.getString(this.myProc ? "PROCEDURE_CAT" : "FUNCTION_CAT", 1);
    }

    @Override
    public void onError(DatabaseMetaDataWrapper.Routine cur, SQLException e) {
        String title = cur == null ? null : MetaDataUtil.qName(cur.schema.database, cur.schema.schema, cur.name);
        this.addError(title, e);
    }
}

