/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.families;

import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.util.containers.JBIterable;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Family<E extends BasicElement>
extends BasicNode,
Iterable<E> {
    @Override
    @Nullable
    public BasicModel getModel();

    @NotNull
    public E first();

    @NotNull
    public E last();

    public int indexOf(@Nullable BasicElement var1);

    public boolean hasChildren();

    public boolean isEmpty();

    public int size();

    @Nullable
    default public E find(@NotNull Predicate<? super E> predicate) {
        if (predicate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "predicate", "com/intellij/database/model/families/Family", "find"));
        }
        for (BasicElement element : this) {
            if (!predicate.test(element)) continue;
            return (E)element;
        }
        return null;
    }

    default public boolean has(@NotNull Predicate<? super E> predicate) {
        if (predicate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "predicate", "com/intellij/database/model/families/Family", "has"));
        }
        return this.find(predicate) != null;
    }

    @NotNull
    default public Stream<E> stream() {
        Spliterator spliterator = Spliterators.spliteratorUnknownSize(this.iterator(), 272);
        Stream stream = StreamSupport.stream(spliterator, false);
        if (stream == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/families/Family", "stream"));
        }
        return stream;
    }

    @NotNull
    default public JBIterable<E> jbi() {
        JBIterable jBIterable = JBIterable.from((Iterable)this);
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/families/Family", "jbi"));
        }
        return jBIterable;
    }

    @NotNull
    default public Iterable<? extends BasicElement> getChildNodes() {
        Family family = this;
        if (family == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/families/Family", "getChildNodes"));
        }
        return family;
    }

    @Override
    @NotNull
    default public String getDisplayName() {
        String string = this.getClass().getSimpleName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/families/Family", "getDisplayName"));
        }
        return string;
    }
}

