/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.h2;

import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.basic.BasicModRoutine;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.families.ModNamingFamily;
import com.intellij.database.model.families.ModPositioningNamingFamily;
import com.intellij.database.model.families.PositioningNamingFamily;
import com.intellij.database.model.h2.H2ModArgument;
import com.intellij.database.model.h2.H2ModSchema;
import com.intellij.database.model.h2.H2ModSourceAware;
import com.intellij.database.model.h2.H2Routine;
import com.intellij.database.model.properties.PropertyConverter;
import com.intellij.util.containers.JBIterable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface H2ModRoutine
extends H2Routine,
BasicModRoutine,
H2ModSourceAware,
BasicModNamedElement {
    @Override
    @NotNull
    public H2ModSchema getSchema();

    @Override
    @NotNull
    default public H2ModSchema getDbParent() {
        H2ModSchema h2ModSchema = this.getSchema();
        if (h2ModSchema == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/h2/H2ModRoutine", "getDbParent"));
        }
        return h2ModSchema;
    }

    @Override
    @NotNull
    public ModNamingFamily<? extends H2ModRoutine> getParentFamily();

    @Override
    @NotNull
    public ModPositioningNamingFamily<? extends H2ModArgument> getArguments();

    @Override
    @NotNull
    default public List<? extends ModFamily<? extends BasicModElement>> getFamilies() {
        List<PositioningNamingFamily> list = Collections.singletonList(this.getArguments());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/h2/H2ModRoutine", "getFamilies"));
        }
        return list;
    }

    @Override
    @NotNull
    default public JBIterable<? extends BasicModElement> getDbChildren() {
        JBIterable jBIterable = JBIterable.from((Iterable)this.getArguments());
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/h2/H2ModRoutine", "getDbChildren"));
        }
        return jBIterable;
    }

    @Override
    public void setName(@NotNull String var1);

    @Override
    public void setNameSurrogate(boolean var1);

    @Override
    public void setComment(@Nullable String var1);

    @Override
    public void setRoutineKind(@NotNull DasRoutine.Kind var1);

    @Override
    default public void importProperties(@NotNull Map<String, String> properties) {
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/intellij/database/model/h2/H2ModRoutine", "importProperties"));
        }
        String name = properties.get("Name");
        String nameSurrogate = properties.get("NameSurrogate");
        String comment = properties.get("Comment");
        String routineKind = properties.get("RoutineKind");
        if (name != null) {
            this.setName(PropertyConverter.importString(name));
        }
        if (nameSurrogate != null) {
            this.setNameSurrogate(PropertyConverter.importBoolean(nameSurrogate));
        }
        if (comment != null) {
            this.setComment(PropertyConverter.importString(comment));
        }
        if (routineKind != null) {
            this.setRoutineKind(PropertyConverter.importDasRoutineKind(routineKind));
        }
    }
}

