/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.mysql;

import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.families.ModNamingFamily;
import com.intellij.database.model.mysql.MysqlModSchema;
import com.intellij.database.model.mysql.MysqlModSourceAware;
import com.intellij.database.model.mysql.MysqlModTable;
import com.intellij.database.model.mysql.MysqlTrigger;
import com.intellij.database.model.properties.PropertyConverter;
import com.intellij.database.model.properties.TrigEvent;
import com.intellij.database.model.properties.TrigTurn;
import com.intellij.util.containers.JBIterable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface MysqlModTrigger
extends MysqlTrigger,
MysqlModSourceAware,
BasicModNamedElement {
    @Override
    @NotNull
    public MysqlModTable getTable();

    @Override
    @NotNull
    default public MysqlModTable getDbParent() {
        MysqlModTable mysqlModTable = this.getTable();
        if (mysqlModTable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/mysql/MysqlModTrigger", "getDbParent"));
        }
        return mysqlModTable;
    }

    @Override
    @NotNull
    public ModNamingFamily<? extends MysqlModTrigger> getParentFamily();

    @Override
    @NotNull
    default public MysqlModSchema getSchema() {
        MysqlModSchema mysqlModSchema = this.getTable().getSchema();
        if (mysqlModSchema == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/mysql/MysqlModTrigger", "getSchema"));
        }
        return mysqlModSchema;
    }

    @Override
    @NotNull
    default public List<? extends ModFamily<? extends BasicModElement>> getFamilies() {
        List list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/mysql/MysqlModTrigger", "getFamilies"));
        }
        return list;
    }

    @Override
    @NotNull
    default public JBIterable<? extends BasicModElement> getDbChildren() {
        JBIterable jBIterable = JBIterable.empty();
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/mysql/MysqlModTrigger", "getDbChildren"));
        }
        return jBIterable;
    }

    @Override
    public void setName(@NotNull String var1);

    @Override
    public void setNameSurrogate(boolean var1);

    @Override
    public void setComment(@Nullable String var1);

    public void setTurn(@Nullable TrigTurn var1);

    public void setEvents(@NotNull Set<TrigEvent> var1);

    public void setPrecedesTriggerName(@Nullable String var1);

    public void setFollowsTriggerName(@Nullable String var1);

    @Override
    default public void importProperties(@NotNull Map<String, String> properties) {
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/intellij/database/model/mysql/MysqlModTrigger", "importProperties"));
        }
        String name = properties.get("Name");
        String nameSurrogate = properties.get("NameSurrogate");
        String comment = properties.get("Comment");
        String turn = properties.get("Turn");
        String events = properties.get("Events");
        String precedesTriggerName = properties.get("PrecedesTriggerName");
        String followsTriggerName = properties.get("FollowsTriggerName");
        if (name != null) {
            this.setName(PropertyConverter.importString(name));
        }
        if (nameSurrogate != null) {
            this.setNameSurrogate(PropertyConverter.importBoolean(nameSurrogate));
        }
        if (comment != null) {
            this.setComment(PropertyConverter.importString(comment));
        }
        if (turn != null) {
            this.setTurn(PropertyConverter.importTrigTurn(turn));
        }
        if (events != null) {
            this.setEvents(PropertyConverter.importSetOfTrigEvent(events));
        }
        if (precedesTriggerName != null) {
            this.setPrecedesTriggerName(PropertyConverter.importString(precedesTriggerName));
        }
        if (followsTriggerName != null) {
            this.setFollowsTriggerName(PropertyConverter.importString(followsTriggerName));
        }
    }
}

