/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.plan.sybase;

import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.plan.AbstractPlanModelBuilder;
import com.intellij.database.plan.AbstractXmlPlanModelBuilder;
import com.intellij.database.plan.PlanModel;
import com.intellij.database.plan.PlanRetrievalException;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CharSequenceReader;
import com.intellij.util.text.CharSequenceSubSequence;
import java.io.IOException;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.EnumSet;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpression;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SybasePlanModelBuilder
extends AbstractXmlPlanModelBuilder<Element> {
    private static final Map<String, PlanModel.NodeType> TYPE_MAPPING = ContainerUtil.newHashMap();
    private static final Map<String, PlanModel.NodeType> STATEMENT_MAPPING = ContainerUtil.newHashMap();
    private final String myStatement;
    private XPathExpression INDID_QUERY;
    private XPathExpression DETAILS_QUERY;
    private XPathExpression SUB_OPS_QUERY;
    private final Pattern RELATION_PATTERN;
    private final Pattern INDEX_PATTERN;
    private String myXml;

    public SybasePlanModelBuilder(@NotNull DataRequest.OwnerEx owner, @NotNull Consumer<PlanModel> consumer, @NotNull String statement) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/plan/sybase/SybasePlanModelBuilder", "<init>"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/database/plan/sybase/SybasePlanModelBuilder", "<init>"));
        }
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/intellij/database/plan/sybase/SybasePlanModelBuilder", "<init>"));
        }
        super(owner, consumer, EnumSet.of(PlanModel.Feature.TOTAL_COST, PlanModel.Feature.STARTUP_COST, PlanModel.Feature.NUM_ROWS));
        this.INDID_QUERY = this.compileXPath("Details/Indid");
        this.DETAILS_QUERY = this.compileXPath("Details");
        this.SUB_OPS_QUERY = this.compileXPath("*[not(self::Details)]");
        this.RELATION_PATTERN = Pattern.compile(".*:(.*)");
        this.INDEX_PATTERN = Pattern.compile(".*\\((.*)\\)");
        this.myStatement = statement;
    }

    @NotNull
    private String getPlanAsXml(final @NotNull Connection conn) throws PlanRetrievalException {
        if (conn == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "conn", "com/intellij/database/plan/sybase/SybasePlanModelBuilder", "getPlanAsXml"));
        }
        final Ref result = Ref.create();
        SybasePlanModelBuilder.useStatementWithPreserved(conn, new AbstractPlanModelBuilder.ResourceUser<Statement>(){

            @Override
            public void use(Statement statement) throws PlanRetrievalException, SQLException {
                try {
                    statement.executeUpdate("SET NOEXEC OFF\nSET PLAN FOR show_exec_xml OFF");
                    conn.commit();
                    statement.executeUpdate("SET STATEMENT_CACHE OFF\nSET PLAN FOR show_exec_xml TO MESSAGE ON\nSET NOEXEC ON\n");
                    conn.commit();
                    statement.executeUpdate(SybasePlanModelBuilder.this.myStatement + "\nSET NOEXEC OFF");
                    statement.getConnection().commit();
                    statement.execute("SELECT showplan_in_xml(0)");
                    SybasePlanModelBuilder.useResults(statement, new AbstractPlanModelBuilder.ResourceUser<ResultSet>(){

                        @Override
                        public void use(ResultSet resultSet) throws PlanRetrievalException, SQLException {
                            if (resultSet == null || !resultSet.next()) {
                                throw new PlanRetrievalException("No data returned for plan query");
                            }
                            if (resultSet.getMetaData().getColumnCount() != 1) {
                                throw new PlanRetrievalException("Database returned data in unknown format");
                            }
                            Clob res = resultSet.getClob(1);
                            if (res == null) {
                                throw new PlanRetrievalException("Database returned null plan");
                            }
                            String xml = res.getSubString(1L, (int)res.length());
                            if (!xml.startsWith("<?xml") || !xml.endsWith("</Emit>\n")) {
                                throw new PlanRetrievalException("Result is trimmed");
                            }
                            if (resultSet.next()) {
                                throw new PlanRetrievalException("Database returned too many data");
                            }
                            result.set((Object)xml);
                        }
                    });
                }
                finally {
                    try {
                        statement.executeUpdate("SET NOEXEC OFF\nSET SHOWPLAN OFF\nSET PLAN FOR show_exec_xml OFF\nSET STATEMENT_CACHE ON");
                        statement.getConnection().commit();
                    }
                    catch (SQLException sQLException) {}
                }
            }
        }, SybasePlanModelBuilder.setAutoCommit(false));
        String string = (String)result.get();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/plan/sybase/SybasePlanModelBuilder", "getPlanAsXml"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String dump() {
        String string = this.myXml;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/plan/sybase/SybasePlanModelBuilder", "dump"));
        }
        return string;
    }

    @Override
    public void processRaw(@NotNull DataRequest.Context context, @NotNull Connection connection) throws Exception {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/plan/sybase/SybasePlanModelBuilder", "processRaw"));
        }
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/plan/sybase/SybasePlanModelBuilder", "processRaw"));
        }
        this.myXml = this.getPlanAsXml(connection);
        this.showRaw();
        this.parseXml(this.myXml);
        this.modelReady();
    }

    private void parseXml(@NotNull String xml) {
        if (xml == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xml", "com/intellij/database/plan/sybase/SybasePlanModelBuilder", "parseXml"));
        }
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = dbf.newDocumentBuilder();
            this.openNode();
            int from = 0;
            while (from < xml.length()) {
                int end = xml.indexOf("<?xml", from + 1);
                if (end == -1) {
                    from = end = xml.length();
                    continue;
                }
                if (from != 0) {
                    Document doc = builder.parse(new InputSource((Reader)new CharSequenceReader((CharSequence)new CharSequenceSubSequence((CharSequence)xml, from, end))));
                    this.parseStatement(doc.getDocumentElement());
                }
                from = end;
            }
            this.closeNode(new PlanModel.GenericNode(PlanModel.NodeType.ROOT, null));
        }
        catch (ParserConfigurationException e) {
            throw new PlanRetrievalException("Failed to configure XML parser", e);
        }
        catch (SAXException e) {
            throw new PlanRetrievalException("Failed to parse XML", e);
        }
        catch (IOException e) {
            throw new PlanRetrievalException("Failed to parse XML", e);
        }
    }

    @Override
    @NotNull
    protected String parseRawDescription(final @NotNull Element element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/plan/sybase/SybasePlanModelBuilder", "parseRawDescription"));
        }
        String string = new Object(){
            StringBuilder sb = new StringBuilder();
            {
                Element details = SybasePlanModelBuilder.queryElement(SybasePlanModelBuilder.this.DETAILS_QUERY, element);
                if (details != null) {
                    this.visit("", details);
                }
            }

            void visit(String prefix, Element el) {
                if (!prefix.isEmpty()) {
                    StringBuilder sub = new StringBuilder();
                    for (int i2 = 0; i2 < el.getChildNodes().getLength(); ++i2) {
                        String s;
                        Text child = (Text)ObjectUtils.tryCast((Object)el.getChildNodes().item(i2), Text.class);
                        if (child == null || child.getNodeValue() == null || StringUtil.isEmpty((String)(s = child.getNodeValue().trim()))) continue;
                        sub.append(s);
                    }
                    if (sub.length() != 0) {
                        this.sb.append(prefix).append(" = ").append(sub.toString()).append(";\n");
                    }
                }
                for (int i3 = 0; i3 < el.getChildNodes().getLength(); ++i3) {
                    Element child = (Element)ObjectUtils.tryCast((Object)el.getChildNodes().item(i3), Element.class);
                    if (child == null || "Collection".equals(child.getTagName()) || "EVAL".equals(child.getTagName()) || "Vtuple".equals(child.getTagName())) continue;
                    this.visit(prefix + (prefix.isEmpty() ? "" : ".") + child.getTagName(), child);
                }
            }
        }.sb.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/plan/sybase/SybasePlanModelBuilder", "parseRawDescription"));
        }
        return string;
    }

    @Override
    @Nullable
    protected String parseAccessRelation(@NotNull Element element) {
        Matcher matcher;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/plan/sybase/SybasePlanModelBuilder", "parseAccessRelation"));
        }
        String relation = element.getAttribute("Label");
        if (relation != null && (matcher = this.RELATION_PATTERN.matcher(relation)).matches()) {
            return matcher.group(1);
        }
        return relation;
    }

    @Override
    @Nullable
    protected BigDecimal parsePlanNumRows(@NotNull Element element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/plan/sybase/SybasePlanModelBuilder", "parsePlanNumRows"));
        }
        return null;
    }

    @Override
    @Nullable
    protected String parseAccessIndex(@NotNull Element element) {
        Matcher m;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/plan/sybase/SybasePlanModelBuilder", "parseAccessIndex"));
        }
        Element indid = SybasePlanModelBuilder.queryElement(this.INDID_QUERY, element);
        if (indid != null && (m = this.INDEX_PATTERN.matcher(indid.getTextContent())).matches()) {
            return m.group(1);
        }
        return indid == null ? null : indid.getTextContent();
    }

    @Override
    protected void parsePlan(@NotNull Element state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/database/plan/sybase/SybasePlanModelBuilder", "parsePlan"));
        }
        this.openNode();
        this.parseSubPlans(state);
        String name = state.getTagName();
        PlanModel.NodeType type = TYPE_MAPPING.get(name);
        if (type == null) {
            type = PlanModel.NodeType.UNKNOWN;
        }
        if (type == PlanModel.NodeType.ACCESS) {
            Element indid = SybasePlanModelBuilder.queryElement(this.INDID_QUERY, state);
            type = indid != null && !indid.getTextContent().equals("0") ? PlanModel.NodeType.INDEX_SCAN : PlanModel.NodeType.SEQ_SCAN;
        }
        PlanModel.GenericNode node = this.createNode(state, type, name);
        this.closeNode(node);
    }

    @Override
    protected void parseSubPlans(@NotNull Element element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/plan/sybase/SybasePlanModelBuilder", "parseSubPlans"));
        }
        NodeList sub = SybasePlanModelBuilder.queryElements(this.SUB_OPS_QUERY, element);
        for (int i2 = 0; i2 < sub.getLength(); ++i2) {
            this.parsePlan((Element)sub.item(i2));
        }
    }

    @Override
    protected void parseStatement(@NotNull Element element) {
        PlanModel.NodeType type;
        Element startOp;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/plan/sybase/SybasePlanModelBuilder", "parseStatement"));
        }
        this.openNode();
        if (!"Emit".equals(element.getTagName())) {
            this.unsupportedFormat();
        }
        if ((startOp = this.querySingleElement(this.SUB_OPS_QUERY, element)) == null) {
            this.unsupportedFormat();
        }
        if ((type = STATEMENT_MAPPING.get(startOp.getTagName())) != null) {
            if ((startOp = this.querySingleElement(this.SUB_OPS_QUERY, startOp)) == null) {
                this.unsupportedFormat();
            }
        } else {
            type = PlanModel.NodeType.SELECT;
        }
        this.parsePlan(startOp);
        this.closeNode(this.createNode(element, type, null));
    }

    @Override
    @Nullable
    protected Double parseTotalCost(@NotNull Element element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/plan/sybase/SybasePlanModelBuilder", "parseTotalCost"));
        }
        return null;
    }

    @Override
    @Nullable
    protected Double parseStartupCost(@NotNull Element element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/plan/sybase/SybasePlanModelBuilder", "parseStartupCost"));
        }
        return null;
    }

    @Override
    protected boolean parseSubqueryCorrelated(@NotNull Element element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/plan/sybase/SybasePlanModelBuilder", "parseSubqueryCorrelated"));
        }
        return false;
    }

    @Override
    protected boolean parseSubqueryScalar(@NotNull Element element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/plan/sybase/SybasePlanModelBuilder", "parseSubqueryScalar"));
        }
        return false;
    }

    static {
        TYPE_MAPPING.put("Scan", PlanModel.NodeType.ACCESS);
        TYPE_MAPPING.put("Scalar", PlanModel.NodeType.VALUE);
        TYPE_MAPPING.put("HashUnion", PlanModel.NodeType.UNION);
        TYPE_MAPPING.put("MergeJoin", PlanModel.NodeType.MERGE_JOIN);
        TYPE_MAPPING.put("NLJOp", PlanModel.NodeType.NESTED_LOOPS);
        TYPE_MAPPING.put("NaryNLJoin", PlanModel.NodeType.NESTED_LOOPS);
        TYPE_MAPPING.put("HashJoin", PlanModel.NodeType.HASH_JOIN);
        TYPE_MAPPING.put("GroupSorted", PlanModel.NodeType.GROUP_BY);
        TYPE_MAPPING.put("Sort", PlanModel.NodeType.SORT);
        TYPE_MAPPING.put("HashDistinct", PlanModel.NodeType.HASH_UNIQUE);
        TYPE_MAPPING.put("HashVectAgg", PlanModel.NodeType.AGGREGATE);
        TYPE_MAPPING.put("UnionAll", PlanModel.NodeType.UNION_ALL);
        TYPE_MAPPING.put("MergeUnion", PlanModel.NodeType.UNION);
        TYPE_MAPPING.put("ScalarAgg", PlanModel.NodeType.AGGREGATE);
        TYPE_MAPPING.put("Restrict", PlanModel.NodeType.UNKNOWN);
        TYPE_MAPPING.put("Store", PlanModel.NodeType.TEMPORARY);
        TYPE_MAPPING.put("Sequencer", PlanModel.NodeType.SEQUENTIALLY);
        TYPE_MAPPING.put("RemoteScan", PlanModel.NodeType.ACCESS);
        TYPE_MAPPING.put("Scroll", PlanModel.NodeType.UNKNOWN);
        TYPE_MAPPING.put("RidJoin", PlanModel.NodeType.JOIN);
        TYPE_MAPPING.put("FilterOp", PlanModel.NodeType.FILTER);
        TYPE_MAPPING.put("Exchange", PlanModel.NodeType.OPERATION);
        TYPE_MAPPING.put("InsteadOf", PlanModel.NodeType.OPERATION);
        TYPE_MAPPING.put("InsteadOfTrigger", PlanModel.NodeType.OPERATION);
        TYPE_MAPPING.put("CursorScan", PlanModel.NodeType.ACCESS);
        STATEMENT_MAPPING.put("Insert", PlanModel.NodeType.INSERT);
        STATEMENT_MAPPING.put("Update", PlanModel.NodeType.UPDATE);
        STATEMENT_MAPPING.put("Delete", PlanModel.NodeType.DELETE);
    }
}

