/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid.editors;

import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.extractors.ObjectFormatter;
import com.intellij.database.run.ReservedCellValue;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.run.ui.grid.editors.BoundaryValueResolver;
import com.intellij.database.run.ui.grid.editors.FakeRangeFormatter;
import com.intellij.database.run.ui.grid.editors.FormatBasedGridCellEditor;
import com.intellij.database.run.ui.grid.editors.FormatBasedGridCellEditorFactory;
import com.intellij.database.run.ui.grid.editors.Formatter;
import com.intellij.database.run.ui.grid.editors.RangeFormatResolver;
import com.intellij.database.run.ui.grid.editors.lexers.PostgresRangeLexerAdapter;
import com.intellij.database.run.ui.grid.editors.lexers.PostgresRangeTokens;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ObjectUtils;
import com.intellij.util.textCompletion.TextCompletionProvider;
import java.io.Serializable;
import java.util.EventObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultRangeEditorFactory
extends FormatBasedGridCellEditorFactory {
    private static final char ELLIPSIS = '\u2026';

    @Override
    public int getSuitability(@NotNull DataGrid grid, @NotNull ModelIndex<DataConsumer.Row> row, @NotNull ModelIndex<DataConsumer.Column> column) {
        if (grid == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/run/ui/grid/editors/DefaultRangeEditorFactory", "getSuitability"));
        }
        if (row == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "row", "com/intellij/database/run/ui/grid/editors/DefaultRangeEditorFactory", "getSuitability"));
        }
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/run/ui/grid/editors/DefaultRangeEditorFactory", "getSuitability"));
        }
        DataConsumer.Column c = (DataConsumer.Column)ObjectUtils.assertNotNull((Object)grid.getDataModel(DataAccessType.DATABASE_DATA).getColumn(column));
        DatabaseDialectEx dialect = DataGridUtil.getDatabaseDialect(grid);
        return dialect.getFamilyId().isPostgres() && ObjectFormatter.isPostgresRangeType(c) ? 1 : 0;
    }

    @Override
    @NotNull
    protected Formatter getFormat(@NotNull DataGrid grid, @NotNull ModelIndex<DataConsumer.Row> row, @NotNull ModelIndex<DataConsumer.Column> column) {
        if (grid == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/run/ui/grid/editors/DefaultRangeEditorFactory", "getFormat"));
        }
        if (row == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "row", "com/intellij/database/run/ui/grid/editors/DefaultRangeEditorFactory", "getFormat"));
        }
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/run/ui/grid/editors/DefaultRangeEditorFactory", "getFormat"));
        }
        DataConsumer.Column c = (DataConsumer.Column)ObjectUtils.assertNotNull((Object)grid.getDataModel(DataAccessType.DATABASE_DATA).getColumn(column));
        DatabaseDialectEx dialect = DataGridUtil.getDatabaseDialect(grid);
        FakeRangeFormatter fakeRangeFormatter = RangeFormatResolver.resolveFormatter(grid.getObjectFormatter(), c, dialect);
        if (fakeRangeFormatter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/grid/editors/DefaultRangeEditorFactory", "getFormat"));
        }
        return fakeRangeFormatter;
    }

    @Override
    @NotNull
    protected FormatBasedGridCellEditor createEditorImpl(@NotNull Project project, final @NotNull DataGrid grid, final @NotNull Formatter format, @Nullable Object value, @Nullable ReservedCellValue nullValue, EventObject initiator, @Nullable TextCompletionProvider provider, @NotNull ModelIndex<DataConsumer.Column> column) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/run/ui/grid/editors/DefaultRangeEditorFactory", "createEditorImpl"));
        }
        if (grid == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/run/ui/grid/editors/DefaultRangeEditorFactory", "createEditorImpl"));
        }
        if (format == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "format", "com/intellij/database/run/ui/grid/editors/DefaultRangeEditorFactory", "createEditorImpl"));
        }
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/run/ui/grid/editors/DefaultRangeEditorFactory", "createEditorImpl"));
        }
        FormatBasedGridCellEditor.BoundedFormatBasedGridCellEditor<FakeRangeFormatter.ParsedRange> boundedFormatBasedGridCellEditor = new FormatBasedGridCellEditor.BoundedFormatBasedGridCellEditor<FakeRangeFormatter.ParsedRange>(project, grid, format, value, nullValue, initiator, column){
            private final FakeRangeFormatter myFormatter;
            {
                super(project, grid2, format2, value, nullValue, initiator, columnModelIndex);
                this.myFormatter = (FakeRangeFormatter)format;
            }

            @Override
            protected Object createObject(@NotNull FakeRangeFormatter.ParsedRange internalValue) {
                if (internalValue == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "internalValue", "com/intellij/database/run/ui/grid/editors/DefaultRangeEditorFactory$1", "createObject"));
                }
                return this.myFormatter.rebuild(internalValue);
            }

            @Override
            protected FakeRangeFormatter.ParsedRange getInternalValue() {
                return this.myFormatter.parseHonestly(this.getTextField().getText());
            }

            @Override
            protected String getBoundaryString(@NotNull FakeRangeFormatter.ParsedRange internalValue) {
                if (internalValue == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "internalValue", "com/intellij/database/run/ui/grid/editors/DefaultRangeEditorFactory$1", "getBoundaryString"));
                }
                Pair<String, String> values = this.getRangeValues(internalValue);
                return values == null ? null : this.buildRangeString(internalValue, values);
            }

            @Override
            protected boolean isSameValueInEditor(@NotNull FakeRangeFormatter.ParsedRange internalValue, @NotNull String boundaryString) {
                if (internalValue == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "internalValue", "com/intellij/database/run/ui/grid/editors/DefaultRangeEditorFactory$1", "isSameValueInEditor"));
                }
                if (boundaryString == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "boundaryString", "com/intellij/database/run/ui/grid/editors/DefaultRangeEditorFactory$1", "isSameValueInEditor"));
                }
                PostgresRangeLexerAdapter lexer = new PostgresRangeLexerAdapter();
                Pair rangeValues = (Pair)ObjectUtils.assertNotNull(this.getRangeValues(internalValue));
                lexer.start(this.getTextField().getText());
                return !(this.hasNextSuitableToken((Lexer)lexer, PostgresRangeTokens.COMMA) && !this.itWasInfinity((String)rangeValues.getFirst(), (Lexer)lexer) || this.hasNextSuitableToken((Lexer)lexer, PostgresRangeTokens.RIGHT_BRACKET) && !this.itWasInfinity((String)rangeValues.getSecond(), (Lexer)lexer));
            }

            private boolean hasNextSuitableToken(@NotNull Lexer lexer, @NotNull IElementType endToken) {
                if (lexer == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lexer", "com/intellij/database/run/ui/grid/editors/DefaultRangeEditorFactory$1", "hasNextSuitableToken"));
                }
                if (endToken == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endToken", "com/intellij/database/run/ui/grid/editors/DefaultRangeEditorFactory$1", "hasNextSuitableToken"));
                }
                while (lexer.getTokenType() != null && lexer.getTokenType() != PostgresRangeTokens.VALUE && lexer.getTokenType() != endToken) {
                    lexer.advance();
                }
                return lexer.getTokenType() == PostgresRangeTokens.VALUE;
            }

            private boolean itWasInfinity(String rangeValue, Lexer lexer) {
                GridModel model = grid.getDataModel(DataAccessType.DATABASE_DATA);
                BoundaryValueResolver resolver = BoundaryValueResolver.getResolver(DataGridUtil.getDatabaseDialect(grid), (DataConsumer.Column)model.getColumn(this.myColumnModelIndex));
                Object boundary = resolver.createFromBoundary(lexer.getTokenText());
                lexer.advance();
                return boundary != null || rangeValue == null;
            }

            private String buildRangeString(@NotNull FakeRangeFormatter.ParsedRange internalValue, @NotNull Pair<String, String> rangeValues) {
                if (internalValue == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "internalValue", "com/intellij/database/run/ui/grid/editors/DefaultRangeEditorFactory$1", "buildRangeString"));
                }
                if (rangeValues == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rangeValues", "com/intellij/database/run/ui/grid/editors/DefaultRangeEditorFactory$1", "buildRangeString"));
                }
                return internalValue.getLeftBrace() + (rangeValues.getFirst() == null ? Character.valueOf('\u2026') : (Serializable)rangeValues.getFirst()) + ',' + (rangeValues.getSecond() == null ? Character.valueOf('\u2026') : (Serializable)rangeValues.getSecond()) + internalValue.getRightBrace();
            }

            private Pair<String, String> getRangeValues(@NotNull FakeRangeFormatter.ParsedRange internalValue) {
                if (internalValue == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "internalValue", "com/intellij/database/run/ui/grid/editors/DefaultRangeEditorFactory$1", "getRangeValues"));
                }
                if (internalValue == FakeRangeFormatter.ParsedRange.EMPTY) {
                    return null;
                }
                Object start = internalValue.getStart();
                Object end = internalValue.getEnd();
                GridModel model = grid.getDataModel(DataAccessType.DATABASE_DATA);
                BoundaryValueResolver resolver = BoundaryValueResolver.getResolver(DataGridUtil.getDatabaseDialect(grid), (DataConsumer.Column)model.getColumn(this.myColumnModelIndex));
                String startString = start == null ? null : resolver.resolve(start);
                String endString = end == null ? null : resolver.resolve(end);
                return startString == null && endString == null ? null : Pair.create((Object)startString, (Object)endString);
            }
        };
        if (boundedFormatBasedGridCellEditor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/grid/editors/DefaultRangeEditorFactory", "createEditorImpl"));
        }
        return boundedFormatBasedGridCellEditor;
    }
}

