/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid.editors;

import com.intellij.database.run.ui.grid.editors.DateAndTimeFormatter;
import com.intellij.database.run.ui.grid.editors.Formatter;
import java.text.ParseException;
import java.text.ParsePosition;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import org.jetbrains.annotations.NotNull;

public class EraDateAndTimeFormatter
implements Formatter {
    private final DateAndTimeFormatter myRegularFormatter;
    private final DateAndTimeFormatter myEraFormatter;

    public EraDateAndTimeFormatter(@NotNull DateAndTimeFormatter regularFormatter, @NotNull DateAndTimeFormatter eraFormatter) {
        if (regularFormatter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "regularFormatter", "com/intellij/database/run/ui/grid/editors/EraDateAndTimeFormatter", "<init>"));
        }
        if (eraFormatter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "eraFormatter", "com/intellij/database/run/ui/grid/editors/EraDateAndTimeFormatter", "<init>"));
        }
        this.myRegularFormatter = regularFormatter;
        this.myEraFormatter = eraFormatter;
    }

    @Override
    public Object parse(@NotNull String value) throws ParseException {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/database/run/ui/grid/editors/EraDateAndTimeFormatter", "parse"));
        }
        return this.myEraFormatter.parse(value);
    }

    @Override
    public Object parse(@NotNull String value, @NotNull ParsePosition position) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/database/run/ui/grid/editors/EraDateAndTimeFormatter", "parse"));
        }
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/database/run/ui/grid/editors/EraDateAndTimeFormatter", "parse"));
        }
        return this.myEraFormatter.parse(value, position);
    }

    @Override
    public String format(@NotNull Object value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/database/run/ui/grid/editors/EraDateAndTimeFormatter", "format"));
        }
        return this.getFormatter(value).format(value);
    }

    public String toString() {
        return this.myRegularFormatter.toString();
    }

    private Formatter getFormatter(@NotNull Object value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/database/run/ui/grid/editors/EraDateAndTimeFormatter", "getFormatter"));
        }
        TemporalAccessor accessor = this.myRegularFormatter.getTemporalAccessor(value);
        int era = accessor.isSupported(ChronoField.ERA) ? accessor.get(ChronoField.ERA) : 1;
        return era == 0 ? this.myEraFormatter : this.myRegularFormatter;
    }
}

