/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid.editors;

import com.intellij.openapi.Disposable;
import com.intellij.util.Consumer;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface GridCellEditor
extends Disposable {
    @NotNull
    public JComponent getComponent();

    @Nullable
    public Object getValue();

    public boolean stop();

    public void cancel();

    public boolean isColumnSpanAllowed();

    public boolean isMaximizationAllowed();

    public void setEditingListener(@NotNull Consumer<Object> var1);

    public static abstract class Adapter
    implements GridCellEditor {
        private Consumer<Object> myEditingListener;

        @Override
        public boolean stop() {
            return true;
        }

        @Override
        public void cancel() {
        }

        public void dispose() {
        }

        @Override
        public boolean isColumnSpanAllowed() {
            return true;
        }

        @Override
        public boolean isMaximizationAllowed() {
            return false;
        }

        @Override
        public void setEditingListener(@NotNull Consumer<Object> listener) {
            if (listener == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/database/run/ui/grid/editors/GridCellEditor$Adapter", "setEditingListener"));
            }
            this.myEditingListener = listener;
        }

        protected final void fireEditing(@Nullable Object object) {
            if (this.myEditingListener != null) {
                this.myEditingListener.consume(object);
            }
        }
    }
}

