/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.scripting;

import com.intellij.coding.CompositeText;
import com.intellij.database.DatabaseFamilyId;
import com.intellij.database.dataSource.srcStorage.PersistentMarkup;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.dialects.DatabaseDialects;
import com.intellij.database.introspection.GenericIntrospectorLegacyModelUtils;
import com.intellij.database.model.CasingProvider;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ModelFun;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNamespaceOwner;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.basic.BasicScriptable;
import com.intellij.database.model.basic.BasicSourceAware;
import com.intellij.database.scripting.ScriptingService;
import com.intellij.database.scripting.ScriptingTask;
import com.intellij.database.util.CharOut;
import com.intellij.database.util.DdlBuilder;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.Rdbms;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0019\b\u0010\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u000fH\u0016J\b\u0010 \u001a\u00020\u001eH\u0016J\b\u0010!\u001a\u00020\"H\u0016J\u0013\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$H\u0016\u00a2\u0006\u0002\u0010&J\b\u0010'\u001a\u00020%H\u0016J\u001a\u0010(\u001a\u00020\u001e2\u0006\u0010)\u001a\u00020*2\b\u0010\u001f\u001a\u0004\u0018\u00010\u000fH\u0016J&\u0010(\u001a\u00020\u001e2\u0006\u0010)\u001a\u00020*2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020-0,2\u0006\u0010.\u001a\u00020/H\u0016J\u001e\u0010(\u001a\u00020\u001e2\u0006\u0010)\u001a\u00020*2\f\u00100\u001a\b\u0012\u0004\u0012\u00020\u000f01H\u0016J\u0010\u00102\u001a\u00020\u001e2\u0006\u0010\u0004\u001a\u00020\u0005H\u0016R\u0012\u0010\u0007\u001a\u00060\bj\u0002`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR(\u0010\u0010\u001a\u0004\u0018\u00010\u000f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f@RX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R$\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u0005@RX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u00a8\u00063"}, d2={"Lcom/intellij/database/scripting/LegacyScriptingService;", "Lcom/intellij/database/scripting/ScriptingService;", "model", "Lcom/intellij/database/model/basic/BasicModel;", "database", "Lcom/intellij/database/model/basic/BasicDatabase;", "(Lcom/intellij/database/model/basic/BasicModel;Lcom/intellij/database/model/basic/BasicDatabase;)V", "buffer", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "builder", "Lcom/intellij/database/util/DdlBuilder;", "getBuilder", "()Lcom/intellij/database/util/DdlBuilder;", "<set-?>", "Lcom/intellij/database/model/basic/BasicSchema;", "currentSchema", "getCurrentSchema", "()Lcom/intellij/database/model/basic/BasicSchema;", "setCurrentSchema", "(Lcom/intellij/database/model/basic/BasicSchema;)V", "getDatabase", "()Lcom/intellij/database/model/basic/BasicDatabase;", "setDatabase", "(Lcom/intellij/database/model/basic/BasicDatabase;)V", "markupBuilder", "Lcom/intellij/database/dataSource/srcStorage/PersistentMarkup$Builder;", "getModel", "()Lcom/intellij/database/model/basic/BasicModel;", "assumeCurrentSchema", "", "schema", "clearScript", "getScript", "Lcom/intellij/coding/CompositeText;", "getScriptStatements", "", "", "()[Ljava/lang/String;", "getScriptText", "makeScript", "task", "Lcom/intellij/database/scripting/ScriptingTask;", "objects", "", "Lcom/intellij/database/model/basic/BasicScriptable;", "recursive", "", "schemata", "", "useDatabase", "database-impl"})
public final class LegacyScriptingService
implements ScriptingService {
    @NotNull
    private final DdlBuilder builder;
    @NotNull
    private final BasicModel model;
    @NotNull
    private BasicDatabase database;
    @Nullable
    private BasicSchema currentSchema;
    private final PersistentMarkup.Builder markupBuilder;
    private final StringBuilder buffer;

    @NotNull
    public final DdlBuilder getBuilder() {
        return this.builder;
    }

    @NotNull
    public final BasicModel getModel() {
        return this.model;
    }

    @Override
    @NotNull
    public BasicDatabase getDatabase() {
        return this.database;
    }

    private void setDatabase(BasicDatabase basicDatabase) {
        this.database = basicDatabase;
    }

    @Override
    @Nullable
    public BasicSchema getCurrentSchema() {
        return this.currentSchema;
    }

    private void setCurrentSchema(BasicSchema basicSchema) {
        this.currentSchema = basicSchema;
    }

    @Override
    public void useDatabase(@NotNull BasicDatabase database) {
        Intrinsics.checkParameterIsNotNull((Object)database, (String)"database");
        if (Intrinsics.areEqual((Object)this.getDatabase(), (Object)database) ^ true) {
            this.setDatabase(database);
            this.setCurrentSchema(ModelFun.getCurrentSchema(database));
        }
    }

    @Override
    public void assumeCurrentSchema(@Nullable BasicSchema schema) {
        if (Intrinsics.areEqual((Object)this.getCurrentSchema(), (Object)schema) ^ true) {
            this.setCurrentSchema(schema);
            if (schema != null) {
                BasicNamespaceOwner basicNamespaceOwner = schema.getDbParent();
                if (basicNamespaceOwner == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.intellij.database.model.basic.BasicDatabase");
                }
                this.setDatabase((BasicDatabase)basicNamespaceOwner);
            }
        }
    }

    @Override
    public void makeScript(@NotNull ScriptingTask task, @Nullable BasicSchema schema) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)task), (String)"task");
        if (schema == null) {
            return;
        }
        this.builder.withCasing(schema);
        this.builder.element(schema);
    }

    @Override
    public void makeScript(@NotNull ScriptingTask task, @NotNull List<? extends BasicSchema> schemata) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)task), (String)"task");
        Intrinsics.checkParameterIsNotNull(schemata, (String)"schemata");
        for (BasicSchema basicSchema : schemata) {
            this.makeScript(task, basicSchema);
        }
    }

    @Override
    public void makeScript(@NotNull ScriptingTask task, @NotNull Collection<? extends BasicScriptable> objects, boolean recursive) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)task), (String)"task");
        Intrinsics.checkParameterIsNotNull(objects, (String)"objects");
        BasicSchema basicSchema = this.getCurrentSchema();
        this.builder.withCasing(basicSchema != null ? (CasingProvider)basicSchema : (CasingProvider)this.getDatabase());
        for (BasicScriptable basicScriptable : objects) {
            this.builder.element(basicScriptable);
        }
    }

    @Override
    @NotNull
    public String[] getScriptStatements() {
        String string = "not implemented yet";
        throw (Throwable)new NotImplementedError("An operation is not implemented: " + string);
    }

    @Override
    @NotNull
    public String getScriptText() {
        String string = this.buffer.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"buffer.toString()");
        return string;
    }

    @Override
    @NotNull
    public CompositeText getScript() {
        PersistentMarkup persistentMarkup = this.markupBuilder.build(this.buffer);
        Intrinsics.checkExpressionValueIsNotNull((Object)persistentMarkup, (String)"markupBuilder.build(buffer)");
        return persistentMarkup;
    }

    @Override
    public void clearScript() {
        this.buffer.delete(0, this.buffer.length());
        this.markupBuilder.clear();
    }

    public LegacyScriptingService(@NotNull BasicModel model, @Nullable BasicDatabase database) {
        Intrinsics.checkParameterIsNotNull((Object)model, (String)"model");
        this.markupBuilder = new PersistentMarkup.Builder();
        this.buffer = new StringBuilder(4096);
        this.builder = new DdlBuilder(new CharOut(){

            @Override
            @NotNull
            public CharOut append(@NotNull CharSequence seq) {
                Intrinsics.checkParameterIsNotNull((Object)seq, (String)"seq");
                buffer.append(seq);
                markupBuilder.add(CompositeText.Kind.PLAIN_TEXT, buffer.length());
                return this;
            }

            @Override
            public long length() {
                return buffer.length();
            }

            @Override
            @Nullable
            public <T> T tryCast(@Nullable Class<T> clazz) {
                return null;
            }
        }){

            @Override
            @NotNull
            public DdlBuilder element(@NotNull DasObject element) {
                CompositeText src;
                Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
                CompositeText compositeText = src = element instanceof BasicSourceAware ? ((BasicSourceAware)element).getSourceText() : null;
                if (src == null) {
                    DdlBuilder ddlBuilder = super.element(element);
                    Intrinsics.checkExpressionValueIsNotNull((Object)ddlBuilder, (String)"super.element(element)");
                    return ddlBuilder;
                }
                for (CompositeText.Fragment f : src.getFragments()) {
                    buffer.append(f.getText());
                    markupBuilder.add(f.getKind(), buffer.length());
                }
                return this;
            }
        };
        Rdbms rdbms = model.getRdbms();
        DatabaseFamilyId databaseFamilyId = GenericIntrospectorLegacyModelUtils.findFamily(rdbms);
        if (databaseFamilyId == null) {
            throw (Throwable)new IllegalStateException("No Family for RDBMS " + rdbms);
        }
        DatabaseFamilyId family = databaseFamilyId;
        DatabaseDialectEx databaseDialectEx = DatabaseDialects.findByFamily(family);
        if (databaseDialectEx == null) {
            throw (Throwable)new IllegalStateException("No Dialect for DB Family " + family);
        }
        DatabaseDialectEx dialect = databaseDialectEx;
        this.builder.withDialect(dialect);
        this.model = model;
        BasicDatabase basicDatabase = database;
        if (basicDatabase == null) {
            basicDatabase = model.getRoot().getCurrentDatabase();
        }
        if (basicDatabase == null) {
            throw (Throwable)new IllegalStateException("No current database");
        }
        this.setDatabase(basicDatabase);
        this.setCurrentSchema(ModelFun.getCurrentSchema(this.getDatabase()));
    }
}

