/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.scripting;

import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.scripting.LegacyScriptingFactory;
import com.intellij.database.scripting.ModernScriptingFactory;
import com.intellij.database.scripting.ScriptingFactory;
import com.intellij.database.scripting.ScriptingPreferences;
import com.intellij.database.scripting.ScriptingService;
import com.intellij.database.scripting.TransitionalScriptingFactoryKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.Rdbms;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0013"}, d2={"Lcom/intellij/database/scripting/TransitionalScriptingFactory;", "Lcom/intellij/database/scripting/ScriptingFactory;", "()V", "legacy", "Lcom/intellij/database/scripting/LegacyScriptingFactory;", "getLegacy", "()Lcom/intellij/database/scripting/LegacyScriptingFactory;", "modern", "Lcom/intellij/database/scripting/ModernScriptingFactory;", "getModern", "()Lcom/intellij/database/scripting/ModernScriptingFactory;", "createScriptingService", "Lcom/intellij/database/scripting/ScriptingService;", "model", "Lcom/intellij/database/model/basic/BasicModel;", "database", "Lcom/intellij/database/model/basic/BasicDatabase;", "preferences", "Lcom/intellij/database/scripting/ScriptingPreferences;", "database-impl"})
public final class TransitionalScriptingFactory
implements ScriptingFactory {
    @NotNull
    private final ModernScriptingFactory modern = new ModernScriptingFactory();
    @NotNull
    private final LegacyScriptingFactory legacy = new LegacyScriptingFactory();

    @NotNull
    public final ModernScriptingFactory getModern() {
        return this.modern;
    }

    @NotNull
    public final LegacyScriptingFactory getLegacy() {
        return this.legacy;
    }

    @Override
    @NotNull
    public ScriptingService createScriptingService(@NotNull BasicModel model, @Nullable BasicDatabase database, @Nullable ScriptingPreferences preferences) {
        Intrinsics.checkParameterIsNotNull((Object)model, (String)"model");
        Rdbms rdbms = model.getRdbms();
        Intrinsics.checkExpressionValueIsNotNull((Object)rdbms, (String)"model.rdbms");
        return TransitionalScriptingFactoryKt.isModernCodeGenerator(rdbms) ? this.modern.createScriptingService(model, database, preferences) : this.legacy.createScriptingService(model, database, preferences);
    }
}

