/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view;

import com.intellij.database.DatabaseFamilyId;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.validation.DataSourceProblem;
import com.intellij.database.dataSource.validation.DatabaseConfigValidator;
import com.intellij.database.editor.DatabaseEditorHelper;
import com.intellij.database.editor.DatabaseOpenFileDescriptor;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasForeignKey;
import com.intellij.database.model.DasIndex;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasOperator;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasSynonym;
import com.intellij.database.model.DasTableKey;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.model.ModelFun;
import com.intellij.database.model.MultiRef;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.SequenceIdentity;
import com.intellij.database.model.basic.BasicCheck;
import com.intellij.database.model.basic.BasicForeignKey;
import com.intellij.database.model.basic.BasicIndex;
import com.intellij.database.model.basic.BasicKey;
import com.intellij.database.model.basic.BasicSequence;
import com.intellij.database.model.basic.BasicSourceAware;
import com.intellij.database.model.basic.BasicTrigger;
import com.intellij.database.model.impl.ModelDescribing;
import com.intellij.database.model.postgres.PostgresModelFun;
import com.intellij.database.model.postgres.PostgresTable;
import com.intellij.database.model.postgres.PostgresTrigger;
import com.intellij.database.model.properties.TrigEvent;
import com.intellij.database.model.properties.TrigTurn;
import com.intellij.database.psi.DbCustomType;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbElementImpl;
import com.intellij.database.psi.DbNamespaceImpl;
import com.intellij.database.psi.DbPackage;
import com.intellij.database.psi.DbPresentation;
import com.intellij.database.psi.DbRoutine;
import com.intellij.database.psi.DbTable;
import com.intellij.database.psi.DbTrigger;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.QNameUtil;
import com.intellij.database.view.DatabaseStructure;
import com.intellij.database.view.DatabaseView;
import com.intellij.database.view.DatabaseViewOptions;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.ide.util.treeView.PresentableNodeDescriptor;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.pom.NavigatableAdapter;
import com.intellij.sql.database.SqlDataSource;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.ComparableObject;
import com.intellij.util.ui.update.ComparableObjectCheck;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbNodeDescriptor
extends PresentableNodeDescriptor
implements DataProvider,
ComparableObject {
    public static final DbNodeDescriptor[] EMPTY_ARRAY = new DbNodeDescriptor[0];
    private final DbElement myElement;

    public DbNodeDescriptor(DbElement element, NodeDescriptor parent) {
        super(element.getProject(), parent);
        this.myElement = element;
    }

    public DbElement getElement() {
        return this.myElement;
    }

    protected void update(PresentationData presentation) {
        BasicCheck check;
        String predicate;
        BasicIndex index;
        BasicForeignKey foreignKey;
        SimpleTextAttributes style;
        DbElement element = this.getElement();
        if (!element.isValid()) {
            return;
        }
        presentation.setChanged(true);
        final Icon icon = element.getIcon();
        presentation.setIcon(icon == null ? null : new Icon(){

            @Override
            public void paintIcon(Component c, Graphics g, int x, int y) {
                icon.paintIcon(c, g, x, y);
            }

            @Override
            public int getIconWidth() {
                return icon.getIconWidth() + 3;
            }

            @Override
            public int getIconHeight() {
                return icon.getIconHeight();
            }
        });
        SimpleTextAttributes grayAttrs = UIUtil.isUnderDarcula() ? SimpleTextAttributes.GRAY_ATTRIBUTES : SimpleTextAttributes.GRAYED_ATTRIBUTES;
        boolean hasErrors = false;
        boolean hasWarnings = false;
        Object delegate = element.getDelegate();
        if (!this.isValid()) {
            hasErrors = true;
        } else if (element instanceof DbDataSource && delegate instanceof LocalDataSource) {
            hasErrors = !DbImplUtil.canConnectTo(element);
            hasWarnings = hasErrors;
            if (!hasErrors) {
                for (DataSourceProblem problem : DatabaseConfigValidator.getProblems(delegate, null)) {
                    DataSourceProblem.Level level = problem.getLevel();
                    if (level == DataSourceProblem.Level.WARNING) {
                        hasWarnings = true;
                        continue;
                    }
                    if (level != DataSourceProblem.Level.ERROR) continue;
                    hasErrors = true;
                    hasWarnings = true;
                }
            }
        } else if (delegate instanceof BasicSourceAware) {
            hasErrors = ((BasicSourceAware)delegate).isInvalid();
        }
        String nodeText = DbPresentation.getPresentableName((DasObject)element, false);
        presentation.setPresentableText(nodeText);
        SimpleTextAttributes simpleTextAttributes = style = DbPresentation.isUnnamed((DasObject)element) ? grayAttrs : SimpleTextAttributes.REGULAR_ATTRIBUTES;
        if (hasErrors || hasWarnings) {
            SimpleTextAttributes waved = new SimpleTextAttributes(8, null, (Color)(hasErrors ? JBColor.RED : JBColor.ORANGE));
            style = SimpleTextAttributes.merge((SimpleTextAttributes)style, (SimpleTextAttributes)waved);
        }
        if (hasErrors && delegate instanceof LocalDataSource && !DbImplUtil.hasDriverFiles((LocalDataSource)((Object)delegate))) {
            presentation.setTooltip("Can't find the driver, open preferences to download");
        }
        if (DbImplUtil.isConnected(element)) {
            style = SimpleTextAttributes.merge((SimpleTextAttributes)style, (SimpleTextAttributes)SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
            presentation.setTooltip("Connected");
        }
        presentation.addText(new PresentableNodeDescriptor.ColoredFragment(StringUtil.isEmpty((String)nodeText) ? "<unnamed>" : nodeText, null, style));
        if (element instanceof DbDataSource || element instanceof DbNamespaceImpl) {
            String textExt;
            DbElement root2;
            DatabaseViewOptions options = DatabaseView.getDatabaseView(this.getProject()).getViewOptions();
            DbElement dbElement = root2 = options.SHOW_INTERMEDIATE ? element : DatabaseStructure.getTopSingleRoot(element);
            if (root2 != element && StringUtil.isNotEmpty((String)(textExt = QNameUtil.getQualifiedName(root2)))) {
                presentation.addText(" (" + textExt + ")", grayAttrs);
            }
        } else if (element instanceof DbCustomType) {
            String description = DbImplUtil.getCustomTypeShortDescription(element.getDelegate());
            if (description != null) {
                presentation.addText(' ' + description, grayAttrs);
            }
        } else if (element instanceof DasColumn) {
            DasColumn column = (DasColumn)element;
            String d = column.getDataType().getSpecification();
            if (d.length() > 0) {
                presentation.addText(" " + d, grayAttrs);
            }
            if (DasUtil.isAutoVal((DasColumn)column)) {
                presentation.addText(" (auto increment)", grayAttrs);
            }
        } else if (delegate instanceof DasTypedObject) {
            DasTypedObject o = (DasTypedObject)delegate;
            String type = o.getDataType().getSpecification();
            presentation.addText(" " + type, grayAttrs);
        } else if (element instanceof DbTable) {
            ObjectKind type = element.getKind();
            if (!DbImplUtil.isDataTable(type)) {
                presentation.addText(" " + element.getTypeName(), grayAttrs);
            }
            if (delegate instanceof PostgresTable) {
                PostgresTable pt = (PostgresTable)delegate;
                boolean hasAncestors = !pt.getAncestorIds().isEmpty();
                boolean hasSuccessors = !pt.getSuccessorIds().isEmpty();
                String s = "";
                if (hasAncestors) {
                    s = " based on (" + ModelFun.namesAsString(PostgresModelFun.getAncestors(pt)) + ')';
                }
                if (hasAncestors && hasSuccessors) {
                    s = s + " and";
                }
                if (hasSuccessors) {
                    s = s + " the base for {" + ModelFun.namesAsString(PostgresModelFun.getSuccessors(pt)) + '}';
                }
                if (hasAncestors || hasSuccessors) {
                    presentation.addText(" " + s, grayAttrs);
                }
            }
        } else if (element instanceof DbRoutine) {
            DbRoutine procedure = (DbRoutine)element;
            StringBuilder sb = new StringBuilder();
            DdlBuilder builder = new DdlBuilder(sb).configureFor(element);
            DbImplUtil.getDatabaseDialect((DbElement)procedure).sqlDefinePrototype(builder, (DasRoutine)procedure, false, true);
            presentation.addText(sb.toString(), grayAttrs);
        } else if (element instanceof BasicKey) {
            BasicKey key = (BasicKey)element;
            presentation.addText(" " + StringUtil.join(key.getColNames(), (String)", "), grayAttrs);
        } else if (element instanceof DasTableKey) {
            presentation.addText(" " + DbNodeDescriptor.multiRef((MultiRef<? extends DasTypedObject>)((DasTableKey)element).getColumnsRef()), grayAttrs);
        } else if (element instanceof BasicForeignKey) {
            foreignKey = (BasicForeignKey)element;
            String referencingColumns = StringUtil.join(foreignKey.getColNames(), (String)", ");
            String arrowToReferenced = DbNodeDescriptor.arrowToColumns(foreignKey.getRefTableName(), foreignKey.getRefColumns());
            presentation.addText(" " + referencingColumns + " " + arrowToReferenced, grayAttrs);
        } else if (element instanceof DasForeignKey) {
            foreignKey = (DasForeignKey)element;
            String referencingColumns = DbNodeDescriptor.multiRef((MultiRef<? extends DasTypedObject>)foreignKey.getColumnsRef());
            String arrowToReferenced = DbNodeDescriptor.arrowToColumns(foreignKey.getRefTableName(), (MultiRef<? extends DasTypedObject>)foreignKey.getRefColumns());
            presentation.addText(" " + referencingColumns + " " + arrowToReferenced, grayAttrs);
        } else if (delegate instanceof BasicIndex) {
            index = (BasicIndex)delegate;
            String unique = index.isUnique() ? " UNIQUE" : "";
            String indexingItems = ModelDescribing.describeIndexingItems(index);
            presentation.addText(" (" + indexingItems + ")" + unique, grayAttrs);
            String condition = index.getCondition();
            if (condition != null) {
                presentation.addText(" where " + condition, grayAttrs);
            }
        } else if (element instanceof DasIndex) {
            index = (DasIndex)element;
            String unique = index.isUnique() ? " UNIQUE" : "";
            String columns = DbNodeDescriptor.multiRef((MultiRef<? extends DasTypedObject>)index.getColumnsRef());
            presentation.addText(" " + columns + unique, grayAttrs);
        } else if (element instanceof DasSynonym) {
            DasSynonym synonym = (DasSynonym)element;
            Iterable path = synonym.getTargetPath();
            String pathString = StringUtil.join((Iterable)path, (String)".");
            if (pathString.length() > 0) {
                String text = " " + DbNodeDescriptor.arrow() + " " + pathString;
                presentation.addText(text, grayAttrs);
            }
        } else if (delegate instanceof BasicSequence) {
            BasicSequence seq = (BasicSequence)delegate;
            SequenceIdentity si = seq.getSequenceIdentity();
            if (si != null) {
                String specification = si.getSpecification();
                presentation.addText(" " + specification, grayAttrs);
            }
        } else if (delegate instanceof DasOperator) {
            DasOperator op = (DasOperator)delegate;
            DasOperator.OperatorNotation notation = op.getOperatorNotation();
            StringBuilder res = new StringBuilder();
            List args = op.getArgumentTypes();
            String resType = op.getResultType().getSpecification();
            if (notation == DasOperator.OperatorNotation.INFIX) {
                res.append(StringUtil.join((Collection)args, t -> t.getSpecification(), (String)(" " + op.getName() + " ")));
            } else {
                if (notation == DasOperator.OperatorNotation.PREFIX) {
                    res.append(op.getName());
                }
                if (args.size() != 1) {
                    res.append("(");
                }
                res.append(StringUtil.join((Collection)args, t -> t.getSpecification(), (String)", "));
                if (args.size() != 1) {
                    res.append(")");
                }
                if (notation == DasOperator.OperatorNotation.POSTFIX) {
                    res.append(op.getName());
                }
            }
            presentation.addText("    " + res + " " + DbNodeDescriptor.arrow() + " " + resType, grayAttrs);
        } else if (delegate instanceof BasicTrigger) {
            String condition;
            Set<TrigEvent> events;
            BasicTrigger trigger2 = (BasicTrigger)delegate;
            TrigTurn turn = trigger2.getTurn();
            if (turn != null) {
                String turnText = StringUtil.join((Iterable)JBIterable.of((Object[])StringUtil.toLowerCase((String)turn.toString()).split("_")).filter(w -> !w.equals("stmt") && !w.equals("row")), (String)" ");
                presentation.addText(" " + turnText, grayAttrs);
            }
            if (!(events = trigger2.getEvents()).isEmpty()) {
                String eventsText = StringUtil.join((Iterable)JBIterable.from(events).transform(e -> {
                    List<String> cols3 = trigger2.getColNames();
                    if (e == TrigEvent.UPDATE && !cols3.isEmpty()) {
                        return "update of " + StringUtil.join(cols3, (String)", ");
                    }
                    return StringUtil.toLowerCase((String)e.toString());
                }), (String)", ");
                presentation.addText(" " + eventsText, grayAttrs);
            }
            if ((condition = trigger2.getCondition()) != null) {
                if (!condition.startsWith("(")) {
                    condition = "(" + condition + ")";
                }
                condition = StringUtil.shortenTextWithEllipsis((String)condition, (int)20, (int)1, (boolean)true);
                presentation.addText(" " + condition, grayAttrs);
            }
            if (trigger2 instanceof PostgresTrigger) {
                String routineName = PostgresModelFun.getCallRoutineName((PostgresTrigger)trigger2);
                presentation.addText(' ' + DbNodeDescriptor.arrow() + ' ' + routineName, grayAttrs);
            }
        } else if (delegate instanceof BasicCheck && (predicate = (check = (BasicCheck)delegate).getPredicate()) != null) {
            if (!predicate.startsWith("(")) {
                predicate = "(" + predicate + ")";
            }
            predicate = StringUtil.shortenTextWithEllipsis((String)predicate, (int)20, (int)1, (boolean)true);
            presentation.addText(" " + predicate, grayAttrs);
        }
    }

    public PresentableNodeDescriptor getChildToHighlightAt(int index) {
        return null;
    }

    @Nullable
    public Object getData(@NonNls String dataId) {
        return DbNodeDescriptor.getData(dataId, this.getElement());
    }

    static Object getData(@NonNls String dataId, DbElement element) {
        if (CommonDataKeys.NAVIGATABLE.is(dataId)) {
            final Project project = element.getProject();
            final Object delegate = ContainerUtil.getFirstItem(((DbElementImpl)element).getDelegates());
            if (delegate instanceof Navigatable) {
                return delegate;
            }
            if (delegate instanceof DatabaseSystem) {
                VirtualFile virtualFile = delegate instanceof SqlDataSource ? (VirtualFile)ContainerUtil.getFirstItem((List)((SqlDataSource)delegate).getFiles()) : DatabaseEditorHelper.findExistingConsoleVirtualFile((DatabaseSystem)delegate);
                if (virtualFile == null && DbImplUtil.canConnectTo(element)) {
                    return new NavigatableAdapter(){

                        public void navigate(boolean requestFocus) {
                            VirtualFile file = DatabaseEditorHelper.getConsoleVirtualFile((DatabaseSystem)delegate);
                            if (file == null) {
                                return;
                            }
                            new OpenFileDescriptor(project, file).navigate(requestFocus);
                        }
                    };
                }
                return virtualFile == null ? element : new OpenFileDescriptor(project, virtualFile);
            }
            if (delegate instanceof DasNamespace && element.getKind() == ObjectKind.SCHEMA) {
                if (DbImplUtil.canConnectTo(element)) {
                    final DatabaseSystem dataSourceInfo = (DatabaseSystem)ObjectUtils.assertNotNull((Object)element.getDataSource().getDelegate());
                    return new NavigatableAdapter(){

                        public void navigate(boolean requestFocus) {
                            DatabaseEditorHelper.openConsoleFile(project, dataSourceInfo, (DasNamespace)delegate, false);
                        }
                    };
                }
                return element;
            }
            return DbNodeDescriptor.getNavigatableImpl(project, element);
        }
        if (CommonDataKeys.PSI_ELEMENT.is(dataId)) {
            return element;
        }
        return null;
    }

    @NotNull
    public static Object getNavigatableImpl(Project project, DbElement element) {
        DatabaseFamilyId familyId;
        boolean isTrigger = element instanceof DbTrigger;
        DbElement parent = element.getDbParent();
        DbElement adjusted = element;
        if (parent instanceof DbTable) {
            if (!isTrigger) {
                adjusted = parent;
            }
        } else if (parent instanceof DbPackage && !(familyId = DbImplUtil.getDatabaseDialect(element).getFamilyId()).isSybase()) {
            DbElement body = (DbElement)parent.getDbChildren(DbElement.class, ObjectKind.BODY).first();
            adjusted = (DbElement)ObjectUtils.chooseNotNull((Object)body, (Object)parent);
        }
        DbElementNavigatable dbElementNavigatable = new DbElementNavigatable(adjusted, element);
        if (dbElementNavigatable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/DbNodeDescriptor", "getNavigatableImpl"));
        }
        return dbElementNavigatable;
    }

    public boolean expandOnDoubleClick() {
        return !(this.getElement() instanceof DbTable);
    }

    public boolean isValid() {
        return this.getElement().isValid();
    }

    public int getWeight() {
        DbElement element = this.getElement();
        if (element == null || !element.isValid()) {
            return super.getWeight();
        }
        return element.getWeight();
    }

    public String toString() {
        return super.toString();
    }

    @NotNull
    public Object[] getEqualityObjects() {
        Object[] objectArray = new Object[]{this.myElement};
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/DbNodeDescriptor", "getEqualityObjects"));
        }
        return objectArray;
    }

    public final boolean equals(Object o) {
        return ComparableObjectCheck.equals((ComparableObject)this, (Object)o);
    }

    public final int hashCode() {
        return ComparableObjectCheck.hashCode((ComparableObject)this, (int)super.hashCode());
    }

    @NotNull
    public static String arrowToColumns(@Nullable String tableName, @NotNull Collection<String> columnNames) {
        if (columnNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columnNames", "com/intellij/database/view/DbNodeDescriptor", "arrowToColumns"));
        }
        String string = StringUtil.isEmpty((String)tableName) ? "" : DbNodeDescriptor.arrow() + " " + tableName + " " + DbNodeDescriptor.multiRef(columnNames);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/DbNodeDescriptor", "arrowToColumns"));
        }
        return string;
    }

    @NotNull
    public static String arrowToColumns(@Nullable String tableName, @NotNull MultiRef<? extends DasTypedObject> columnsRef) {
        if (columnsRef == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columnsRef", "com/intellij/database/view/DbNodeDescriptor", "arrowToColumns"));
        }
        String string = StringUtil.isEmpty((String)tableName) ? "" : DbNodeDescriptor.arrow() + " " + tableName + " " + DbNodeDescriptor.multiRef(columnsRef);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/DbNodeDescriptor", "arrowToColumns"));
        }
        return string;
    }

    @NotNull
    public static String multiRef(@NotNull Collection<String> names) {
        if (names == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "names", "com/intellij/database/view/DbNodeDescriptor", "multiRef"));
        }
        String string = names.size() == 0 ? "" : "(" + StringUtil.join(names, (String)", ") + ")";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/DbNodeDescriptor", "multiRef"));
        }
        return string;
    }

    @NotNull
    public static String multiRef(@NotNull MultiRef<? extends DasTypedObject> ref) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/database/view/DbNodeDescriptor", "multiRef"));
        }
        String string = ref.size() == 0 ? "" : "(" + StringUtil.join((Iterable)JBIterable.from((Iterable)ref.names()).filter(n -> n != null), (String)", ") + ")";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/DbNodeDescriptor", "multiRef"));
        }
        return string;
    }

    @NotNull
    public static String arrow() {
        String string = ApplicationManager.getApplication().isUnitTestMode() ? "->" : UIUtil.rightArrow();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/DbNodeDescriptor", "arrow"));
        }
        return string;
    }

    public static class DbElementNavigatable
    extends NavigatableAdapter {
        private final DbElement myAdjusted;
        private final DbElement myElement;

        public DbElementNavigatable(DbElement adjusted, DbElement element) {
            this.myAdjusted = adjusted;
            this.myElement = element;
        }

        public DbElement getElement() {
            return this.myAdjusted;
        }

        public void navigate(boolean requestFocus) {
            VirtualFile virtualFile = DbImplUtil.findVirtualFile(this.myAdjusted);
            if (virtualFile != null && virtualFile.isValid()) {
                int offset;
                boolean isTrigger = this.myElement instanceof DbTrigger;
                boolean isTable = DatabaseEditorHelper.isTableDataAvailable(this.myAdjusted) || DatabaseEditorHelper.isDefinitionAvailable(this.myAdjusted);
                int n = offset = this.myAdjusted == this.myElement ? -1 : DatabaseOpenFileDescriptor.calcTargetOffset(this.myAdjusted.getProject(), virtualFile, (DasObject)this.myElement);
                if (isTable || isTrigger) {
                    new DatabaseOpenFileDescriptor(this.myAdjusted.getProject(), virtualFile, offset).navigate(requestFocus);
                    return;
                }
            }
            this.myAdjusted.navigate(requestFocus);
        }
    }
}

