/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.editors;

import com.google.common.collect.Iterables;
import com.intellij.database.editor.DatabaseColors;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasIndex;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DasTableKey;
import com.intellij.database.model.MultiRef;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.schemaEditor.model.DeColumn;
import com.intellij.database.schemaEditor.model.DeIndex;
import com.intellij.database.schemaEditor.model.DeObject;
import com.intellij.database.schemaEditor.model.DeTable;
import com.intellij.database.schemaEditor.model.DeTableKey;
import com.intellij.database.util.DasUtil;
import com.intellij.database.view.editors.DatabaseColumnEditor;
import com.intellij.database.view.editors.DatabaseEditorBaseEx;
import com.intellij.database.view.editors.DatabaseEditorCapabilities;
import com.intellij.database.view.editors.DatabaseEditorState;
import com.intellij.database.view.editors.DatabaseEditorUtil;
import com.intellij.database.view.editors.DatabaseTableColumnsEditor;
import com.intellij.database.view.models.ColumnEditorModel;
import com.intellij.database.view.models.EditorModelBase;
import com.intellij.database.view.models.IndexEditorModel;
import com.intellij.database.view.models.ObjectEditorModel;
import com.intellij.database.view.models.TableEditorModel;
import com.intellij.database.view.models.TableKeyEditorModel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.Collections;
import java.util.Iterator;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseTableColumnEditor
extends DatabaseEditorBaseEx
implements DatabaseEditorUtil.EmbeddableEditor {
    protected final DatabaseTableColumnsEditor myColumnsEditor;
    private final DatabaseColumnEditor myColumnEditor;
    private final TableEditorModel myTableModel;
    private final DatabaseEditorCapabilities.TableColumnEditorCaps myCaps;
    private final JCheckBox myUniqueCheckBox;
    private final JCheckBox myPrimaryKeyCheckBox;
    private TableKeyEditorModel myCachedPk;
    private IndexEditorModel myCachedUc;
    private Disposable myCachedUcListenerHolder;
    private Disposable myCachedPkListenerHolder;
    private final EditorModelBase.Listener myObjectListener;
    protected Iterable<Pair<String, TextAttributesKey>> myCachedText;

    public DatabaseTableColumnEditor(@NotNull DatabaseEditorState state, @NotNull TableEditorModel tableModel, @NotNull ColumnEditorModel columnModel, @NotNull DatabaseEditorCapabilities.TableColumnEditorCaps columnCaps, @NotNull DatabaseTableColumnsEditor columnsEditor) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/database/view/editors/DatabaseTableColumnEditor", "<init>"));
        }
        if (tableModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tableModel", "com/intellij/database/view/editors/DatabaseTableColumnEditor", "<init>"));
        }
        if (columnModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columnModel", "com/intellij/database/view/editors/DatabaseTableColumnEditor", "<init>"));
        }
        if (columnCaps == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columnCaps", "com/intellij/database/view/editors/DatabaseTableColumnEditor", "<init>"));
        }
        if (columnsEditor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columnsEditor", "com/intellij/database/view/editors/DatabaseTableColumnEditor", "<init>"));
        }
        super(state);
        this.myObjectListener = new EditorModelBase.Listener(){

            @Override
            public void changed() {
                DatabaseTableColumnEditor.this.fromModelToUi();
            }
        };
        this.myTableModel = tableModel;
        this.myCaps = columnCaps;
        this.myColumnsEditor = columnsEditor;
        this.myColumnEditor = this.createEditor(state, columnModel, columnCaps);
        Disposer.register((Disposable)this, (Disposable)this.myColumnEditor);
        this.myUniqueCheckBox = new JBCheckBox("Unique");
        this.myColumnEditor.addToBoxesPanel(this.myUniqueCheckBox);
        this.myPrimaryKeyCheckBox = new JBCheckBox("Primary key");
        this.myColumnEditor.addToBoxesPanel(this.myPrimaryKeyCheckBox);
        this.myUniqueCheckBox.setMnemonic(85);
        this.myPrimaryKeyCheckBox.setMnemonic(80);
        this.myUniqueCheckBox.setVisible(this.myCaps.getUnique().isSupported());
        this.myUniqueCheckBox.setEnabled(this.myCaps.getUnique().isAvailable());
        this.myPrimaryKeyCheckBox.setVisible(this.myCaps.getPrimaryKey().isSupported());
        this.myPrimaryKeyCheckBox.setEnabled(this.myCaps.getPrimaryKey().isAvailable());
        this.initSubscriptions();
        this.updateFromModel();
    }

    @NotNull
    protected DatabaseColumnEditor createEditor(@NotNull DatabaseEditorState state, @NotNull ColumnEditorModel columnModel, @NotNull DatabaseEditorCapabilities.TableColumnEditorCaps columnCaps) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/database/view/editors/DatabaseTableColumnEditor", "createEditor"));
        }
        if (columnModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columnModel", "com/intellij/database/view/editors/DatabaseTableColumnEditor", "createEditor"));
        }
        if (columnCaps == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columnCaps", "com/intellij/database/view/editors/DatabaseTableColumnEditor", "createEditor"));
        }
        DatabaseColumnEditor databaseColumnEditor = new DatabaseColumnEditor(state, columnModel, columnCaps);
        if (databaseColumnEditor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseTableColumnEditor", "createEditor"));
        }
        return databaseColumnEditor;
    }

    @NotNull
    public DatabaseEditorCapabilities.TableColumnEditorCaps getCaps() {
        DatabaseEditorCapabilities.TableColumnEditorCaps tableColumnEditorCaps = this.myCaps;
        if (tableColumnEditorCaps == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseTableColumnEditor", "getCaps"));
        }
        return tableColumnEditorCaps;
    }

    private void initSubscriptions() {
        this.myTableModel.addListener(this.myObjectListener, this);
        this.getColumnModel().addListener(this.myObjectListener, this);
        this.myUniqueCheckBox.addItemListener(e -> {
            if (!this.myUpdating) {
                this.updateUniqueConstraint(this.myUniqueCheckBox.isSelected());
            }
        });
        this.myPrimaryKeyCheckBox.addItemListener(e -> {
            if (!this.myUpdating) {
                this.updatePrimaryKey(this.myPrimaryKeyCheckBox.isSelected());
            }
        });
    }

    private void updatePrimaryKey(boolean selected) {
        DeTableKey key;
        DeTableKey constraint = this.getColumnPrimaryKey(this.getColumn());
        if (constraint != null == selected) {
            return;
        }
        if (constraint != null && (this.myCachedPk == null || this.myCachedPk.getObject() != constraint)) {
            this.subscribePrimaryKey(false);
            this.myCachedPk = this.myTableModel.modelsCache.get(constraint, TableKeyEditorModel.class);
        }
        if ((key = this.myTableModel.getPrimaryKey()) != null && key.columns.size() == 1) {
            this.myTableModel.removeTableKey(key);
        }
        if (!selected) {
            this.myTableModel.setPrimaryKey(null);
            this.subscribeUniqueConstraint(false);
        } else {
            if (this.myCachedPk == null) {
                this.myCachedPk = this.myTableModel.modelsCache.get(this.myTableModel.createTableKey(this.getColumn()), TableKeyEditorModel.class);
            }
            this.myTableModel.setPrimaryKey((DeTableKey)this.myCachedPk.getObject());
        }
        this.myTableModel.commit();
    }

    @NotNull
    public ColumnEditorModel getColumnModel() {
        ColumnEditorModel columnEditorModel = this.myColumnEditor.getColumnModel();
        if (columnEditorModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseTableColumnEditor", "getColumnModel"));
        }
        return columnEditorModel;
    }

    private void subscribePrimaryKey(boolean sub) {
        if (this.myCachedPkListenerHolder != null) {
            Disposer.dispose((Disposable)this.myCachedPkListenerHolder);
            this.myCachedPkListenerHolder = null;
        }
        if (sub) {
            this.myCachedPkListenerHolder = Disposer.newDisposable();
            Disposer.register((Disposable)this, (Disposable)this.myCachedPkListenerHolder);
            this.myCachedPk.addListener(this.myObjectListener, this.myCachedPkListenerHolder);
        }
    }

    private void subscribeUniqueConstraint(boolean sub) {
        if (this.myCachedUcListenerHolder != null) {
            Disposer.dispose((Disposable)this.myCachedUcListenerHolder);
            this.myCachedUcListenerHolder = null;
        }
        if (sub) {
            this.myCachedUcListenerHolder = Disposer.newDisposable();
            Disposer.register((Disposable)this, (Disposable)this.myCachedUcListenerHolder);
            this.myCachedUc.addListener(this.myObjectListener, this.myCachedUcListenerHolder);
        }
    }

    private void updateUniqueConstraint(boolean selected) {
        DeIndex index = this.getColumnIndex(this.getColumn(), false);
        if ((index != null && index.isUnique()) == selected) {
            return;
        }
        if (index != null && (this.myCachedUc == null || this.myCachedUc.getObject() != index)) {
            this.subscribeUniqueConstraint(false);
            this.myCachedUc = this.myTableModel.modelsCache.get(index, IndexEditorModel.class);
        }
        if (!selected) {
            this.myTableModel.removeIndex(index);
            this.subscribeUniqueConstraint(false);
        } else {
            if (this.myCachedUc == null) {
                this.myCachedUc = this.myTableModel.modelsCache.get(this.myTableModel.createIndex(new DeIndex.Item(this.getColumn(), DasIndex.Sorting.NONE)), IndexEditorModel.class);
            }
            this.myCachedUc.setUnique(true);
            this.myCachedUc.commit();
            this.subscribeUniqueConstraint(true);
            this.myTableModel.addIndex((DeIndex)this.myCachedUc.getObject());
        }
        this.myTableModel.commit();
    }

    @NotNull
    public DeColumn getColumn() {
        DeColumn deColumn = (DeColumn)this.getColumnModel().getObject();
        if (deColumn == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseTableColumnEditor", "getColumn"));
        }
        return deColumn;
    }

    @NotNull
    public DeTable getTable() {
        DeTable deTable = (DeTable)this.getTableModel().getObject();
        if (deTable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseTableColumnEditor", "getTable"));
        }
        return deTable;
    }

    @Override
    @NotNull
    public ObjectEditorModel<DeTable> getModel() {
        TableEditorModel tableEditorModel = this.getTableModel();
        if (tableEditorModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseTableColumnEditor", "getModel"));
        }
        return tableEditorModel;
    }

    @Override
    protected void updateFromModelImpl() {
        if (this.myCachedUc != null) {
            this.myCachedUc.commit();
        }
        if (this.myCachedPk != null) {
            this.myCachedPk.commit();
        }
        DatabaseTableColumnEditor.setValue(this.myUniqueCheckBox, this.getColumnIndex(this.getColumn(), true) != null);
        DatabaseTableColumnEditor.setValue(this.myPrimaryKeyCheckBox, this.getColumnPrimaryKey(this.getColumn()) != null);
    }

    public DatabaseColumnEditor getColumnEditor() {
        return this.myColumnEditor;
    }

    private DeIndex getColumnIndex(@NotNull DeColumn column, boolean unique) {
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/view/editors/DatabaseTableColumnEditor", "getColumnIndex"));
        }
        for (DeIndex o : this.myTableModel.getIndices()) {
            Iterator<DeColumn> it;
            if (unique && !o.unique || !(it = o.getColumns().iterator()).hasNext() || it.next() != column || it.hasNext()) continue;
            return o;
        }
        return null;
    }

    private DeTableKey getColumnPrimaryKey(@NotNull DeColumn column) {
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/view/editors/DatabaseTableColumnEditor", "getColumnPrimaryKey"));
        }
        DeTableKey pk = this.myTableModel.getPrimaryKey();
        return pk == null || !pk.columns.equals(Collections.singletonList(column)) ? null : pk;
    }

    @NotNull
    public TableEditorModel getTableModel() {
        TableEditorModel tableEditorModel = this.myTableModel;
        if (tableEditorModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseTableColumnEditor", "getTableModel"));
        }
        return tableEditorModel;
    }

    @Override
    @NotNull
    public JComponent getPreferredFocusedComponent() {
        JComponent jComponent = this.myColumnEditor.getPreferredFocusedComponent();
        if (jComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseTableColumnEditor", "getPreferredFocusedComponent"));
        }
        return jComponent;
    }

    @Override
    public boolean canDoAnything() {
        return this.myCaps.canDoAnything() && ((DeColumn)this.myColumnEditor.getColumnModel().getObject()).isEnabled();
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        JComponent jComponent = this.myColumnEditor.getComponent();
        if (jComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseTableColumnEditor", "getComponent"));
        }
        return jComponent;
    }

    @Override
    @NotNull
    public JComponent[] getFocusableComponents() {
        JComponent[] jComponentArray = (JComponent[])ArrayUtil.mergeArrays((Object[])this.myColumnEditor.getFocusableComponents(), (Object[])new JComponent[]{this.myUniqueCheckBox, this.myPrimaryKeyCheckBox});
        if (jComponentArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseTableColumnEditor", "getFocusableComponents"));
        }
        return jComponentArray;
    }

    @Override
    @NotNull
    public Iterable<Pair<String, TextAttributesKey>> getRowText() {
        Iterable<Pair<String, TextAttributesKey>> iterable;
        if (this.myColumnsEditor.getActiveEditor() != null && this.myCachedText != null) {
            iterable = this.myCachedText;
        } else {
            this.myCachedText = this.getColumnDefinition();
            iterable = this.myCachedText;
        }
        if (iterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseTableColumnEditor", "getRowText"));
        }
        return iterable;
    }

    void dropCache() {
        this.myCachedText = null;
    }

    @NotNull
    public Iterable<Pair<String, TextAttributesKey>> getColumnDefinition() {
        DatabaseEditorUtil.ColoredFragmentsBuilder res = new DatabaseEditorUtil.ColoredFragmentsBuilder();
        Iterable<Pair<String, TextAttributesKey>> name = this.getColumnName();
        DeColumn column = (DeColumn)this.getColumnModel().getObject();
        int length = this.myColumnsEditor.getMaxLength((Function<DatabaseTableColumnEditor, Iterable<Pair<String, TextAttributesKey>>>)((Function)DatabaseTableColumnEditor::getColumnName));
        int currentLength = DatabaseEditorUtil.computeLength(name);
        DatabaseEditorUtil.padText(res, length, currentLength);
        String type = column.dataType;
        DeTableKey key = column.table.keys.getPrimaryKey();
        String pk = key != null && ContainerUtil.find(key.getColumns(), (Object)column) != null ? " -- part of primary key" : "";
        String comment = column.comment != null ? " /*" + column.comment + "*/" : "";
        String defaultText = column.defaultValue != null ? " default " + column.defaultValue : "";
        String text = type + defaultText + pk + comment;
        Iterable iterable = Iterables.concat(name, res.append(text, column.isEnabled() ? null : DatabaseColors.STRUCTURE_HIDDEN_COLUMN).build());
        if (iterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseTableColumnEditor", "getColumnDefinition"));
        }
        return iterable;
    }

    @NotNull
    public Iterable<Pair<String, TextAttributesKey>> getColumnName() {
        JBIterable jBIterable = JBIterable.of((Object)Pair.create((Object)((DeColumn)this.getColumnModel().getObject()).name, null));
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseTableColumnEditor", "getColumnName"));
        }
        return jBIterable;
    }

    @Override
    public boolean isObjectValid() {
        return true;
    }

    @NotNull
    public JCheckBox getUniqueCheckBox() {
        JCheckBox jCheckBox = this.myUniqueCheckBox;
        if (jCheckBox == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseTableColumnEditor", "getUniqueCheckBox"));
        }
        return jCheckBox;
    }

    @NotNull
    public JCheckBox getPrimaryKeyCheckBox() {
        JCheckBox jCheckBox = this.myPrimaryKeyCheckBox;
        if (jCheckBox == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseTableColumnEditor", "getPrimaryKeyCheckBox"));
        }
        return jCheckBox;
    }

    @Override
    @Nullable
    public DeObject getKeyObject() {
        return this.getColumn();
    }

    @NotNull
    public static DatabaseEditorCapabilities.TableColumnEditorCaps getTableColumnCaps(@NotNull DatabaseEditorCapabilities.TableEditorCaps tableCaps, @Nullable DasTable table, @Nullable DasColumn column) {
        if (tableCaps == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tableCaps", "com/intellij/database/view/editors/DatabaseTableColumnEditor", "getTableColumnCaps"));
        }
        assert (table != null || column == null);
        DasTableKey pk = table == null ? null : DasUtil.getPrimaryKey((DasTable)table);
        boolean isPk = pk != null && column != null && pk.getColumnsRef().size() == 1 && DasUtil.containsName((String)column.getName(), (MultiRef)pk.getColumnsRef());
        boolean isUnique = false;
        if (column != null) {
            for (DasTableKey o : table.getDbChildren(DasTableKey.class, ObjectKind.KEY)) {
                if (o.getColumnsRef().size() != 1 || !DasUtil.containsName((String)column.getName(), (MultiRef)o.getColumnsRef())) continue;
                isUnique = true;
                break;
            }
        }
        DatabaseEditorCapabilities.TableColumnEditorCaps tableColumnEditorCaps = new DatabaseEditorCapabilities.TableColumnEditorCaps(tableCaps, tableCaps.getColumnCaps(column != null), pk != null, isPk, isUnique);
        if (tableColumnEditorCaps == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseTableColumnEditor", "getTableColumnCaps"));
        }
        return tableColumnEditorCaps;
    }
}

