/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.models;

import com.intellij.database.schemaEditor.model.DeIndex;
import com.intellij.database.view.models.EditorModelUtil;
import com.intellij.database.view.models.EditorModelsCache;
import com.intellij.database.view.models.TableChildEditorModel;
import com.intellij.openapi.util.Comparing;
import com.intellij.sql.util.NameTemplate;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class IndexEditorModel
extends TableChildEditorModel<DeIndex> {
    private final EditorModelUtil.GeneratedNameHelper myGenHelper;

    public IndexEditorModel(@NotNull DeIndex object, @NotNull EditorModelsCache models) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/view/models/IndexEditorModel", "<init>"));
        }
        if (models == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "models", "com/intellij/database/view/models/IndexEditorModel", "<init>"));
        }
        super(object, models);
        this.fix();
        this.myGenHelper = new EditorModelUtil.GeneratedNameHelper(object, (NameTemplate)new NameTemplate.IndexNameTemplate(models.settings));
        this.myGenHelper.updateGenerated();
    }

    private void fix() {
        List<DeIndex.Item> items = ((DeIndex)this.myObject).items;
        for (int i2 = 0; i2 < items.size(); ++i2) {
            DeIndex.Item item = items.get(i2);
            if (item.column != null) continue;
            items.set(i2, new DeIndex.Item(EditorModelUtil.stubbize(item.column, ((DeIndex)this.myObject).table, ((DeIndex)this.myObject).model), item.sorting));
        }
    }

    @NotNull
    public List<DeIndex.Item> getItems() {
        List<DeIndex.Item> list = Collections.unmodifiableList(((DeIndex)this.myObject).items);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/models/IndexEditorModel", "getItems"));
        }
        return list;
    }

    public void setItems(@NotNull List<DeIndex.Item> items) {
        if (items == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "items", "com/intellij/database/view/models/IndexEditorModel", "setItems"));
        }
        if (((DeIndex)this.myObject).items.equals(items)) {
            return;
        }
        ((DeIndex)this.myObject).items.clear();
        ((DeIndex)this.myObject).items.addAll(items);
        this.modify();
    }

    public boolean isUnique() {
        return ((DeIndex)this.myObject).unique;
    }

    public void setUnique(boolean unique) {
        if (Comparing.equal((Object)unique, (Object)((DeIndex)this.myObject).unique)) {
            return;
        }
        ((DeIndex)this.myObject).unique = unique;
        this.modify();
    }

    public int getItemsCount() {
        return ((DeIndex)this.myObject).items.size();
    }

    @Override
    public void commit() {
        if (this.myGenHelper.updateGenerated()) {
            this.modify();
        }
        super.commit();
    }
}

