/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.ui;

import com.intellij.CommonBundle;
import com.intellij.database.DatabaseFamilyId;
import com.intellij.database.DatabaseMessages;
import com.intellij.database.access.DatabaseCredentials;
import com.intellij.database.actions.AddDataSourceFromUrl;
import com.intellij.database.actions.DdlActions;
import com.intellij.database.console.JdbcEngine;
import com.intellij.database.dataSource.AbstractDataSourceConfigurable;
import com.intellij.database.dataSource.AbstractDatabaseConfigurable;
import com.intellij.database.dataSource.DataSourceConfigurable;
import com.intellij.database.dataSource.DataSourceTemplate;
import com.intellij.database.dataSource.DataSourceTemplateAdapter;
import com.intellij.database.dataSource.DatabaseArtifactManager;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.DatabaseDriverImpl;
import com.intellij.database.dataSource.DatabaseDriverManager;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.srcStorage.DbSrcStorage;
import com.intellij.database.dataSource.validation.DataSourceProblem;
import com.intellij.database.dataSource.validation.DataSourceProblemsCollector;
import com.intellij.database.dataSource.validation.DataSourceProblemsProvider;
import com.intellij.database.dataSource.validation.NamedProgressive;
import com.intellij.database.introspection.DBIntrospectionOptions;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbDataSourceImpl;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.psi.DbPsiFacadeImpl;
import com.intellij.database.psi.DbPsiManager;
import com.intellij.database.psi.DbPsiManagerSpi;
import com.intellij.database.psi.DefaultDbPsiManager;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.DbUIUtil;
import com.intellij.database.util.DbUtil;
import com.intellij.database.view.DatabaseView;
import com.intellij.database.view.ui.DataSourceErrorsConfigurable;
import com.intellij.database.view.ui.DataSourceSettings;
import com.intellij.database.view.ui.DataSourceSidePanel;
import com.intellij.database.view.ui.DatabaseConfigEditor;
import com.intellij.database.view.ui.DatabaseDriverConfigurable;
import com.intellij.database.view.ui.DsUiDefaults;
import com.intellij.database.view.ui.SidePanelItem;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeTooltipManager;
import com.intellij.ide.impl.DataManagerImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Progressive;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.SidePanelCountLabel;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.OnePixelDivider;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.AnActionButtonUpdater;
import com.intellij.ui.HintHint;
import com.intellij.ui.JBColor;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.navigation.BackAction;
import com.intellij.ui.navigation.ForwardAction;
import com.intellij.ui.navigation.History;
import com.intellij.ui.navigation.Place;
import com.intellij.ui.speedSearch.SpeedSearchUtil;
import com.intellij.util.Function;
import com.intellij.util.IconUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairConsumer;
import com.intellij.util.PlatformIcons;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.text.Matcher;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import gnu.trove.TIntArrayList;
import icons.DatabaseIcons;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DatabaseConfigEditorImpl
extends SettingsEditor<DataSourceSettings>
implements DatabaseConfigEditor,
Place.Navigator {
    private static final Logger LOG = Logger.getInstance(DatabaseConfigEditorImpl.class);
    private final DatabaseCredentials myDatabaseCredentials = DatabaseCredentials.newUIInstance();
    private final SimpleModificationTracker myModificationTracker = new SimpleModificationTracker();
    private final DataSourceSettings mySettings;
    private final JPanel myRootPanel;
    private final JPanel myRightPanel;
    private final Map<Object, SidePanelItem> mySidePanelItems = ContainerUtil.newIdentityHashMap();
    private final JPanel myInfoPanel;
    private SidePanelItem mySelectedItem;
    private DataSourceErrorsConfigurable myErrorsConfigurable;
    private ValidationComponent myValidationComponent;
    private ValidationComponent myErrorInfoComponent;
    private final DataSourceProblemsCollector<SidePanelItem> myErrorsCollector;
    private final List<Object> myRemovedObjects = ContainerUtil.newArrayList();
    private final UserDataHolderBase myUserDataHolder = new UserDataHolderBase();
    private boolean myFilling = false;
    private History myHistory = new History((Place.Navigator)this);
    private DataSourceSidePanel mySidePanel;
    private AddAction myAddAction;
    private final Function.Mono<DataSourceTemplate> ACTUALIZE_WRAPPER = new Function.Mono<DataSourceTemplate>(){

        public DataSourceTemplate fun(DataSourceTemplate template) {
            return new DataSourceTemplateAdapter(template){

                private DataSourceTemplate actual() {
                    if (this.myDelegate instanceof DatabaseDriver) {
                        return (DataSourceTemplate)DatabaseConfigEditorImpl.this.getTempTargetOrTarget((DatabaseDriver)this.myDelegate).get();
                    }
                    return this.myDelegate;
                }

                @NotNull
                public String getName() {
                    String string = this.actual().getName();
                    if (string == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/DatabaseConfigEditorImpl$8$1", "getName"));
                    }
                    return string;
                }

                @NotNull
                public String getFullName() {
                    String string = this.actual().getFullName();
                    if (string == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/DatabaseConfigEditorImpl$8$1", "getFullName"));
                    }
                    return string;
                }

                @NotNull
                public List<DataSourceTemplate> getSubConfigurations() {
                    List list = this.actual().getSubConfigurations();
                    if (list == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/DatabaseConfigEditorImpl$8$1", "getSubConfigurations"));
                    }
                    return list;
                }

                public Icon getIcon(@Iconable.IconFlags int flags) {
                    return this.actual().getIcon(flags);
                }
            };
        }
    };

    DatabaseConfigEditorImpl(DataSourceSettings settings) {
        int newDsAmount = settings.getNewDataSources().size();
        int newDrAmount = settings.getNewDrivers().size();
        if (newDsAmount > 10 || newDrAmount > 10) {
            LOG.info("Data Sources: " + newDsAmount + ", Drivers: " + newDrAmount);
        }
        this.mySettings = settings;
        this.myRootPanel = new MyRootPanel(new BorderLayout());
        this.myRightPanel = new NonOpaquePanel((LayoutManager)new BorderLayout(0, 5));
        this.myValidationComponent = new ValidationComponent(false);
        this.myErrorInfoComponent = new ValidationComponent(true);
        this.myInfoPanel = new JPanel(new BorderLayout());
        this.myInfoPanel.add((Component)this.myErrorInfoComponent, "North");
        this.myInfoPanel.add((Component)this.myValidationComponent, "South");
        this.myErrorsConfigurable = new DataSourceErrorsConfigurable(this, () -> {
            Place place = this.getPlace(this.myErrorsConfigurable);
            this.mySidePanel.getList().invalidate();
            this.mySidePanel.getList().repaint();
            this.mySidePanel.setMinimumWidth(this.mySidePanel.getItemWidth(place));
        });
        this.myErrorsCollector = new DataSourceProblemsCollector(this.myErrorsConfigurable);
        OnePixelSplitter mySplitter = new OnePixelSplitter(false, 0.3f);
        mySplitter.setFirstComponent(this.createLeftPanel());
        mySplitter.setSecondComponent((JComponent)this.myRightPanel);
        this.myRootPanel.add((Component)mySplitter, "Center");
        Dimension d = this.myRootPanel.getPreferredSize();
        d.width = Math.max(d.width, 800);
        d.height = Math.max(d.height, 600);
        this.myRootPanel.setPreferredSize(d);
        this.setSelectedEditor(null);
        this.resetTreeModel(settings);
        DatabaseArtifactManager.getInstance().checkForUpdates();
        DatabaseArtifactManager.getInstance().addListener((artifactName, artifactVersion) -> ContainerUtil.process(this.mySidePanelItems.values(), (Processor)new SidePanelItem.ItemsVisitor(){

            @Override
            boolean visit(SidePanelItem.DriverItem driverItem) {
                DatabaseDriver.ArtifactRef artifact;
                DatabaseDriverConfigurable configurable = (DatabaseDriverConfigurable)((Object)driverItem.getConfigurable());
                DatabaseDriverImpl driver = configurable == null ? null : configurable.getTempDriver();
                DatabaseDriver.ArtifactRef artifactRef = artifact = driver == null ? null : driver.getArtifact();
                if (artifact != null && (artifactName == null || Comparing.equal((String)artifact.getName(), (String)artifactName) && Comparing.equal((String)artifact.getVersion(), (String)artifactVersion))) {
                    configurable.resetFromTemp();
                    DatabaseConfigEditorImpl.this.updateDriverDependants(driver);
                    driverItem.resetModifiedCache();
                }
                return true;
            }
        }), (Disposable)this);
        this.addSettingsEditorListener(e -> {
            this.stateChangedAsyncInner();
            this.updateSidePanelImpl();
        });
    }

    void updateDriverDependants(DatabaseDriver driver) {
        final DatabaseDriver actualDriver = (DatabaseDriver)this.getTempTargetOrTarget(driver).get();
        ContainerUtil.process(this.mySidePanelItems.values(), (Processor)new SidePanelItem.ItemsVisitor(){

            @Override
            boolean visit(SidePanelItem.DataSourceItem dataSourceItem) {
                DatabaseDriver dataSourceDriver;
                LocalDataSource dataSource = dataSourceItem.extractActualLocalDataSource();
                DatabaseDriver databaseDriver = dataSourceDriver = dataSource == null ? null : dataSource.getDatabaseDriver();
                if (dataSourceDriver != null && actualDriver == DatabaseConfigEditorImpl.this.getTempTargetOrTarget(dataSourceDriver).get()) {
                    AbstractDataSourceConfigurable configurable = (AbstractDataSourceConfigurable)((Object)dataSourceItem.getConfigurable());
                    if (configurable != null) {
                        configurable.onUserActivity();
                    } else {
                        DatabaseConfigEditorImpl.createEditorIfNeeded(dataSourceItem);
                    }
                    DatabaseConfigEditorImpl.this.myErrorsCollector.update(dataSourceItem);
                }
                return true;
            }
        });
    }

    private void updateSidePanelImpl() {
        final SidePanelItem item = this.mySelectedItem;
        if (item == null) {
            return;
        }
        this.myErrorsCollector.update(item);
        this.updateValidationProblem(this.mySelectedItem);
        this.mySidePanel.getList().invalidate();
        this.mySidePanel.getList().repaint();
        if (item.getObject() instanceof DatabaseDriver) {
            ContainerUtil.process(this.mySidePanelItems.values(), (Processor)new SidePanelItem.ItemsVisitor(){

                @Override
                boolean visit(SidePanelItem.DataSourceItem dsItem) {
                    LocalDataSource source = dsItem.extractActualLocalDataSource();
                    if (source == null || source.getDatabaseDriver() != item.getObject()) {
                        return true;
                    }
                    DataSourceConfigurable conf = (DataSourceConfigurable)((Object)ObjectUtils.tryCast((Object)DatabaseConfigEditorImpl.createEditorIfNeeded(dsItem), DataSourceConfigurable.class));
                    if (conf != null) {
                        conf.actualizeDriver();
                    }
                    return true;
                }
            });
        }
    }

    private void stateChangedAsyncInner() {
        DatabaseDriverConfigurable driverConfigurable;
        AbstractDataSourceConfigurable dsConfigurable;
        if (this.myFilling) {
            return;
        }
        this.clearModifiedCache();
        AbstractDataSourceConfigurable abstractDataSourceConfigurable = dsConfigurable = this.mySelectedItem == null ? null : (AbstractDataSourceConfigurable)((Object)ObjectUtils.tryCast(this.mySelectedItem.getConfigurable(), AbstractDataSourceConfigurable.class));
        if (dsConfigurable != null) {
            dsConfigurable.onUserActivity();
        }
        DatabaseDriverConfigurable databaseDriverConfigurable = driverConfigurable = this.mySelectedItem == null ? null : (DatabaseDriverConfigurable)((Object)ObjectUtils.tryCast(this.mySelectedItem.getConfigurable(), DatabaseDriverConfigurable.class));
        if (driverConfigurable != null) {
            this.updateDriverDependants(driverConfigurable.getTempDriver());
        }
    }

    @Nullable
    private Place getPlace(@Nullable Object object) {
        SidePanelItem item = this.mySidePanelItems.get(object);
        return item == null ? null : item.getPlace();
    }

    @Nullable
    private SidePanelItem getItem(@Nullable Place place) {
        SidePanelItem item = SidePanelItem.getItem(place);
        if (item != null) {
            item = this.mySidePanelItems.get(item.getObject());
        }
        return item;
    }

    public void clearModifiedCache() {
        this.myModificationTracker.incModificationCount();
        for (SidePanelItem item : this.mySidePanelItems.values()) {
            item.resetModifiedCache();
        }
    }

    private void removeSidePanelItem(@NotNull SidePanelItem item) {
        if (item == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/intellij/database/view/ui/DatabaseConfigEditorImpl", "removeSidePanelItem"));
        }
        SidePanelItem old = this.mySidePanelItems.remove(item.getObject());
        item.removeConfigurable();
        this.myErrorsCollector.remove(item);
        assert (old == item);
    }

    @Nullable
    public <T> T getUserData(@NotNull Key<T> key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/database/view/ui/DatabaseConfigEditorImpl", "getUserData"));
        }
        return (T)this.myUserDataHolder.getUserData(key);
    }

    public <T> void putUserData(@NotNull Key<T> key, @Nullable T value) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/database/view/ui/DatabaseConfigEditorImpl", "putUserData"));
        }
        this.myUserDataHolder.putUserData(key, value);
    }

    public void setHistory(History history) {
        this.myHistory = history;
    }

    public ActionCallback navigateTo(@Nullable Place place, boolean requestFocus) {
        SidePanelItem item = this.getItem(place);
        if (item != this.mySelectedItem) {
            this.setSelectedEditor(item);
            if (this.mySelectedItem != null) {
                this.myHistory.pushQueryPlace();
                if (requestFocus) {
                    UIUtil.requestFocus((JComponent)((JComponent)ObjectUtils.assertNotNull((Object)this.mySelectedItem.getComponent())));
                }
            }
            this.mySidePanel.select(place);
            this.updateSidePanelImpl();
        }
        return ActionCallback.DONE;
    }

    public void queryPlace(@NotNull Place place) {
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/database/view/ui/DatabaseConfigEditorImpl", "queryPlace"));
        }
        SidePanelItem.setItem(place, this.mySelectedItem);
    }

    public JComponent getPreferredFocusedComponent() {
        return this.mySidePanel.getList();
    }

    protected void disposeEditor() {
        super.disposeEditor();
        for (SidePanelItem item : ContainerUtil.newArrayList(this.mySidePanelItems.values())) {
            this.removeSidePanelItem(item);
        }
        this.myErrorsConfigurable.disposeUIResources();
        for (DbDataSource o : ContainerUtil.newArrayList(this.mySettings.getNewDataSources())) {
            if (o.isValid()) continue;
            this.mySettings.removeNewDataSource(o);
        }
        this.mySettings.getPsiFacade().clearCaches(null);
    }

    public String getHelpTopic() {
        Object configurable = this.mySelectedItem == null ? null : this.mySelectedItem.getConfigurable();
        return configurable == null ? null : configurable.getHelpTopic();
    }

    public boolean isAnyEditorModified() {
        if (!this.myRemovedObjects.isEmpty()) {
            return true;
        }
        for (SidePanelItem item : this.mySidePanelItems.values()) {
            if (!this.isObjectModified(item)) continue;
            return true;
        }
        return false;
    }

    protected void resetEditorFrom(@NotNull DataSourceSettings settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/database/view/ui/DatabaseConfigEditorImpl", "resetEditorFrom"));
        }
        this.resetTreeModel(settings);
        for (SidePanelItem item : this.mySidePanelItems.values()) {
            if (!item.isModified()) continue;
            ((Configurable)ObjectUtils.assertNotNull(item.getConfigurable())).reset();
        }
        this.clearModifiedCache();
    }

    protected void applyEditorTo(@NotNull DataSourceSettings settings) throws ConfigurationException {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/database/view/ui/DatabaseConfigEditorImpl", "applyEditorTo"));
        }
        for (SidePanelItem item : ContainerUtil.newArrayList(this.mySidePanelItems.values())) {
            boolean created = this.isObjectCreated(item);
            if (!item.isModified() && !created) continue;
            item.apply();
            if (!created) continue;
            this.ensureNewObjectDropped(item.getObject());
        }
        DdlActions.closeAllFilesBeforeDataSourceRemoval(this.mySettings.getProject(), (Set)JBIterable.from(this.myRemovedObjects).filter(DbDataSourceImpl.class).addAllTo((Collection)ContainerUtil.newLinkedHashSet()));
        Iterator<Object> it = this.myRemovedObjects.iterator();
        while (it.hasNext()) {
            this.removeObject(it.next());
            it.remove();
        }
        this.clearModifiedCache();
        Set selection = this.getSelectedItems().toSet();
        this.refillSidePanel(this.mySettings);
        this.restoreSelection(selection);
    }

    private void resetTreeModel(DataSourceSettings settings) {
        this.refillSidePanel(settings);
        this.navigateTo(this.mySettings.getCurrentDataSource());
    }

    @NotNull
    protected JComponent createEditor() {
        JPanel jPanel = this.myRootPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/DatabaseConfigEditorImpl", "createEditor"));
        }
        return jPanel;
    }

    private <I extends SidePanelItem> I createItem(@NotNull I item) {
        if (item == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/intellij/database/view/ui/DatabaseConfigEditorImpl", "createItem"));
        }
        this.mySidePanelItems.put(item.getObject(), item);
        this.ensureErrorProviderExistence(item);
        return item;
    }

    private SidePanelItem.DataSourceItem createItem(@NotNull DbDataSource obj) {
        if (obj == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "obj", "com/intellij/database/view/ui/DatabaseConfigEditorImpl", "createItem"));
        }
        SidePanelItem.DataSourceItem item = (SidePanelItem.DataSourceItem)this.mySidePanelItems.get(obj);
        if (item == null) {
            item = new SidePanelItem.DataSourceItem(this, obj);
        }
        return this.createItem(item);
    }

    private SidePanelItem.DriverItem createItem(@NotNull DatabaseDriver obj) {
        if (obj == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "obj", "com/intellij/database/view/ui/DatabaseConfigEditorImpl", "createItem"));
        }
        SidePanelItem.DriverItem item = (SidePanelItem.DriverItem)this.mySidePanelItems.get(obj);
        if (item == null) {
            item = new SidePanelItem.DriverItem(this, obj);
        }
        return this.createItem(item);
    }

    private SidePanelItem.ErrorsItem createItem(@NotNull DataSourceErrorsConfigurable obj) {
        if (obj == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "obj", "com/intellij/database/view/ui/DatabaseConfigEditorImpl", "createItem"));
        }
        SidePanelItem.ErrorsItem item = (SidePanelItem.ErrorsItem)this.mySidePanelItems.get(obj);
        if (item == null) {
            item = new SidePanelItem.ErrorsItem(this, obj);
        }
        return this.createItem(item);
    }

    private SidePanelItem addToSidePanel(@NotNull SidePanelItem item) {
        if (item == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/intellij/database/view/ui/DatabaseConfigEditorImpl", "addToSidePanel"));
        }
        Place place = item.createPlace();
        this.mySidePanel.addPlace(place);
        return item;
    }

    private void ensureErrorProviderExistence(@NotNull SidePanelItem item) {
        if (item == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/intellij/database/view/ui/DatabaseConfigEditorImpl", "ensureErrorProviderExistence"));
        }
        DataSourceProblemsProvider provider = (DataSourceProblemsProvider)ObjectUtils.tryCast((Object)item, DataSourceProblemsProvider.class);
        if (provider == null || this.myErrorsCollector.contains(item)) {
            return;
        }
        this.myErrorsCollector.add(item, provider);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refillSidePanel(@NotNull DataSourceSettings settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/database/view/ui/DatabaseConfigEditorImpl", "refillSidePanel"));
        }
        this.myFilling = true;
        try {
            this.mySidePanel.getList().getSelectionModel().setValueIsAdjusting(true);
            this.mySidePanel.clear();
            ArrayList localDataSources = ContainerUtil.newArrayList();
            ArrayList globalDataSources = ContainerUtil.newArrayList();
            ArrayList importedDataSources = ContainerUtil.newArrayList();
            for (DbDataSource element : this.getAllDataSources()) {
                SidePanelItem.DataSourceItem item = this.createItem(element);
                if (item.isImported()) {
                    importedDataSources.add(item);
                    continue;
                }
                if (item.isGlobal()) {
                    globalDataSources.add(item);
                    continue;
                }
                localDataSources.add(item);
            }
            Comparator dataSourceElementComparator = (o1, o2) -> StringUtil.naturalCompare((String)o1.getName(), (String)o2.getName());
            Collections.sort(importedDataSources, dataSourceElementComparator);
            Collections.sort(localDataSources, dataSourceElementComparator);
            Collections.sort(globalDataSources, dataSourceElementComparator);
            HashSet addedItems = ContainerUtil.newHashSet();
            this.mySidePanel.addSeparator("Project Data Sources");
            for (Object ds : localDataSources) {
                addedItems.add(this.addToSidePanel((SidePanelItem)ds));
            }
            this.mySidePanel.addSeparator("Global Data Sources");
            for (Object ds : globalDataSources) {
                addedItems.add(this.addToSidePanel((SidePanelItem)ds));
            }
            this.mySidePanel.addSeparator("Imported Data Sources");
            for (Object ds : importedDataSources) {
                addedItems.add(this.addToSidePanel((SidePanelItem)ds));
            }
            this.mySidePanel.addSeparator("--");
            this.mySidePanel.addSeparator("Drivers");
            HashSet newDrivers = ContainerUtil.newHashSet(this.mySettings.getNewDrivers());
            for (DatabaseDriver driver : this.getAllDrivers(settings)) {
                SidePanelItem item = this.createItem(driver);
                if (newDrivers.contains(driver)) {
                    DatabaseConfigEditorImpl.createEditorIfNeeded(item);
                }
                addedItems.add(this.addToSidePanel(item));
            }
            this.mySidePanel.addSeparator("---");
            SidePanelItem.ErrorsItem errorsItem = this.createItem(this.myErrorsConfigurable);
            addedItems.add(this.addToSidePanel(errorsItem));
            for (SidePanelItem item : ContainerUtil.newArrayList(this.mySidePanelItems.values())) {
                if (addedItems.contains(item)) continue;
                this.removeSidePanelItem(item);
            }
            this.mySidePanel.setMinimumWidth(this.mySidePanel.getItemWidth(this.getPlace(this.myErrorsConfigurable)));
        }
        finally {
            this.myFilling = false;
            this.mySidePanel.getList().getSelectionModel().setValueIsAdjusting(false);
        }
    }

    public int getDataSourceGroup(@Nullable Object object) {
        switch (Kind.kindOf(object)) {
            case DATABASE: {
                return 2;
            }
            case DRIVER: {
                return 1;
            }
        }
        return 0;
    }

    @NotNull
    private JComponent createToolbarComponent(AnAction ... actions) {
        if (actions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actions", "com/intellij/database/view/ui/DatabaseConfigEditorImpl", "createToolbarComponent"));
        }
        DefaultActionGroup toolbarGroup = new DefaultActionGroup();
        toolbarGroup.addAll(actions);
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("ProjectViewToolbar", (ActionGroup)toolbarGroup, true);
        toolbar.setReservePlaceAutoPopupIcon(false);
        toolbar.setTargetComponent((JComponent)this.myRootPanel);
        JComponent component = toolbar.getComponent();
        component.setBackground(UIUtil.SIDE_PANEL_BACKGROUND);
        JComponent jComponent = component;
        if (jComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/DatabaseConfigEditorImpl", "createToolbarComponent"));
        }
        return jComponent;
    }

    private JComponent createLeftPanel() {
        this.mySidePanel = new DataSourceSidePanel(new MyComponentConfigurator(), (Function<Place, String>)((Function)place -> {
            SidePanelItem item = SidePanelItem.getItem(place);
            return item == null ? null : item.getName();
        }));
        this.mySidePanel.getList().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                Object o = ((JList)e.getSource()).getSelectedValue();
                DatabaseConfigEditorImpl.this.navigateTo(SidePanelItem.getObject(SidePanelItem.getItem((Place)ObjectUtils.tryCast(o, Place.class))));
            }
        });
        ActionManager actionManager = ActionManager.getInstance();
        JList target = this.mySidePanel.getList();
        this.myAddAction = new AddAction();
        this.myAddAction.registerCustomShortcutSet(CommonShortcuts.getNewForDialogs(), target);
        RemoveAction removeAction = new RemoveAction();
        removeAction.registerCustomShortcutSet(CommonShortcuts.getDelete(), target);
        CopyAction copyAction = new CopyAction();
        copyAction.registerCustomShortcutSet(CommonShortcuts.getDuplicate(), target);
        GoToDriverAction editDefaultsAction = new GoToDriverAction();
        editDefaultsAction.registerCustomShortcutSet(actionManager.getAction("GotoDeclaration").getShortcutSet(), target);
        ForwardAction forwardAction = new ForwardAction((JComponent)this.myRootPanel);
        BackAction backAction = new BackAction((JComponent)this.myRootPanel);
        ShowUsagesAction showUsagesAction = new ShowUsagesAction();
        ResetToPredefinedAction resetToPredefAction = new ResetToPredefinedAction();
        DataSourceScopeAction scopeAction = new DataSourceScopeAction();
        showUsagesAction.registerCustomShortcutSet(actionManager.getAction("FindUsages").getShortcutSet(), target);
        ResetAction revertAction = new ResetAction();
        revertAction.registerCustomShortcutSet(actionManager.getAction("ChangesView.Revert").getShortcutSet(), target);
        SourceLoadingAction sourceLoading = new SourceLoadingAction();
        JPanel toolbarsPanel = new JPanel(new BorderLayout());
        toolbarsPanel.add((Component)this.createToolbarComponent(new AnAction[]{this.myAddAction, removeAction, copyAction, editDefaultsAction, scopeAction}), "Center");
        toolbarsPanel.add((Component)this.createToolbarComponent(new AnAction[]{backAction, forwardAction}), "East");
        JPanel result = new JPanel(new BorderLayout());
        result.add((Component)toolbarsPanel, "North");
        result.add((Component)this.mySidePanel.getComponent(), "Center");
        DefaultActionGroup group2 = new DefaultActionGroup();
        group2.add((AnAction)this.myAddAction);
        group2.add((AnAction)removeAction);
        group2.add((AnAction)copyAction);
        group2.add((AnAction)scopeAction);
        group2.addSeparator();
        group2.add((AnAction)editDefaultsAction);
        group2.add((AnAction)new ChooseDriverGroup());
        group2.add((AnAction)showUsagesAction);
        group2.addSeparator();
        group2.add((AnAction)revertAction);
        group2.add((AnAction)resetToPredefAction);
        group2.add((AnAction)sourceLoading);
        PopupHandler.installPopupHandler((JComponent)target, (ActionGroup)group2, (String)"unknown", (ActionManager)actionManager);
        return result;
    }

    private void showUsagesPopup(final @Nullable SidePanelItem.DriverItem item) {
        JBPopupFactory popupFactory = JBPopupFactory.getInstance();
        final ArrayList actions = new ArrayList();
        if (item != null) {
            ContainerUtil.process(this.mySidePanelItems.values(), (Processor)new SidePanelItem.ItemsVisitor(){

                @Override
                boolean visit(final SidePanelItem.DataSourceItem dataSourceItem) {
                    DatabaseDriver driver;
                    LocalDataSource dataSource = dataSourceItem.extractActualLocalDataSource();
                    DatabaseDriver databaseDriver = driver = dataSource == null ? null : dataSource.getDatabaseDriver();
                    if (driver == null) {
                        return true;
                    }
                    if (driver == item.getObject() || driver == DatabaseConfigEditorImpl.this.getTempTargetOrTarget(item.getObject()).get()) {
                        actions.add(new DumbAwareAction(dataSourceItem.getName(), null, ((DbDataSource)dataSourceItem.getObject()).getIcon()){

                            public void actionPerformed(AnActionEvent e) {
                                DatabaseConfigEditorImpl.this.navigateTo(dataSourceItem.getObject());
                            }
                        });
                    }
                    return true;
                }
            });
        }
        if (actions.isEmpty()) {
            Messages.showInfoMessage((Component)this.mySidePanel.getComponent(), (String)"No usages found", (String)"Driver Usages");
        } else {
            int selectedRow = this.mySidePanel.getList().getSelectedIndex();
            Rectangle rowBounds = this.mySidePanel.getList().getCellBounds(selectedRow, selectedRow);
            Point location = rowBounds.getLocation();
            location.x += rowBounds.width;
            ListPopup popup = popupFactory.createActionGroupPopup("Used By", (ActionGroup)new DefaultActionGroup(actions), (DataContext)new DataManagerImpl.MyDataContext((Component)this.mySidePanel.getList()), null, true);
            popup.show(new RelativePoint((Component)this.mySidePanel.getList(), location));
        }
    }

    @Nullable
    public String getObjectName(@Nullable Object object) {
        SidePanelItem item = this.mySidePanelItems.get(object);
        return item == null ? null : item.getName();
    }

    private boolean isObjectCreated(@Nullable SidePanelItem item) {
        if (item == null) {
            return false;
        }
        final Ref result = Ref.create((Object)false);
        item.accept(new SidePanelItem.ItemsVisitor(){

            @Override
            boolean visit(SidePanelItem.DataSourceItem dataSourceItem) {
                result.set((Object)DatabaseConfigEditorImpl.this.mySettings.getNewDataSources().contains(dataSourceItem.getObject()));
                return true;
            }

            @Override
            boolean visit(SidePanelItem.DriverItem driverItem) {
                result.set((Object)DatabaseConfigEditorImpl.this.mySettings.getNewDrivers().contains(driverItem.getObject()));
                return true;
            }
        });
        return (Boolean)result.get();
    }

    private boolean isObjectModified(@Nullable SidePanelItem item) {
        return this.isObjectCreated(item) || item != null && item.isModified();
    }

    private static Configurable createEditorIfNeeded(@Nullable SidePanelItem item) {
        if (item != null && item.getConfigurable() == null) {
            item.createConfigurable();
        }
        return item == null ? null : (Configurable)item.getConfigurable();
    }

    private void setSelectedEditor(@Nullable SidePanelItem item) {
        if (item == this.mySelectedItem && this.myRightPanel.getComponentCount() != 0) {
            return;
        }
        this.myRightPanel.removeAll();
        this.mySelectedItem = item;
        DatabaseConfigEditorImpl.createEditorIfNeeded(item);
        if (item != null && item.getConfigurable() != null) {
            if (item.getConfigurable() instanceof AbstractDataSourceConfigurable) {
                ((AbstractDataSourceConfigurable)((Object)item.getConfigurable())).beforeShowNotify();
            }
            this.myRightPanel.add((Component)ObjectUtils.assertNotNull((Object)item.getComponent()), "Center");
            this.myRightPanel.add((Component)this.myInfoPanel, "South");
        } else {
            JPanel panel = new JPanel(new FlowLayout(0, 0, 0));
            panel.setBorder((Border)JBUI.Borders.empty((int)10, (int)10));
            panel.add(new JLabel("Press the"));
            ActionButton addIcon = new ActionButton((AnAction)this.myAddAction, this.myAddAction.getTemplatePresentation(), "MainToolbar", ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE);
            addIcon.setBorder((Border)JBUI.Borders.empty((int)0, (int)4));
            panel.add((Component)addIcon);
            panel.add(new JLabel("button to create a new data source"));
            JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)panel, (boolean)true);
            this.myRightPanel.add((Component)scrollPane, "Center");
        }
        UIUtil.setupEnclosingDialogBounds((JComponent)this.myRootPanel);
    }

    @Override
    public boolean isObjectNameUnique(@Nullable Object source, String name) {
        Kind kind = Kind.kindOf(source);
        if (kind == Kind.OTHER) {
            return true;
        }
        for (SidePanelItem item : this.mySidePanelItems.values()) {
            Object o = item.getObject();
            if (Kind.kindOf(o) != kind || o == source || o instanceof DbElement && ((DbElement)o).getDelegate() == source || !Comparing.equal((String)item.getName(), (String)name)) continue;
            return false;
        }
        return true;
    }

    @Override
    public String generateObjectName(final @Nullable Object source, String baseName) {
        final HashSet existingNames = ContainerUtil.newHashSet();
        ContainerUtil.process(this.mySidePanelItems.values(), (Processor)new SidePanelItem.ItemsVisitor(){

            @Override
            boolean visit(SidePanelItem.DataSourceItem dataSourceItem) {
                if (((DbDataSource)dataSourceItem.getObject()).getDelegate() != source) {
                    existingNames.add(dataSourceItem.getName());
                }
                return true;
            }
        });
        return DbUtil.createNewDataSourceName((String)baseName, (Set)existingNames);
    }

    private void createDataSource(@NotNull DbPsiManager manager, @NotNull DataSourceTemplate type, @Nullable DatabaseSystem copyFrom, @Nullable String url) {
        LocalDataSource dataSource;
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/database/view/ui/DatabaseConfigEditorImpl", "createDataSource"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/database/view/ui/DatabaseConfigEditorImpl", "createDataSource"));
        }
        DatabaseSystem dataSourceInfo = type.createDataSource(this.mySettings.getProject(), copyFrom, copyFrom == null ? null : this.generateObjectName(null, copyFrom.getName()));
        if (url != null && (dataSource = (LocalDataSource)((Object)ObjectUtils.tryCast((Object)dataSourceInfo, LocalDataSource.class))) != null) {
            dataSource.setUrlSmart(url);
        }
        DbDataSource dataSourceElement = ((DbPsiFacadeImpl)this.mySettings.getPsiFacade()).createDataSourceWrapperElement(dataSourceInfo, (DbPsiManagerSpi)manager);
        this.mySettings.addNewDataSource(dataSourceElement);
        this.putUserData(SELECTED_TAB_KEY, null);
        DatabaseConfigEditorImpl.createEditorIfNeeded(this.createItem(dataSourceElement));
        this.refillSidePanel(this.mySettings);
        this.navigateTo(dataSourceElement);
    }

    private DatabaseDriver createDatabaseDriver() {
        return DatabaseDriverManager.createDefaultDatabaseDriver(this.getAllDrivers(this.mySettings));
    }

    private void addNewDriverAndNavigate(@NotNull DatabaseDriver newDriver) {
        if (newDriver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newDriver", "com/intellij/database/view/ui/DatabaseConfigEditorImpl", "addNewDriverAndNavigate"));
        }
        this.mySettings.addNewDriver(newDriver);
        this.refillSidePanel(this.mySettings);
        this.navigateTo(newDriver);
    }

    private void removeObject(Object object) {
        block2: {
            block3: {
                if (!(object instanceof DbDataSource)) break block3;
                DbDataSource element = (DbDataSource)object;
                for (DbDataSource dbDataSource : this.mySettings.getPsiFacade().getDataSources()) {
                    if (dbDataSource.getDelegate() != element.getDelegate()) continue;
                    element.getDbManager().removeDataSource(element);
                    break block2;
                }
                break block2;
            }
            if (!(object instanceof DatabaseDriver)) break block2;
            DatabaseDriver driver = (DatabaseDriver)object;
            for (DatabaseDriver databaseDriver : DatabaseDriverManager.getInstance().getDrivers()) {
                if (databaseDriver != driver) continue;
                DatabaseDriverManager.getInstance().removeDriver(driver);
                break;
            }
        }
    }

    @NotNull
    private JBIterable<SidePanelItem> getSelectedItems() {
        Object[] values = this.mySidePanel.getList().getSelectedValues();
        if (values == null) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/DatabaseConfigEditorImpl", "getSelectedItems"));
            }
            return jBIterable;
        }
        JBIterable jBIterable = JBIterable.of((Object[])values).transform(o -> {
            Place place = (Place)ObjectUtils.tryCast((Object)o, Place.class);
            return SidePanelItem.getItem(place);
        }).filter(Condition.NOT_NULL);
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/DatabaseConfigEditorImpl", "getSelectedItems"));
        }
        return jBIterable;
    }

    @NotNull
    private JBIterable<SidePanelItem.DataSourceItem> getSelectedDataSources() {
        JBIterable jBIterable = this.getSelectedItems().filter(SidePanelItem.DataSourceItem.class);
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/DatabaseConfigEditorImpl", "getSelectedDataSources"));
        }
        return jBIterable;
    }

    @NotNull
    private JBIterable<SidePanelItem.DataSourceItem> getSelectedLocalDataSources() {
        JBIterable jBIterable = this.getSelectedDataSources().filter(item -> item.extractActualLocalDataSource() != null);
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/DatabaseConfigEditorImpl", "getSelectedLocalDataSources"));
        }
        return jBIterable;
    }

    @NotNull
    private JBIterable<SidePanelItem.DriverItem> getSelectedDrivers() {
        JBIterable jBIterable = this.getSelectedItems().filter(SidePanelItem.DriverItem.class);
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/DatabaseConfigEditorImpl", "getSelectedDrivers"));
        }
        return jBIterable;
    }

    void restoreSelection(@NotNull Set<SidePanelItem> sel) {
        if (sel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sel", "com/intellij/database/view/ui/DatabaseConfigEditorImpl", "restoreSelection"));
        }
        TIntArrayList newSelection = new TIntArrayList(sel.size());
        int count = this.mySidePanel.getList().getModel().getSize();
        for (int i2 = 0; i2 < count; ++i2) {
            SidePanelItem item = this.getItem((Place)ObjectUtils.tryCast(this.mySidePanel.getList().getModel().getElementAt(i2), Place.class));
            if (!sel.contains(item)) continue;
            newSelection.add(i2);
        }
        this.mySidePanel.getList().setSelectedIndices(newSelection.toNativeArray());
    }

    @NotNull
    public DataSourceSettings getSettings() {
        DataSourceSettings dataSourceSettings = this.mySettings;
        if (dataSourceSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/DatabaseConfigEditorImpl", "getSettings"));
        }
        return dataSourceSettings;
    }

    private List<AnAction> getAddActions() {
        ArrayList actions = ContainerUtil.newArrayList();
        PairConsumer consumer = (manager, template) -> this.createDataSource((DbPsiManager)manager, (DataSourceTemplate)template, null, null);
        final DefaultDbPsiManager defaultManager = (DefaultDbPsiManager)((Object)ContainerUtil.findInstance((Iterable)this.mySettings.getPsiFacade().getDbManagers(), DefaultDbPsiManager.class));
        Project project = this.mySettings.getProject();
        DatabaseView.addNewDataSourceActions(project, (List<AnAction>)actions, defaultManager, this.mySettings.getNewDrivers(), this.ACTUALIZE_WRAPPER, (PairConsumer<DbPsiManager, DataSourceTemplate>)consumer);
        if (!actions.isEmpty()) {
            actions.add(Separator.getInstance());
        }
        DatabaseView.addNewDataSourceActions(project, (List<AnAction>)actions, true, this.mySettings.getPsiFacade(), this.ACTUALIZE_WRAPPER, (PairConsumer<DbPsiManager, DataSourceTemplate>)consumer);
        actions.add(new AddDataSourceFromUrl(new DatabaseView.DataSourceFactory(){

            @Override
            public void create(@NotNull DbPsiFacade facade, @NotNull DbPsiManager manager, @NotNull DataSourceTemplate template, @Nullable String s) {
                if (facade == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facade", "com/intellij/database/view/ui/DatabaseConfigEditorImpl$9", "create"));
                }
                if (manager == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/database/view/ui/DatabaseConfigEditorImpl$9", "create"));
                }
                if (template == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "template", "com/intellij/database/view/ui/DatabaseConfigEditorImpl$9", "create"));
                }
                DatabaseConfigEditorImpl.this.createDataSource(manager, template, null, s);
            }
        }));
        actions.add(Separator.getInstance());
        actions.add(new DumbAwareAction("Driver and Data Source", null, DatabaseIcons.UserDriver){

            public void actionPerformed(AnActionEvent e) {
                DatabaseDriver driver = DatabaseConfigEditorImpl.this.createDatabaseDriver();
                DatabaseConfigEditorImpl.this.mySettings.addNewDriver(driver);
                DatabaseConfigEditorImpl.this.createDataSource(defaultManager, driver, null, null);
            }
        });
        actions.add(new DumbAwareAction("Driver", null, DatabaseIcons.UserDriver){

            public void actionPerformed(AnActionEvent e) {
                DatabaseConfigEditorImpl.this.addNewDriverAndNavigate(DatabaseConfigEditorImpl.this.createDatabaseDriver());
            }
        });
        return actions;
    }

    private void ensureNewObjectDropped(Object object) {
        if (object instanceof DbDataSource) {
            this.mySettings.removeNewDataSource((DbDataSource)object);
        } else if (object instanceof DatabaseDriver) {
            this.mySettings.removeNewDriver((DatabaseDriver)object);
        }
    }

    private boolean canRemove(SidePanelItem item) {
        final Ref result = Ref.create((Object)false);
        item.accept(new SidePanelItem.ItemsVisitor(){

            @Override
            boolean visit(SidePanelItem.DataSourceItem dataSourceItem) {
                result.set((Object)true);
                return true;
            }

            @Override
            boolean visit(SidePanelItem.DriverItem driverItem) {
                DatabaseDriver actual;
                DatabaseDriver driver = (DatabaseDriver)driverItem.getObject();
                DatabaseDriverConfigurable configurable = (DatabaseDriverConfigurable)((Object)driverItem.getConfigurable());
                DatabaseDriver databaseDriver = actual = configurable != null ? configurable.getTempDriver() : driver;
                if (driver.isPredefined()) {
                    return false;
                }
                for (DbDataSource ds : DatabaseConfigEditorImpl.this.getAllDataSources()) {
                    DatabaseDriver dsDriver;
                    if (DatabaseConfigEditorImpl.this.myRemovedObjects.contains(ds)) continue;
                    SidePanelItem.DataSourceItem item = (SidePanelItem.DataSourceItem)ObjectUtils.tryCast(DatabaseConfigEditorImpl.this.mySidePanelItems.get(ds), SidePanelItem.DataSourceItem.class);
                    LocalDataSource dataSource = item == null ? null : item.extractActualLocalDataSource();
                    DatabaseDriver databaseDriver2 = dsDriver = dataSource == null ? null : dataSource.getDatabaseDriver();
                    if (dsDriver != driver && dsDriver != actual) continue;
                    return false;
                }
                result.set((Object)true);
                return true;
            }
        });
        return (Boolean)result.get();
    }

    private Collection<DbDataSource> getAllDataSources() {
        LinkedHashSet result = ContainerUtil.newLinkedHashSet(this.mySettings.getDataSources());
        result.addAll(this.mySettings.getNewDataSources());
        result.removeAll(this.myRemovedObjects);
        return result;
    }

    private Collection<DatabaseDriver> getAllDrivers(DataSourceSettings settings) {
        DatabaseDriverManager driverManager = DatabaseDriverManager.getInstance();
        ArrayList result = ContainerUtil.newArrayList(driverManager.getDrivers());
        result.addAll(settings.getNewDrivers());
        result.removeAll(this.myRemovedObjects);
        Collections.sort(result, (o1, o2) -> StringUtil.naturalCompare((String)o1.getName(), (String)o2.getName()));
        return result;
    }

    @Override
    @NotNull
    public ModificationTracker getModificationTracker() {
        SimpleModificationTracker simpleModificationTracker = this.myModificationTracker;
        if (simpleModificationTracker == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/DatabaseConfigEditorImpl", "getModificationTracker"));
        }
        return simpleModificationTracker;
    }

    @Override
    @NotNull
    public ActionCallback navigateTo(final Object object) {
        final Ref place = Ref.create((Object)this.getPlace(object));
        if (place.get() == null) {
            ContainerUtil.process(this.mySidePanelItems.values(), (Processor)new SidePanelItem.ItemsVisitor(){

                @Override
                boolean visit(SidePanelItem.DataSourceItem dataSourceItem) {
                    if (dataSourceItem.getConfigurable() == null || ((AbstractDataSourceConfigurable)((Object)dataSourceItem.getConfigurable())).getTempDataSource() != object) {
                        return true;
                    }
                    place.set((Object)dataSourceItem.getPlace());
                    return false;
                }

                @Override
                boolean visit(SidePanelItem.DriverItem driverItem) {
                    if (driverItem.getConfigurable() == null || ((DatabaseDriverConfigurable)((Object)driverItem.getConfigurable())).getTempDriver() != object) {
                        return true;
                    }
                    place.set((Object)driverItem.getPlace());
                    return false;
                }
            });
        }
        ActionCallback actionCallback = this.navigateTo((Place)place.get(), false);
        if (actionCallback == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/DatabaseConfigEditorImpl", "navigateTo"));
        }
        return actionCallback;
    }

    @Override
    @Nullable
    public <T, C extends AbstractDatabaseConfigurable<? extends T>> C getConfigurable(@Nullable T target, boolean createIfNeeded, @NotNull Class<C> clazz) {
        Condition isTarget;
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/database/view/ui/DatabaseConfigEditorImpl", "getConfigurable"));
        }
        JBIterable items = JBIterable.from(this.mySidePanelItems.values());
        SidePanelItem byTarget = (SidePanelItem)items.find(arg_0 -> DatabaseConfigEditorImpl.lambda$getConfigurable$10(isTarget = o -> o == target || o instanceof DbElement && ((DbElement)o).getDelegate() == target, arg_0));
        if (byTarget != null) {
            if (byTarget.getConfigurable() == null && createIfNeeded) {
                byTarget.createConfigurable();
            }
            return (C)((Object)((AbstractDatabaseConfigurable)((Object)byTarget.getConfigurable())));
        }
        SidePanelItem byTemp = (SidePanelItem)items.find(o -> {
            if (clazz == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/database/view/ui/DatabaseConfigEditorImpl", "lambda$getConfigurable$11"));
            }
            return !isTarget.value(o.getObject()) && clazz.isInstance(o.getConfigurable()) && ((AbstractDatabaseConfigurable)((Object)((Object)o.getConfigurable()))).getTempTarget() == target;
        });
        return (C)((Object)(byTemp == null ? null : (AbstractDatabaseConfigurable)((Object)byTemp.getConfigurable())));
    }

    @Override
    @NotNull
    public <T> Getter<T> getTempTargetOrTarget(@NotNull T target) {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/intellij/database/view/ui/DatabaseConfigEditorImpl", "getTempTargetOrTarget"));
        }
        Getter getter = () -> {
            if (target == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/intellij/database/view/ui/DatabaseConfigEditorImpl", "lambda$getTempTargetOrTarget$12"));
            }
            AbstractDatabaseConfigurable configurable = this.getConfigurable(target, false, AbstractDatabaseConfigurable.class);
            return configurable == null ? target : configurable.getTempTarget();
        };
        if (getter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/DatabaseConfigEditorImpl", "getTempTargetOrTarget"));
        }
        return getter;
    }

    @Override
    public void showErrorNotification(@NotNull Configurable source, @NotNull Object id, @Nullable Exception e) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/view/ui/DatabaseConfigEditorImpl", "showErrorNotification"));
        }
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/database/view/ui/DatabaseConfigEditorImpl", "showErrorNotification"));
        }
        if (e == null) {
            this.showErrorNotification(source, id, null, null, new Object[0]);
            return;
        }
        String longText = JdbcEngine.getErrorMessage(e, source.getDisplayName(), DatabaseFamilyId.UNKNOWN);
        if (longText.isEmpty()) {
            return;
        }
        Pair<String, Object[]> patched = DatabaseConfigEditorImpl.patchMessages(source, longText, new Object[0]);
        if (patched == null) {
            this.showErrorNotification(source, id, "Error", longText, new Object[0]);
        } else {
            this.showErrorNotification(source, id, "Error", (String)patched.first, (Object[])patched.second);
        }
    }

    @Nullable
    private static Pair<String, Object[]> patchMessages(@NotNull Configurable source, @Nullable String message, Object ... linkActions) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/view/ui/DatabaseConfigEditorImpl", "patchMessages"));
        }
        if (linkActions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "linkActions", "com/intellij/database/view/ui/DatabaseConfigEditorImpl", "patchMessages"));
        }
        if (linkActions.length != 0 || message == null) {
            return null;
        }
        if (source instanceof DataSourceConfigurable) {
            DatabaseDriver driver = ((DataSourceConfigurable)source).getTempDataSource().getDatabaseDriver();
            if (message.matches("^Driver class '[^']*' not .*\\n?")) {
                if (driver != null) {
                    return Pair.create((Object)message.replace("Driver class", "<a href=\"$ACTION0\">Driver class</a>"), (Object)new Object[]{new DataSourceProblem.FocusDriverClass(driver)});
                }
            } else if (message.contains("Missing native authentication library: ") && message.contains("driver") && driver != null) {
                return Pair.create((Object)message.replace("driver", "<a href=\"$ACTION0\">driver</a>").replace("\n", "<br>"), (Object)new Object[]{new DataSourceProblem.Navigate(driver)});
            }
        }
        String shortText = message;
        int div = message.indexOf(10);
        if (div > 5) {
            shortText = shortText.substring(0, div);
        }
        if (!Comparing.equal((String)message, (String)(shortText = StringUtil.escapeXml((String)StringUtil.trimLog((String)shortText, (int)80))))) {
            shortText = shortText + " (<a href=\"$ACTION0\">view</a>)";
        }
        return Pair.create((Object)shortText, (Object)new Object[]{() -> Messages.showIdeaMessageDialog(null, (String)message, (String)DatabaseMessages.message((String)"message.title.connection.error", (Object[])new Object[0]), (String[])new String[]{CommonBundle.getOkButtonText()}, (int)0, (Icon)Messages.getErrorIcon(), null)});
    }

    @Override
    public void showErrorNotification(@NotNull Configurable source, @NotNull Object id, @Nullable String title, @Nullable String message, Object ... linkActions) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/view/ui/DatabaseConfigEditorImpl", "showErrorNotification"));
        }
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/database/view/ui/DatabaseConfigEditorImpl", "showErrorNotification"));
        }
        if (linkActions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "linkActions", "com/intellij/database/view/ui/DatabaseConfigEditorImpl", "showErrorNotification"));
        }
        Pair<String, Object[]> patched = DatabaseConfigEditorImpl.patchMessages(source, message, linkActions);
        if (patched != null) {
            message = (String)patched.first;
            linkActions = (Object[])patched.second;
        }
        DataSourceProblem dataSourceProblem = title != null && message != null ? new DataSourceProblem(source, id, DataSourceProblem.Level.ERROR, new DataSourceProblem.HyperText(title, message, message, linkActions), null) : null;
        for (SidePanelItem item : this.mySidePanelItems.values()) {
            if (item.getConfigurable() != source) continue;
            if (dataSourceProblem == null && item.getDataSourceProblem() != null && !Comparing.equal((Object)item.getDataSourceProblem().getId(), (Object)id)) break;
            item.setDataSourceProblem(dataSourceProblem);
            break;
        }
        if (this.mySelectedItem != null && this.mySelectedItem.getConfigurable() == source) {
            this.updateValidationProblem(this.mySelectedItem);
        }
    }

    @Override
    @NotNull
    public DatabaseCredentials getSecretService() {
        DatabaseCredentials databaseCredentials = this.myDatabaseCredentials;
        if (databaseCredentials == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/DatabaseConfigEditorImpl", "getSecretService"));
        }
        return databaseCredentials;
    }

    @Override
    public boolean isObjectApplied(Object object) {
        JBIterable objects = JBIterable.from(this.myRemovedObjects).append(this.mySettings.getNewDataSources()).append(this.mySettings.getNewDrivers());
        for (Object o : objects) {
            if (!(o instanceof DbDataSource) || ((DbDataSource)o).getDelegate() != object) continue;
            return false;
        }
        return !objects.contains(object);
    }

    @Override
    @Nullable
    public JComponent createResetAction(@Nullable Configurable configurable) {
        Ref ritem = Ref.create();
        ContainerUtil.process(this.mySidePanelItems.values(), sitem -> {
            if (sitem.getConfigurable() == configurable) {
                ritem.set(sitem);
                return false;
            }
            return true;
        });
        SidePanelItem item = (SidePanelItem)ritem.get();
        if (item == null) {
            return null;
        }
        JPanel component = new JPanel(new BorderLayout());
        component.add((Component)item.getResetComponent(), "East");
        Dimension size = component.getPreferredSize();
        Dimension constraint = new Dimension((int)size.getWidth(), (int)size.getHeight());
        component.setMinimumSize(constraint);
        component.setPreferredSize(constraint);
        return component;
    }

    @Override
    public void onDriverDownloaded(@NotNull DatabaseDriver driver) {
        if (driver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "driver", "com/intellij/database/view/ui/DatabaseConfigEditorImpl", "onDriverDownloaded"));
        }
        DatabaseDriverConfigurable configurable = this.getConfigurable(driver, true, DatabaseDriverConfigurable.class);
        if (configurable != null) {
            configurable.resetFromTemp();
        }
        this.updateDriverDependants(driver);
    }

    private void updateValidationProblem(@Nullable SidePanelItem item) {
        DataSourceProblem error = item == null ? null : item.getDataSourceProblem();
        this.myErrorInfoComponent.updateWarning(error);
        DataSourceProblem problem = (DataSourceProblem)ContainerUtil.getFirstItem(this.myErrorsCollector.getProblems(item));
        this.myValidationComponent.updateWarning(problem);
    }

    void processAction(final Object action) {
        if (action instanceof Runnable) {
            ((Runnable)action).run();
        } else if (action instanceof Computable) {
            ((Computable)action).compute();
        } else if (action instanceof Progressive) {
            NamedProgressive named = (NamedProgressive)ObjectUtils.tryCast((Object)action, NamedProgressive.class);
            new Task.Modal(null, named == null ? "" : named.getName(), true){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/database/view/ui/DatabaseConfigEditorImpl$14", "run"));
                    }
                    ((Progressive)action).run(indicator);
                }
            }.queue();
        } else if (action instanceof DataSourceProblem.Navigate) {
            this.navigateTo(((DataSourceProblem.Navigate)action).target);
        } else if (action instanceof DataSourceProblem.NewUrlTemplate) {
            DataSourceProblem.NewUrlTemplate newUrlTemplate = (DataSourceProblem.NewUrlTemplate)action;
            DatabaseDriverConfigurable configurable = this.getConfigurable(newUrlTemplate.driver, true, DatabaseDriverConfigurable.class);
            this.addTemplate((DatabaseDriver)ObjectUtils.notNull((Object)(configurable == null ? null : configurable.getDriver()), (Object)newUrlTemplate.driver), newUrlTemplate.template);
        } else if (action instanceof DataSourceProblem.FocusDriverClass) {
            DataSourceProblem.FocusDriverClass focusDriverClass = (DataSourceProblem.FocusDriverClass)action;
            this.focusDriverClassSelector(focusDriverClass.driver);
        }
        this.updateSidePanelImpl();
    }

    private void addTemplate(@NotNull DatabaseDriver driver, @NotNull String template) {
        if (driver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "driver", "com/intellij/database/view/ui/DatabaseConfigEditorImpl", "addTemplate"));
        }
        if (template == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "template", "com/intellij/database/view/ui/DatabaseConfigEditorImpl", "addTemplate"));
        }
        this.navigateTo(driver).doWhenDone(() -> {
            DatabaseDriverConfigurable configurable;
            if (template == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "template", "com/intellij/database/view/ui/DatabaseConfigEditorImpl", "lambda$addTemplate$15"));
            }
            DatabaseDriverConfigurable databaseDriverConfigurable = configurable = this.mySelectedItem == null ? null : (DatabaseDriverConfigurable)((Object)((Object)ObjectUtils.tryCast(this.mySelectedItem.getConfigurable(), DatabaseDriverConfigurable.class)));
            if (configurable == null) {
                return;
            }
            configurable.addNewUrlTemplate(template);
        });
    }

    private void focusDriverClassSelector(@NotNull DatabaseDriver driver) {
        if (driver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "driver", "com/intellij/database/view/ui/DatabaseConfigEditorImpl", "focusDriverClassSelector"));
        }
        this.navigateTo(driver).doWhenDone(() -> {
            DatabaseDriverConfigurable configurable;
            DatabaseDriverConfigurable databaseDriverConfigurable = configurable = this.mySelectedItem == null ? null : (DatabaseDriverConfigurable)((Object)((Object)ObjectUtils.tryCast(this.mySelectedItem.getConfigurable(), DatabaseDriverConfigurable.class)));
            if (configurable == null) {
                return;
            }
            configurable.focusDriverClassSelector();
        });
    }

    public void resurrectDriver(@Nullable DatabaseDriver driver) {
        boolean isNew;
        boolean bl = isNew = !DatabaseDriverManager.getInstance().getDrivers().contains(driver);
        if (isNew && !this.mySettings.getNewDrivers().contains(driver)) {
            this.mySettings.addNewDriver(driver);
        }
        this.myRemovedObjects.remove(driver);
        DbUIUtil.invokeLater(() -> {
            Set selection = this.getSelectedItems().toSet();
            this.refillSidePanel(this.mySettings);
            this.restoreSelection(selection);
        });
    }

    private static /* synthetic */ boolean lambda$getConfigurable$10(Condition isTarget, SidePanelItem o) {
        return isTarget.value(o.getObject());
    }

    private class MyComponentConfigurator
    implements DataSourceSidePanel.ComponentConfigurator {
        private final Map<Icon, Icon> myCache = ContainerUtil.newHashMap();

        private MyComponentConfigurator() {
        }

        @Nullable
        private Icon getGrayIcon(@Nullable Icon icon) {
            if (icon == null) {
                return null;
            }
            Icon res = this.myCache.get(icon);
            if (res == null) {
                res = IconUtil.desaturate((Icon)icon);
                this.myCache.put(icon, res);
            }
            return res;
        }

        @Override
        public void configure(final @NotNull SimpleColoredComponent component, @NotNull Place place, boolean isSelected) {
            int style;
            boolean hasHints;
            if (component == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/database/view/ui/DatabaseConfigEditorImpl$MyComponentConfigurator", "configure"));
            }
            if (place == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/database/view/ui/DatabaseConfigEditorImpl$MyComponentConfigurator", "configure"));
            }
            SidePanelItem item = SidePanelItem.getItem(place);
            if (item == null) {
                return;
            }
            boolean created = DatabaseConfigEditorImpl.this.isObjectCreated(item);
            boolean modified = created || DatabaseConfigEditorImpl.this.isObjectModified(item);
            JBIterable problems = JBIterable.from(DatabaseConfigEditorImpl.this.myErrorsCollector.getProblems(item));
            boolean darcula = UIUtil.isUnderDarcula();
            Object fgColor = isSelected ? UIUtil.getListSelectionForeground() : (created ? (darcula ? JBColor.GREEN : JBColor.GREEN.darker().darker()) : (modified ? JBColor.BLUE : component.getForeground()));
            boolean hasErrors = !problems.filter(p -> p.getLevel() == DataSourceProblem.Level.ERROR).isEmpty();
            boolean hasWarnings = !problems.filter(p -> p.getLevel() == DataSourceProblem.Level.WARNING).isEmpty();
            boolean bl = hasHints = !problems.filter(p -> p.getLevel() == DataSourceProblem.Level.HINT).isEmpty();
            int n = hasErrors ? 8 : (hasWarnings ? 8 : (style = hasHints ? 32 : 0));
            JBColor color = hasErrors ? JBColor.RED : (hasWarnings ? DbUIUtil.WARNING : (darcula ? JBColor.LIGHT_GRAY.brighter() : JBColor.LIGHT_GRAY));
            SimpleTextAttributes textAttributes = new SimpleTextAttributes(style, (Color)fgColor, (Color)color);
            String name = item.getName();
            if (name != null) {
                SpeedSearchUtil.appendColoredFragmentForMatcher((String)name, (SimpleColoredComponent)component, (SimpleTextAttributes)textAttributes, (Matcher)DatabaseConfigEditorImpl.this.mySidePanel.getSpeedSearchMatcher(), (Color)UIUtil.getTreeSelectionBackground(), (boolean)isSelected);
            }
            component.setIcon((Icon)JBUI.scale((JBUI.JBIcon)EmptyIcon.create((int)16)));
            item.accept(new SidePanelItem.ItemsVisitor(){

                @Override
                boolean visit(SidePanelItem.DataSourceItem dataSourceItem) {
                    component.setIcon(MyComponentConfigurator.this.getGrayIcon(((DbDataSourceImpl)((Object)dataSourceItem.getObject())).getIcon(true)));
                    String remarks = ((DbDataSource)dataSourceItem.getObject()).getComment();
                    if (StringUtil.isNotEmpty((String)remarks)) {
                        component.append(" (" + remarks + ")", SimpleTextAttributes.GRAYED_ATTRIBUTES);
                    }
                    return true;
                }

                @Override
                boolean visit(SidePanelItem.DriverItem driverItem) {
                    component.setIcon(MyComponentConfigurator.this.getGrayIcon(((DatabaseDriver)driverItem.getObject()).getIcon(0)));
                    return true;
                }
            });
        }

        @Override
        public void updateCount(@NotNull SidePanelCountLabel count, @NotNull Place place) {
            if (count == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "count", "com/intellij/database/view/ui/DatabaseConfigEditorImpl$MyComponentConfigurator", "updateCount"));
            }
            if (place == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/database/view/ui/DatabaseConfigEditorImpl$MyComponentConfigurator", "updateCount"));
            }
            SidePanelItem.ErrorsItem item = (SidePanelItem.ErrorsItem)ObjectUtils.tryCast((Object)SidePanelItem.getItem(place), SidePanelItem.ErrorsItem.class);
            count.setVisible(item != null && ((DataSourceErrorsConfigurable)item.getObject()).getErrorsCount() > 0);
            if (item != null) {
                count.setText(String.valueOf(((DataSourceErrorsConfigurable)item.getObject()).getErrorsCount()));
            }
        }
    }

    private class MyRootPanel
    extends NonOpaquePanel
    implements DataProvider {
        public MyRootPanel(LayoutManager layout) {
            super(layout);
        }

        @Nullable
        public Object getData(@NonNls String dataId) {
            if (History.KEY.is(dataId)) {
                return DatabaseConfigEditorImpl.this.myHistory;
            }
            return null;
        }
    }

    public class ValidationComponent
    extends JPanel {
        private final JEditorPane myWarningLabel;
        private final List<Object> myActions = ContainerUtil.newArrayList();
        private DataSourceProblem myProblem;

        public ValidationComponent(boolean closeable) {
            this.setLayout(new BorderLayout(5, 5));
            this.setBorder(new CompoundBorder(JBUI.Borders.customLine((Color)OnePixelDivider.BACKGROUND, (int)1, (int)0, (int)0, (int)0), DsUiDefaults.DEFAULT_PANEL_BORDER));
            this.setVisible(false);
            JLabel iconLabel = new JLabel(UIUtil.getBalloonWarningIcon());
            iconLabel.setHorizontalAlignment(2);
            iconLabel.setVerticalAlignment(1);
            this.myWarningLabel = IdeTooltipManager.initPane((String)"", (HintHint)new HintHint(), null);
            this.myWarningLabel.setEditable(false);
            NonOpaquePanel.setTransparent((JComponent)this.myWarningLabel);
            this.myWarningLabel.setBorder(null);
            this.myWarningLabel.addHyperlinkListener(new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent e) {
                    if (e.getEventType() != HyperlinkEvent.EventType.ACTIVATED || ValidationComponent.this.myProblem == null) {
                        return;
                    }
                    Object action = DataSourceProblem.extractAction(e.getDescription(), ValidationComponent.this.myActions);
                    if (action != null) {
                        DatabaseConfigEditorImpl.this.processAction(action);
                    }
                }
            });
            this.add((Component)iconLabel, "West");
            this.add((Component)this.myWarningLabel, "Center");
            if (closeable) {
                JPanel comp = new JPanel(new BorderLayout());
                comp.add((Component)new LinkLabel(null, AllIcons.Actions.Close, (aSource, aLinkData) -> {
                    Configurable configurable;
                    Configurable configurable2 = configurable = this.myProblem.getId() == null ? null : (Configurable)ObjectUtils.tryCast((Object)this.myProblem.getOwner(), Configurable.class);
                    if (configurable != null) {
                        DatabaseConfigEditorImpl.this.showErrorNotification(configurable, this.myProblem.getId(), null);
                    }
                }), "North");
                this.add((Component)comp, "East");
            }
        }

        private void updateWarning(@Nullable DataSourceProblem problem) {
            if (Comparing.equal((Object)problem, (Object)this.myProblem)) {
                return;
            }
            if (problem != null) {
                this.setVisible(true);
                this.myProblem = problem;
                this.myActions.clear();
                this.myWarningLabel.setText(this.generateWarningLabelText());
            } else {
                this.setVisible(false);
                this.myActions.clear();
                this.myProblem = null;
            }
        }

        private String generateWarningLabelText() {
            StringBuilder builder = new StringBuilder("<html><body>");
            String title = this.myProblem.getText().getTitle();
            builder.append("<font face=\"verdana\">");
            if (!StringUtil.isEmptyOrSpaces((String)title)) {
                builder.append("<b>");
                DataSourceProblem.formatText(builder, this.myActions, title, this.myProblem.getText().getLinkActions());
                builder.append("</b>: ");
            }
            DataSourceProblem.formatText(builder, this.myActions, this.myProblem.getText().getShortDescription(), this.myProblem.getText().getLinkActions());
            builder.append("</font></body></html>");
            return builder.toString();
        }
    }

    private class GoToDriverAction
    extends DumbAwareAction
    implements AnActionButtonUpdater {
        public GoToDriverAction() {
            super("Go to Driver", null, AllIcons.General.Settings);
        }

        public void update(AnActionEvent e) {
            boolean enabled = this.isEnabled(e);
            e.getPresentation().setEnabledAndVisible(enabled);
        }

        public void actionPerformed(AnActionEvent e) {
            LocalDataSource localDataSource;
            JBIterable selection = DatabaseConfigEditorImpl.this.getSelectedDataSources();
            SidePanelItem.DataSourceItem dataSource = (SidePanelItem.DataSourceItem)selection.first();
            LocalDataSource localDataSource2 = localDataSource = dataSource == null ? null : dataSource.extractActualLocalDataSource();
            if (localDataSource == null) {
                return;
            }
            DatabaseConfigEditorImpl.this.navigateTo(localDataSource.getDatabaseDriver());
        }

        public boolean isEnabled(AnActionEvent e) {
            JBIterable selection = DatabaseConfigEditorImpl.this.getSelectedDataSources();
            if (selection.size() != 1) {
                return false;
            }
            LocalDataSource localDataSource = ((SidePanelItem.DataSourceItem)ObjectUtils.assertNotNull((Object)selection.first())).extractActualLocalDataSource();
            return localDataSource != null && localDataSource.getDatabaseDriver() != null;
        }
    }

    private class CopyAction
    extends DumbAwareAction
    implements AnActionButtonUpdater {
        private CopyAction() {
            super("Duplicate", null, PlatformIcons.COPY_ICON);
        }

        public void update(AnActionEvent e) {
            boolean enabled = this.isEnabled(e);
            e.getPresentation().setEnabled(enabled);
        }

        public void actionPerformed(AnActionEvent e) {
            SidePanelItem.DataSourceItem dataSourceItem = this.getSelectedDatasourceItem();
            SidePanelItem.DriverItem databaseDriverItem = this.getSelectedDriverItem();
            if (dataSourceItem != null) {
                DbDataSource dataSource = (DbDataSource)dataSourceItem.getObject();
                DataSourceTemplate template = dataSource.getDbManager().getDataSourceTemplate(dataSource);
                if (template == null) {
                    return;
                }
                AbstractDataSourceConfigurable configurable = (AbstractDataSourceConfigurable)((Object)dataSourceItem.getConfigurable());
                Object delegate = configurable instanceof DataSourceConfigurable ? ((DataSourceConfigurable)configurable).getTempDataSourceForConnection() : (configurable != null ? configurable.getTempDataSource() : dataSource.getDelegate());
                DatabaseConfigEditorImpl.this.createDataSource(dataSource.getDbManager(), template, (DatabaseSystem)delegate, null);
            } else if (databaseDriverItem != null) {
                DatabaseDriverImpl databaseDriver = (DatabaseDriverImpl)DatabaseConfigEditorImpl.this.getTempTargetOrTarget(databaseDriverItem.getObject()).get();
                DatabaseConfigEditorImpl.this.addNewDriverAndNavigate(databaseDriver.copy(DatabaseDriverManager.chooseNewDriverName(DatabaseConfigEditorImpl.this.getAllDrivers(DatabaseConfigEditorImpl.this.mySettings), databaseDriver.getName()), false));
            }
        }

        public boolean isEnabled(AnActionEvent e) {
            return this.getSelectedDatasourceItem() != null ^ this.getSelectedDriverItem() != null;
        }

        public SidePanelItem.DataSourceItem getSelectedDatasourceItem() {
            JBIterable selection = DatabaseConfigEditorImpl.this.getSelectedDataSources();
            if (selection.size() != 1) {
                return null;
            }
            SidePanelItem.DataSourceItem item = (SidePanelItem.DataSourceItem)selection.first();
            assert (item != null);
            DbDataSource dbDataSource = (DbDataSource)item.getObject();
            if (dbDataSource.getDbManager().getDataSourceTemplate(dbDataSource) != null) {
                return item;
            }
            return null;
        }

        public SidePanelItem.DriverItem getSelectedDriverItem() {
            JBIterable selection = DatabaseConfigEditorImpl.this.getSelectedDrivers();
            return selection.size() == 1 ? (SidePanelItem.DriverItem)selection.first() : null;
        }
    }

    private class SourceLoadingAction
    extends ActionGroup {
        private final AnAction[] mySetActions;

        public SourceLoadingAction() {
            super("Load Sources", "Which sources to load", AllIcons.Actions.Get);
            this.mySetActions = new AnAction[]{new SetValueAction("None", DBIntrospectionOptions.SourceLoading.NO_SOURCES), new SetValueAction("Except System Schemas", DBIntrospectionOptions.SourceLoading.USER_SOURCES), new SetValueAction("All Schemas", DBIntrospectionOptions.SourceLoading.USER_AND_SYSTEM_SOURCES)};
            this.setPopup(true);
        }

        @NotNull
        public AnAction[] getChildren(@Nullable AnActionEvent e) {
            if (this.mySetActions == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/DatabaseConfigEditorImpl$SourceLoadingAction", "getChildren"));
            }
            return this.mySetActions;
        }

        public void update(AnActionEvent e) {
            boolean enabled = DbSrcStorage.isEnabled() && !this.getLocalDsItems().isEmpty();
            e.getPresentation().setEnabledAndVisible(enabled);
        }

        @NotNull
        private JBIterable<SidePanelItem.DataSourceItem> getLocalDsItems() {
            JBIterable jBIterable = JBIterable.from((Iterable)DatabaseConfigEditorImpl.this.getSelectedItems()).filter(SidePanelItem.DataSourceItem.class).filter(item -> item.extractActualLocalDataSource() != null);
            if (jBIterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/DatabaseConfigEditorImpl$SourceLoadingAction", "getLocalDsItems"));
            }
            return jBIterable;
        }

        private class SetValueAction
        extends DumbAwareAction {
            private final DBIntrospectionOptions.SourceLoading myMode;

            public SetValueAction(@NotNull String caption, DBIntrospectionOptions.SourceLoading mode) {
                if (caption == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "caption", "com/intellij/database/view/ui/DatabaseConfigEditorImpl$SourceLoadingAction$SetValueAction", "<init>"));
                }
                if (mode == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mode", "com/intellij/database/view/ui/DatabaseConfigEditorImpl$SourceLoadingAction$SetValueAction", "<init>"));
                }
                super(caption);
                this.myMode = mode;
            }

            public void actionPerformed(AnActionEvent e) {
                for (SidePanelItem.DataSourceItem item : SourceLoadingAction.this.getLocalDsItems()) {
                    DataSourceConfigurable configurable = (DataSourceConfigurable)((Object)ObjectUtils.tryCast(item.createConfigurable(), DataSourceConfigurable.class));
                    if (configurable == null) continue;
                    configurable.setSourceLoading(this.myMode);
                }
            }
        }
    }

    private class ResetAction
    extends DumbAwareAction {
        public ResetAction() {
            super("Reset Changes", "Reset modifications to item", AllIcons.Actions.Rollback);
        }

        public void update(AnActionEvent e) {
            boolean modified = false;
            for (SidePanelItem item : DatabaseConfigEditorImpl.this.getSelectedItems()) {
                if (!item.isModified()) continue;
                modified = true;
                break;
            }
            e.getPresentation().setEnabled(modified);
        }

        public void actionPerformed(AnActionEvent e) {
            Set selection = DatabaseConfigEditorImpl.this.getSelectedItems().toSet();
            for (SidePanelItem item : DatabaseConfigEditorImpl.this.getSelectedItems()) {
                if (!item.isModified()) continue;
                item.reset();
            }
            DatabaseConfigEditorImpl.this.refillSidePanel(DatabaseConfigEditorImpl.this.mySettings);
            DatabaseConfigEditorImpl.this.restoreSelection(selection);
        }
    }

    private class DataSourceScopeAction
    extends DumbAwareAction {
        public DataSourceScopeAction() {
            super("Data Source Scope", null, AllIcons.ToolbarDecorator.Import);
        }

        boolean isIDEScopeSelected() {
            boolean isIDEScope = true;
            for (SidePanelItem.DataSourceItem item : DatabaseConfigEditorImpl.this.getSelectedLocalDataSources()) {
                isIDEScope &= item.isGlobal();
            }
            return isIDEScope;
        }

        public void update(AnActionEvent e) {
            e.getPresentation().setEnabledAndVisible(!DatabaseConfigEditorImpl.this.getSelectedLocalDataSources().isEmpty());
            e.getPresentation().setText(this.isIDEScopeSelected() ? "Move to Project" : "Make Global");
        }

        public void actionPerformed(AnActionEvent e) {
            Set selection = DatabaseConfigEditorImpl.this.getSelectedItems().toSet();
            boolean isIDEScope = this.isIDEScopeSelected();
            for (SidePanelItem.DataSourceItem item : DatabaseConfigEditorImpl.this.getSelectedLocalDataSources()) {
                DataSourceConfigurable configurable = (DataSourceConfigurable)((Object)ObjectUtils.tryCast((Object)DatabaseConfigEditorImpl.createEditorIfNeeded(item), DataSourceConfigurable.class));
                if (configurable == null) continue;
                configurable.setGlobal(!isIDEScope);
            }
            DatabaseConfigEditorImpl.this.refillSidePanel(DatabaseConfigEditorImpl.this.mySettings);
            DatabaseConfigEditorImpl.this.restoreSelection(selection);
        }
    }

    private class ChooseDriverGroup
    extends ActionGroup
    implements DumbAware {
        public ChooseDriverGroup() {
            super("Change Driver", "Change data source driver", DatabaseIcons.UserDriver);
        }

        public boolean isPopup() {
            return true;
        }

        public void update(AnActionEvent e) {
            JBIterable dataSources = DatabaseConfigEditorImpl.this.getSelectedLocalDataSources();
            e.getPresentation().setVisible(!dataSources.isEmpty());
            e.getPresentation().setEnabled(!this.getDrivers((JBIterable<SidePanelItem.DataSourceItem>)dataSources).isEmpty());
        }

        @NotNull
        JBIterable<DatabaseDriver> getDrivers(JBIterable<SidePanelItem.DataSourceItem> dataSources) {
            JBIterable drivers = dataSources.transform(item -> ((LocalDataSource)((Object)((Object)ObjectUtils.assertNotNull((Object)((Object)item.extractActualLocalDataSource()))))).getDatabaseDriver());
            String defaultDialect = DbSqlUtil.getGenericDialect().getID();
            JBIterable dialects = dataSources.transform(item -> {
                LocalDataSource source = item.extractActualLocalDataSource();
                DatabaseDriver driver = source == null ? null : source.getDatabaseDriver();
                return driver == null ? null : StringUtil.notNullize((String)driver.getDialect(), (String)defaultDialect);
            }).filter(Conditions.notNull());
            if (dialects.toSet().size() != 1) {
                JBIterable jBIterable = JBIterable.empty();
                if (jBIterable == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/DatabaseConfigEditorImpl$ChooseDriverGroup", "getDrivers"));
                }
                return jBIterable;
            }
            DatabaseDriver onlyDriver = drivers.toSet().size() == 1 ? (DatabaseDriver)drivers.first() : null;
            String dialectName = (String)ObjectUtils.assertNotNull((Object)dialects.first());
            JBIterable jBIterable = JBIterable.from((Iterable)DatabaseConfigEditorImpl.this.getAllDrivers(DatabaseConfigEditorImpl.this.mySettings)).filter(DatabaseDriver.class).filter(driver -> dialectName.equals(StringUtil.notNullize((String)((DatabaseDriver)DatabaseConfigEditorImpl.this.getTempTargetOrTarget(driver).get()).getDialect(), (String)defaultDialect))).filter(Conditions.notEqualTo((Object)onlyDriver));
            if (jBIterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/DatabaseConfigEditorImpl$ChooseDriverGroup", "getDrivers"));
            }
            return jBIterable;
        }

        @NotNull
        public AnAction[] getChildren(@Nullable AnActionEvent e) {
            final JBIterable dataSources = DatabaseConfigEditorImpl.this.getSelectedLocalDataSources();
            JBIterable<DatabaseDriver> drivers = this.getDrivers((JBIterable<SidePanelItem.DataSourceItem>)dataSources);
            if (drivers.isEmpty()) {
                if (EMPTY_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/DatabaseConfigEditorImpl$ChooseDriverGroup", "getChildren"));
                }
                return EMPTY_ARRAY;
            }
            final Set selection = DatabaseConfigEditorImpl.this.getSelectedItems().toSet();
            ArrayList res = ContainerUtil.newArrayList();
            for (final DatabaseDriver driver : drivers) {
                DatabaseDriver actual = (DatabaseDriver)DatabaseConfigEditorImpl.this.getTempTargetOrTarget(driver).get();
                res.add(new DumbAwareAction(actual.getName(), null, actual.getIcon(0)){

                    public void actionPerformed(AnActionEvent e) {
                        for (SidePanelItem.DataSourceItem item : dataSources) {
                            DataSourceConfigurable configurable = (DataSourceConfigurable)((Object)ObjectUtils.tryCast((Object)DatabaseConfigEditorImpl.createEditorIfNeeded(item), DataSourceConfigurable.class));
                            if (configurable == null) continue;
                            configurable.setDriver(driver);
                        }
                        DatabaseConfigEditorImpl.this.restoreSelection(selection);
                    }
                });
            }
            AnAction[] anActionArray = res.toArray(new AnAction[res.size()]);
            if (anActionArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/DatabaseConfigEditorImpl$ChooseDriverGroup", "getChildren"));
            }
            return anActionArray;
        }
    }

    private class ResetToPredefinedAction
    extends DumbAwareAction {
        public ResetToPredefinedAction() {
            super("Reset to Predefined", null, AllIcons.Actions.Undo);
        }

        public void actionPerformed(AnActionEvent e) {
            JBIterable drivers = DatabaseConfigEditorImpl.this.getSelectedDrivers().filter(this.isPredefinedChangedCondition());
            for (SidePanelItem.DriverItem driverItem : drivers) {
                DatabaseDriverConfigurable configurable = (DatabaseDriverConfigurable)((Object)driverItem.createConfigurable());
                DatabaseDriverImpl driver = configurable.getTempDriver();
                DatabaseDriverManager.getInstance().resetToPredefined(driver);
                configurable.resetFromTemp();
            }
        }

        public void update(AnActionEvent e) {
            JBIterable selectedDrivers = DatabaseConfigEditorImpl.this.getSelectedDrivers().filter(this.isPredefinedChangedCondition());
            e.getPresentation().setEnabledAndVisible(!selectedDrivers.isEmpty());
        }

        @NotNull
        private Condition<SidePanelItem.DriverItem> isPredefinedChangedCondition() {
            Condition condition = item -> !DatabaseDriverManager.getInstance().isInPredefinedState((DatabaseDriver)DatabaseConfigEditorImpl.this.getTempTargetOrTarget(item.getObject()).get());
            if (condition == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/DatabaseConfigEditorImpl$ResetToPredefinedAction", "isPredefinedChangedCondition"));
            }
            return condition;
        }
    }

    private class ShowUsagesAction
    extends DumbAwareAction {
        public ShowUsagesAction() {
            super("Show Driver Usages", null, AllIcons.Actions.Find);
        }

        public void actionPerformed(AnActionEvent e) {
            DatabaseConfigEditorImpl.this.showUsagesPopup((SidePanelItem.DriverItem)DatabaseConfigEditorImpl.this.getSelectedDrivers().first());
        }

        public void update(AnActionEvent e) {
            JBIterable selectedDrivers = DatabaseConfigEditorImpl.this.getSelectedDrivers();
            e.getPresentation().setEnabledAndVisible(selectedDrivers.size() == 1);
        }
    }

    private class RemoveAction
    extends DumbAwareAction
    implements AnActionButtonRunnable,
    AnActionButtonUpdater {
        private RemoveAction() {
            super("Remove", null, IconUtil.getRemoveIcon());
        }

        public void actionPerformed(AnActionEvent e) {
            this.run(null);
        }

        public void update(AnActionEvent e) {
            boolean enabled = this.isEnabled(e);
            e.getPresentation().setEnabled(enabled);
        }

        public boolean isEnabled(AnActionEvent e) {
            Set selection = DatabaseConfigEditorImpl.this.getSelectedItems().toSet();
            for (SidePanelItem item : selection) {
                if (DatabaseConfigEditorImpl.this.canRemove(item)) continue;
                return false;
            }
            return !selection.isEmpty();
        }

        public void run(AnActionButton button) {
            JList list = DatabaseConfigEditorImpl.this.mySidePanel.getList();
            int index = list.getSelectionModel().getMinSelectionIndex();
            for (SidePanelItem item : DatabaseConfigEditorImpl.this.getSelectedItems()) {
                if (!DatabaseConfigEditorImpl.this.canRemove(item)) continue;
                DatabaseConfigEditorImpl.this.myRemovedObjects.add(item.getObject());
                DatabaseConfigEditorImpl.this.ensureNewObjectDropped(item.getObject());
            }
            DatabaseConfigEditorImpl.this.refillSidePanel(DatabaseConfigEditorImpl.this.mySettings);
            index = Math.max(0, Math.min(list.getModel().getSize() - 2, index));
            list.getSelectionModel().setSelectionInterval(index, index);
        }
    }

    private class AddAction
    extends ActionGroup
    implements DumbAware {
        private AddAction() {
            super("Add", null, IconUtil.getAddIcon());
        }

        public boolean isPopup() {
            return true;
        }

        @NotNull
        public AnAction[] getChildren(@Nullable AnActionEvent e) {
            List actions = DatabaseConfigEditorImpl.this.getAddActions();
            AnAction[] anActionArray = actions.toArray(new AnAction[actions.size()]);
            if (anActionArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/DatabaseConfigEditorImpl$AddAction", "getChildren"));
            }
            return anActionArray;
        }
    }

    static enum Kind {
        DATABASE,
        DRIVER,
        OTHER;


        static Kind kindOf(Object o) {
            if (o instanceof DatabaseSystem) {
                return DATABASE;
            }
            if (o instanceof DatabaseDriver) {
                return DRIVER;
            }
            return OTHER;
        }
    }
}

