/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects;

import com.intellij.database.util.DbSqlUtil;
import com.intellij.lang.PerFileMappings;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.sql.SqlMessages;
import com.intellij.sql.dialects.SqlDialectMappings;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.Consumer;
import com.intellij.util.Producer;
import com.intellij.util.ui.tree.PerFileConfigurableBase;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlDialectsConfigurable
extends PerFileConfigurableBase<SqlLanguageDialect> {
    public SqlDialectsConfigurable(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/sql/dialects/SqlDialectsConfigurable", "<init>"));
        }
        super(project, (PerFileMappings)SqlDialectMappings.getInstance(project));
    }

    @Nls
    public String getDisplayName() {
        return SqlMessages.message("sql.dialects.configurable", new Object[0]);
    }

    @Nullable
    @NonNls
    public String getHelpTopic() {
        return "reference.settings.project.sql.dialects";
    }

    protected void renderValue(@Nullable Object target, @NotNull SqlLanguageDialect dialect, @NotNull ColoredTextContainer renderer) {
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/sql/dialects/SqlDialectsConfigurable", "renderValue"));
        }
        if (renderer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderer", "com/intellij/sql/dialects/SqlDialectsConfigurable", "renderValue"));
        }
        renderer.append(dialect.getDisplayName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
    }

    protected <S> Object getParameter(@NotNull Key<S> key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/sql/dialects/SqlDialectsConfigurable", "getParameter"));
        }
        if (key == DESCRIPTION) {
            return SqlMessages.message("dialog.sql.dialects.caption", ApplicationNamesInfo.getInstance().getProductName(), StringUtil.escapeXml((String)DbSqlUtil.getGenericDialect().getDisplayName()));
        }
        if (key == MAPPING_TITLE) {
            return SqlMessages.message("dialog.sql.dialects.value.title", new Object[0]);
        }
        if (key == OVERRIDE_QUESTION) {
            return SqlMessages.message("dialog.sql.dialects.override.question", new Object[0]);
        }
        if (key == OVERRIDE_TITLE) {
            return SqlMessages.message("dialog.sql.dialects.override.title", new Object[0]);
        }
        return null;
    }

    @NotNull
    protected List<Trinity<String, Producer<SqlLanguageDialect>, Consumer<SqlLanguageDialect>>> getDefaultMappings() {
        List<Trinity<String, Producer<SqlLanguageDialect>, Consumer<SqlLanguageDialect>>> list = Collections.singletonList(Trinity.create((Object)"Global SQL Dialect", () -> SqlDialectMappings.getConfiguredDefaultSqlDialect(), o -> SqlDialectMappings.setDefaultSqlDialect(o)));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/SqlDialectsConfigurable", "getDefaultMappings"));
        }
        return list;
    }

    protected void renderDefaultValue(Object target, @NotNull ColoredTextContainer renderer) {
        if (renderer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderer", "com/intellij/sql/dialects/SqlDialectsConfigurable", "renderDefaultValue"));
        }
        SqlLanguageDialect t = (SqlLanguageDialect)this.getNewMapping((VirtualFile)target);
        if (t == null) {
            return;
        }
        renderer.append(t.getDisplayName(), SimpleTextAttributes.GRAY_ITALIC_ATTRIBUTES);
    }

    public static void openDialectsConfigurable(@NotNull Project project, @Nullable VirtualFile virtualFile) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/sql/dialects/SqlDialectsConfigurable", "openDialectsConfigurable"));
        }
        SqlDialectsConfigurable configurable = new SqlDialectsConfigurable(project);
        ShowSettingsUtil.getInstance().editConfigurable(project, (Configurable)configurable, () -> {
            if (virtualFile != null) {
                configurable.selectFile(virtualFile);
            }
        });
    }
}

