/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects;

import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.ObjectName;
import com.intellij.database.model.RawConnectionConfig;
import com.intellij.database.psi.DbDataSource;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.SqlResolveMappings;
import com.intellij.sql.dialects.TreePattern;
import com.intellij.sql.dialects.TreePatternNode;
import com.intellij.sql.dialects.TreePatternUtils;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SqlImportUtil {
    public static final ObjectKind DATA_SOURCE = new ObjectKind("DATA SOURCE");
    public static final ObjectName NON_MATCHING_NAME = ObjectName.quoted((String)"SOME NON MATCHING NAME");

    @Nullable
    private static TreePatternNode.Group[] removeNulls(@Nullable TreePatternNode.Group[] groups) {
        if (groups == null) {
            return null;
        }
        int nonNulls = 0;
        for (TreePatternNode.Group group2 : groups) {
            if (group2 == null) continue;
            ++nonNulls;
        }
        if (nonNulls == 0) {
            return TreePatternNode.NO_GROUPS;
        }
        if (nonNulls == groups.length) {
            return groups;
        }
        TreePatternNode.Group[] newGroups = new TreePatternNode.Group[nonNulls];
        int i2 = 0;
        for (TreePatternNode.Group group3 : groups) {
            if (group3 == null) continue;
            newGroups[i2++] = group3;
        }
        return newGroups;
    }

    @NotNull
    public static TreePattern createPattern(@NotNull List<ObjectName> names, @NotNull List<ObjectKind> kinds, @Nullable TreePatternNode.Group[] tail) {
        if (names == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "names", "com/intellij/sql/dialects/SqlImportUtil", "createPattern"));
        }
        if (kinds == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kinds", "com/intellij/sql/dialects/SqlImportUtil", "createPattern"));
        }
        TreePatternNode.Group[] children = (TreePatternNode.Group[])ObjectUtils.chooseNotNull((Object)SqlImportUtil.removeNulls(tail), (Object)TreePatternNode.NO_GROUPS);
        for (int i2 = 0; i2 < names.size(); ++i2) {
            TreePatternNode[] treePatternNodeArray;
            ObjectName name = names.get(i2);
            ObjectKind kind = kinds.get(i2);
            TreePatternNode<TreePatternNode.PositiveNaming> p = null;
            TreePatternNode<TreePatternNode.NegativeNaming> n = null;
            if (name == null) {
                n = new TreePatternNode<TreePatternNode.NegativeNaming>(TreePatternNode.NegativeNaming.WILDCARD, children);
            } else {
                p = new TreePatternNode<TreePatternNode.PositiveNaming>(new TreePatternNode.PositiveNaming(name), children);
            }
            TreePatternNode.Group[] groupArray = new TreePatternNode.Group[1];
            if (p == null) {
                treePatternNodeArray = null;
            } else {
                TreePatternNode[] treePatternNodeArray2 = new TreePatternNode[1];
                treePatternNodeArray = treePatternNodeArray2;
                treePatternNodeArray2[0] = p;
            }
            groupArray[0] = new TreePatternNode.Group(kind, treePatternNodeArray, n);
            children = groupArray;
        }
        TreePattern treePattern = new TreePattern(children);
        if (treePattern == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/SqlImportUtil", "createPattern"));
        }
        return treePattern;
    }

    @Nullable
    public static List<ObjectKind> getSingleRootPath(@NotNull ObjectKind kind, @NotNull DatabaseDialectEx dialect) {
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/sql/dialects/SqlImportUtil", "getSingleRootPath"));
        }
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/sql/dialects/SqlImportUtil", "getSingleRootPath"));
        }
        JBIterable roots = dialect.getMetaModel().getPathsToRoot(kind);
        List root2 = (List)roots.first();
        if (root2 == null || root2.isEmpty() || !roots.skip(1).isEmpty()) {
            Logger.getInstance(dialect.getClass()).warn("To many roots from " + kind);
            return null;
        }
        root2 = ContainerUtil.newArrayList((Iterable)root2);
        assert (!root2.isEmpty());
        assert (root2.get(root2.size() - 1) == ObjectKind.ROOT);
        root2.set(root2.size() - 1, DATA_SOURCE);
        return root2;
    }

    @Nullable
    public static TreePattern createRefPattern(@NotNull SqlReferenceExpression ref, @NotNull DatabaseDialectEx dialect) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/sql/dialects/SqlImportUtil", "createRefPattern"));
        }
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/sql/dialects/SqlImportUtil", "createRefPattern"));
        }
        ObjectKind refKind = ref.getReferenceElementType().getTargetKind();
        List<ObjectKind> kinds = SqlImportUtil.getSingleRootPath(refKind, dialect);
        if (kinds == null) {
            return null;
        }
        List names = ContainerUtil.newSmartList();
        names.add(new ObjectName(ref.getName(), !ref.isPlainIdentifier()));
        SqlReferenceExpression qual = (SqlReferenceExpression)ObjectUtils.tryCast((Object)ref.getQualifierExpression(), SqlReferenceExpression.class);
        while (names.size() < kinds.size()) {
            names.add(qual == null ? null : new ObjectName(qual.getName(), !qual.isPlainIdentifier()));
            qual = qual == null ? null : (SqlReferenceExpression)ObjectUtils.tryCast((Object)qual.getQualifierExpression(), SqlReferenceExpression.class);
        }
        return SqlImportUtil.createPattern(names, kinds, null);
    }

    static TreePattern createDefaultScopePattern(@Nullable DbDataSource ds, @NotNull SqlLanguageDialectEx language) {
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/sql/dialects/SqlImportUtil", "createDefaultScopePattern"));
        }
        return language.getDefaultImports(ds);
    }

    @Nullable
    static TreePattern getResolveScopePattern(@NotNull SqlFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/sql/dialects/SqlImportUtil", "getResolveScopePattern"));
        }
        SqlResolveMappings mapping = SqlResolveMappings.getInstance(file.getProject());
        VirtualFile vFile = SqlImplUtil.getTopLevelFile((PsiFile)file);
        return (TreePattern)mapping.getMapping(vFile);
    }

    public static TreePattern processResolveScopePattern(TreePattern resolvePattern, TreePattern defaultPattern) {
        return new TreePatternUtils.GroupedGroupFactory(){
            private boolean myAccept = false;
            private TreePatternNode.Group myUnAccept = null;

            @Override
            protected void enterGroups(TreePatternNode.BaseNaming naming, ObjectKind kind, Iterable<TreePatternNode.Group> groups) {
                TreePatternNode.Group second;
                TreePatternNode.Group first;
                if (this.myAccept || kind == ObjectKind.NONE) {
                    return;
                }
                Iterator<TreePatternNode.Group> it = groups.iterator();
                TreePatternNode.Group group2 = first = it.hasNext() ? it.next() : null;
                if (first != null) {
                    return;
                }
                TreePatternNode.Group group3 = second = it.hasNext() ? it.next() : null;
                if (second == null) {
                    return;
                }
                this.myAccept = true;
                this.myUnAccept = second;
            }

            @Override
            protected void leaveGroups(TreePatternNode.BaseNaming naming, ObjectKind kind, Iterable<TreePatternNode.Group> groups) {
                TreePatternNode.Group second;
                if (!this.myAccept || kind == ObjectKind.NONE) {
                    return;
                }
                Iterator<TreePatternNode.Group> it = groups.iterator();
                if (it.hasNext()) {
                    it.next();
                }
                TreePatternNode.Group group2 = second = it.hasNext() ? it.next() : null;
                if (second != this.myUnAccept) {
                    return;
                }
                this.myAccept = false;
                this.myUnAccept = null;
            }

            @Override
            protected boolean checkGroup(TreePatternNode.BaseNaming naming, ObjectKind kind, @NotNull Iterable<TreePatternNode.Group> value) {
                if (value == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/sql/dialects/SqlImportUtil$1", "checkGroup"));
                }
                Iterator<TreePatternNode.Group> it = value.iterator();
                return this.myAccept || it.hasNext() && it.next() != null;
            }

            @Override
            protected boolean checkNode(TreePatternNode.BaseNaming naming, ObjectKind kind, @NotNull Iterable<TreePatternNode<?>> value) {
                if (value == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/sql/dialects/SqlImportUtil$1", "checkNode"));
                }
                Iterator<TreePatternNode<?>> it = value.iterator();
                return this.myAccept || it.hasNext() && it.next() != null;
            }

            @Override
            public boolean mergeChildren() {
                return false;
            }

            @Override
            public boolean willDestroyEmpty(TreePatternNode.BaseNaming naming, ObjectKind kind, Iterable<TreePatternNode<?>> value) {
                return !1.containsNotNull(value);
            }
        }.merge(Arrays.asList(resolvePattern, defaultPattern));
    }

    @NotNull
    public static TreePatternNode.Group createNode(@Nullable List<ObjectName> name, @NotNull ObjectKind kind, TreePatternNode.Group ... groups) {
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/sql/dialects/SqlImportUtil", "createNode"));
        }
        TreePatternNode.Group group2 = TreePatternUtils.create(name, kind, groups);
        if (group2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/SqlImportUtil", "createNode"));
        }
        return group2;
    }

    @NotNull
    public static TreePatternNode.Group createNode(@Nullable ObjectName name, @NotNull ObjectKind kind, TreePatternNode.Group ... groups) {
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/sql/dialects/SqlImportUtil", "createNode"));
        }
        TreePatternNode.Group group2 = SqlImportUtil.createNode(name == null ? null : Collections.singletonList(name), kind, groups);
        if (group2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/SqlImportUtil", "createNode"));
        }
        return group2;
    }

    @Nullable
    public static TreePatternNode.Group createNodeIfNotNull(@Nullable ObjectName name, @NotNull ObjectKind kind, TreePatternNode.Group ... groups) {
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/sql/dialects/SqlImportUtil", "createNodeIfNotNull"));
        }
        return name == null ? null : SqlImportUtil.createNode(name, kind, groups);
    }

    @NotNull
    public static TreePatternNode.Group createPositiveDatabase(@NotNull ObjectName name, TreePatternNode.Group ... groups) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/sql/dialects/SqlImportUtil", "createPositiveDatabase"));
        }
        TreePatternNode.Group group2 = SqlImportUtil.createNode(name, ObjectKind.DATABASE, groups);
        if (group2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/SqlImportUtil", "createPositiveDatabase"));
        }
        return group2;
    }

    @Nullable
    public static TreePatternNode.Group createPositiveDatabase(boolean useNonMatching, @Nullable ObjectName name, TreePatternNode.Group ... groups) {
        return name == null && !useNonMatching ? null : SqlImportUtil.createNode((ObjectName)ObjectUtils.chooseNotNull((Object)name, (Object)NON_MATCHING_NAME), ObjectKind.DATABASE, groups);
    }

    @NotNull
    public static TreePatternNode.Group createDataSources(@Nullable DbDataSource dataSource, TreePatternNode.Group ... groups) {
        TreePatternNode.Group group2 = SqlImportUtil.createNode(dataSource == null ? NON_MATCHING_NAME : SqlImportUtil.getDataSourceName((DatabaseSystem)dataSource), DATA_SOURCE, groups);
        if (group2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/SqlImportUtil", "createDataSources"));
        }
        return group2;
    }

    @NotNull
    public static ObjectName getDataSourceName(@NotNull DatabaseSystem dataSource) {
        if (dataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/sql/dialects/SqlImportUtil", "getDataSourceName"));
        }
        String id = dataSource.getUniqueId();
        ObjectName objectName = ObjectName.quoted((String)(StringUtil.isEmpty((String)id) ? dataSource.getName() : id));
        if (objectName == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/SqlImportUtil", "getDataSourceName"));
        }
        return objectName;
    }

    @NotNull
    public static TreePattern createAddPattern(@Nullable DbDataSource ds, @NotNull ObjectKind[] kinds) {
        if (kinds == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kinds", "com/intellij/sql/dialects/SqlImportUtil", "createAddPattern"));
        }
        TreePatternNode.Group[] children = TreePatternNode.NO_GROUPS;
        for (int i2 = kinds.length - 1; i2 >= 0; --i2) {
            children = (TreePatternNode.Group[])ContainerUtil.ar((Object[])new TreePatternNode.Group[]{kinds[i2] == DATA_SOURCE && ds != null ? SqlImportUtil.createDataSources(ds, children) : SqlImportUtil.createNode((ObjectName)null, kinds[i2], children)});
        }
        TreePattern treePattern = new TreePattern(children);
        if (treePattern == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/SqlImportUtil", "createAddPattern"));
        }
        return treePattern;
    }

    @NotNull
    public static TreePattern addObjectsByPath(@NotNull TreePattern pattern, @Nullable DbDataSource dataSource, @NotNull List<ObjectName> names, boolean atBegin, ObjectKind ... path) {
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/intellij/sql/dialects/SqlImportUtil", "addObjectsByPath"));
        }
        if (names == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "names", "com/intellij/sql/dialects/SqlImportUtil", "addObjectsByPath"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/sql/dialects/SqlImportUtil", "addObjectsByPath"));
        }
        ObjectKind targetKind = path[path.length - 1];
        TreePattern treePattern = TreePatternUtils.patternProcessor(pattern, SqlImportUtil.createAddPattern(dataSource, path), (g, parent, parentKind) -> {
            if (names == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "names", "com/intellij/sql/dialects/SqlImportUtil", "lambda$addObjectsByPath$0"));
            }
            if (parent instanceof TreePatternNode.NegativeNaming) {
                return TreePatternUtils.SKIP_PROCESSING;
            }
            if (g.kind != targetKind) {
                return g;
            }
            List notFound = ContainerUtil.newSmartList();
            for (ObjectName name : names) {
                if (g.matchedChildren(name, null, null)) continue;
                notFound.add(name);
            }
            if (notFound.isEmpty()) {
                return g;
            }
            TreePatternNode.PositiveNaming naming = new TreePatternNode.PositiveNaming(ObjectName.toArray((Iterable)notFound));
            TreePatternUtils.GroupBuilder builder = TreePatternUtils.GroupBuilder.from(g);
            builder.positives.add(atBegin ? 0 : builder.positives.size(), new TreePatternNode<TreePatternNode.PositiveNaming>(naming, TreePatternNode.NO_GROUPS));
            return builder.build(g.kind);
        });
        if (treePattern == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/SqlImportUtil", "addObjectsByPath"));
        }
        return treePattern;
    }

    @Nullable
    public static RawConnectionConfig getConnectionConfig(@Nullable DbDataSource ds) {
        return ds == null ? null : ds.getConnectionConfig();
    }

    @Nullable
    public static TreePatternNode.Group getRootGroup(boolean schemaRoot, MultiMap<String, String> databases, boolean integrateStar) {
        return schemaRoot ? SqlImportUtil.getSchemaGroup(databases) : SqlImportUtil.getDbGroup(databases, integrateStar);
    }

    @Nullable
    public static TreePatternNode.Group getSchemaGroup(MultiMap<String, String> databases) {
        if (!databases.containsKey((Object)"*")) {
            return null;
        }
        return SqlImportUtil.getSchemaGroups(databases.get((Object)"*"));
    }

    @Nullable
    public static TreePatternNode.Group getSchemaGroups(Collection<String> schemas2) {
        if (schemas2.contains("*")) {
            return TreePatternUtils.create((ObjectName)null, ObjectKind.SCHEMA, TreePatternNode.NO_GROUPS);
        }
        if (schemas2.isEmpty()) {
            return null;
        }
        return TreePatternUtils.create(JBIterable.from(schemas2).transform(n -> ObjectName.quoted((String)n)).toList(), ObjectKind.SCHEMA, TreePatternNode.NO_GROUPS);
    }

    @Nullable
    public static TreePatternNode.Group getDbGroup(MultiMap<String, String> databases, boolean integrateStar) {
        if (databases.containsKey((Object)"*") && !integrateStar) {
            return TreePatternUtils.create((ObjectName)null, ObjectKind.DATABASE, TreePatternNode.NO_GROUPS);
        }
        if (databases.size() == 0) {
            return null;
        }
        ArrayList gr = ContainerUtil.newArrayList();
        for (Map.Entry entry : databases.entrySet()) {
            TreePatternNode.Group sgr = SqlImportUtil.getSchemaGroups((Collection)entry.getValue());
            gr.add(TreePatternUtils.create(((String)entry.getKey()).equals("*") ? null : ObjectName.quoted((String)((String)entry.getKey())), ObjectKind.DATABASE, SqlImportUtil.optAr(sgr)));
        }
        return TreePatternUtils.UNION_PROCESSOR.mergeGroups(ObjectKind.DATABASE, gr);
    }

    public static TreePatternNode.Group[] optAr(TreePatternNode.Group x) {
        return x == null ? TreePatternNode.NO_GROUPS : (TreePatternNode.Group[])ContainerUtil.ar((Object[])new TreePatternNode.Group[]{x});
    }
}

