/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.mssql;

import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.ObjectName;
import com.intellij.database.psi.DbDataSource;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.sql.dialects.ReservedEntity;
import com.intellij.sql.dialects.SqlDialectImplUtil;
import com.intellij.sql.dialects.SqlImportUtil;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.TreePattern;
import com.intellij.sql.dialects.TreePatternNode;
import com.intellij.sql.dialects.TreePatternUtils;
import com.intellij.sql.dialects.functions.SqlFunctionDefinition;
import com.intellij.sql.dialects.functions.SqlFunctionsUtil;
import com.intellij.sql.dialects.mssql.MssqlElementTypes;
import com.intellij.sql.dialects.mssql.MssqlReservedKeywords;
import com.intellij.sql.dialects.mssql.MssqlTokens;
import com.intellij.sql.dialects.mssql.MssqlTypes;
import com.intellij.sql.dialects.sybase.SybaseDialect;
import com.intellij.sql.editor.SqlCloseBlockProcessorImpl;
import com.intellij.sql.editor.SqlEnterHandlerImpl;
import com.intellij.sql.editor.SubstitutionDescriptorImpl;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlElementTypes;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlKeywordTokenType;
import com.intellij.sql.psi.impl.SqlScopeProcessor;
import com.intellij.sql.util.SqlTokenRegistry;
import com.intellij.util.NullableFunction;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MssqlDialect
extends SqlLanguageDialectEx {
    public static final MssqlDialect INSTANCE = new MssqlDialect();

    public MssqlDialect() {
        super("TSQL");
    }

    @NotNull
    public String getDisplayName() {
        if ("SQL Server" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/mssql/MssqlDialect", "getDisplayName"));
        }
        return "SQL Server";
    }

    @Override
    @NotNull
    public DatabaseDialectEx getDatabaseDialect() {
        com.intellij.database.dialects.MssqlDialect mssqlDialect = com.intellij.database.dialects.MssqlDialect.INSTANCE;
        if (mssqlDialect == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/mssql/MssqlDialect", "getDatabaseDialect"));
        }
        return mssqlDialect;
    }

    public boolean isReservedKeyword(IElementType tokenType) {
        return tokenType instanceof SqlKeywordTokenType && LazyData.ourReservedTokens.fun((Object)tokenType.toString()) != null;
    }

    @Override
    @NotNull
    public Map<String, SqlFunctionDefinition> getSupportedFunctions() {
        Map<String, SqlFunctionDefinition> map = Collections.unmodifiableMap(LazyData.ourFunctionMap);
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/mssql/MssqlDialect", "getSupportedFunctions"));
        }
        return map;
    }

    public boolean isOperatorSupported(IElementType tokenType) {
        return LazyData.ourSupportedOperators.contains(tokenType);
    }

    @NotNull
    public Set<String> getKeywords() {
        Set set = SqlTokenRegistry.getTokens(MssqlTokens.class);
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/mssql/MssqlDialect", "getKeywords"));
        }
        return set;
    }

    @NotNull
    public Set<String> getSystemVariables() {
        Set<String> set = LazyData.ourSystemVars;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/mssql/MssqlDialect", "getSystemVariables"));
        }
        return set;
    }

    @Override
    public boolean processReservedEntitiesWithType(@Nullable String name, @NotNull PsiElement element, boolean resolve, @NotNull SqlScopeProcessor processor) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/sql/dialects/mssql/MssqlDialect", "processReservedEntitiesWithType"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/sql/dialects/mssql/MssqlDialect", "processReservedEntitiesWithType"));
        }
        if (SqlImplUtil.equalsInsensetiveOrTrue(name, LazyData.RE_ACTION.name, resolve) && !processor.executeTarget((DasObject)LazyData.RE_ACTION, element, (SqlType)SqlType.STRING, false, ResolveState.initial())) {
            return false;
        }
        if (SqlImplUtil.equalsInsensetiveOrTrue(name, LazyData.RE_IDENTITY.name, resolve) && !processor.executeTarget((DasObject)LazyData.RE_IDENTITY, element, (SqlType)SqlType.STRING, false, ResolveState.initial())) {
            return false;
        }
        if (SqlImplUtil.equalsInsensetiveOrTrue(name, LazyData.RE_ROWGUID.name, resolve) && !processor.executeTarget((DasObject)LazyData.RE_ROWGUID, element, (SqlType)SqlType.STRING, false, ResolveState.initial())) {
            return false;
        }
        return super.processReservedEntitiesWithType(name, element, resolve, processor);
    }

    @Override
    public TokenSet getStatementSeparators() {
        return LazyData.ourClosingTokens;
    }

    @Override
    public String quoteIdentifier(@NotNull SqlIdentifier identifier, @NotNull String newElementName) {
        ObjectKind type;
        if (identifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "identifier", "com/intellij/sql/dialects/mssql/MssqlDialect", "quoteIdentifier"));
        }
        if (newElementName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newElementName", "com/intellij/sql/dialects/mssql/MssqlDialect", "quoteIdentifier"));
        }
        PsiElement parent = identifier.getParent();
        Object object = parent instanceof SqlReferenceExpression ? ((SqlReferenceExpression)parent).getReferenceElementType().getTargetKind() : (type = parent instanceof SqlDefinition ? ((SqlDefinition)parent).getKind() : null);
        if (type == ObjectKind.VARIABLE) {
            return newElementName.replace(' ', '_');
        }
        return super.quoteIdentifier(identifier, newElementName);
    }

    @Override
    public <T extends Collection<ObjectKind>> T getParentDbTypes(T result, ObjectKind type) {
        super.getParentDbTypes(result, type);
        if (type == ObjectKind.INDEX) {
            result.add((ObjectKind)ObjectKind.TABLE);
        }
        return result;
    }

    @Override
    public boolean shouldQuotedTypeReferenceBeChecked(@NotNull String ref) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/sql/dialects/mssql/MssqlDialect", "shouldQuotedTypeReferenceBeChecked"));
        }
        return !this.getKeywords().contains(ref);
    }

    @Override
    @Nullable
    public EnterHandlerDelegate getEnterHandler() {
        return LazyData.ENTER_HANDLER;
    }

    @Override
    public boolean isMajorChild(@NotNull ObjectKind kind) {
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/sql/dialects/mssql/MssqlDialect", "isMajorChild"));
        }
        return kind == ObjectKind.TRIGGER;
    }

    @Override
    @Nullable
    public TreePattern getBaseImports(@Nullable DbDataSource dataSource) {
        List<ObjectName> schemas2 = MssqlDialect.getSchemaNames(dataSource);
        ObjectName dbname = MssqlDialect.getDatabaseName(dataSource);
        DasNamespace namespace = MssqlDialect.getDefaultNamespace(dataSource, dbname);
        if (namespace != null) {
            return SqlDialectImplUtil.createObjectPattern(dataSource, (DasObject)namespace, namespace.getKind() == ObjectKind.SCHEMA ? null : SqlImportUtil.createNode(schemas2, ObjectKind.SCHEMA, new TreePatternNode.Group[0]));
        }
        return new TreePattern(SqlImportUtil.createDataSources(dataSource, SqlImportUtil.optAr(SqlImportUtil.createPositiveDatabase(dataSource == null, dbname, SqlImportUtil.createNode(schemas2, ObjectKind.SCHEMA, new TreePatternNode.Group[0])))));
    }

    @Nullable
    private static ObjectName getDatabaseName(@Nullable DbDataSource dataSource) {
        return ObjectName.plain((String)((String)ObjectUtils.chooseNotNull((Object)SqlDialectImplUtil.getDatabaseName(SqlImportUtil.getConnectionConfig(dataSource)), (Object)"master")));
    }

    @NotNull
    private static List<ObjectName> getSchemaNames(@Nullable DbDataSource dataSource) {
        List schemas2 = ContainerUtil.newSmartList((Object)ObjectName.quoted((String)"dbo"));
        String username = SqlDialectImplUtil.getUserName(SqlImportUtil.getConnectionConfig(dataSource));
        if (username != null) {
            schemas2.add(ObjectName.plain((String)username));
        }
        List list = schemas2;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/mssql/MssqlDialect", "getSchemaNames"));
        }
        return list;
    }

    @Override
    @NotNull
    public TreePattern forcedContextPattern(@Nullable DbDataSource dataSource, @NotNull Iterable<? extends DasNamespace> objects) {
        if (objects == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "objects", "com/intellij/sql/dialects/mssql/MssqlDialect", "forcedContextPattern"));
        }
        TreePatternNode.Group[] schemas2 = (TreePatternNode.Group[])ContainerUtil.ar((Object[])new TreePatternNode.Group[]{TreePatternUtils.create(MssqlDialect.getSchemaNames(dataSource), ObjectKind.SCHEMA, new TreePatternNode.Group[0])});
        TreePatternNode.Group[] databases = (TreePatternNode.Group[])ContainerUtil.ar((Object[])new TreePatternNode.Group[]{TreePatternUtils.create(MssqlDialect.getDatabaseName(dataSource), ObjectKind.DATABASE, schemas2)});
        TreePattern treePattern = SybaseDialect.forcedContextExpandedToSchemas(dataSource, objects, schemas2, databases);
        if (treePattern == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/mssql/MssqlDialect", "forcedContextPattern"));
        }
        return treePattern;
    }

    @Override
    @NotNull
    public TreePattern srcFilePattern(@Nullable DbDataSource dataSource, @NotNull DasNamespace object) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/sql/dialects/mssql/MssqlDialect", "srcFilePattern"));
        }
        TreePattern treePattern = this.forcedContextPattern(dataSource, Collections.singletonList(object));
        if (treePattern == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/mssql/MssqlDialect", "srcFilePattern"));
        }
        return treePattern;
    }

    private static class LazyData {
        static final Map<String, SqlFunctionDefinition> ourFunctionMap = Collections.unmodifiableMap(SqlFunctionsUtil.loadFunctionDefinition(INSTANCE));
        static final Set<String> ourSystemVars = Collections.unmodifiableSet(SqlDialectImplUtil.loadSystemVars(INSTANCE));
        static final NullableFunction<String, IElementType> ourReservedTokens = SqlTokenRegistry.getTokenProvider(MssqlReservedKeywords.class);
        static final TokenSet ourClosingTokens = TokenSet.orSet((TokenSet[])new TokenSet[]{SqlTokens.STATEMENT_SEPARATORS, TokenSet.create((IElementType[])new IElementType[]{MssqlTypes.MSSQL_GO})});
        static final Set<IElementType> ourSupportedOperators = ContainerUtil.newTroveSet((Object[])new IElementType[]{SqlElementTypes.SQL_OP_PLUS, SqlElementTypes.SQL_OP_MINUS, SqlElementTypes.SQL_OP_MUL, SqlElementTypes.SQL_OP_DIV, SqlElementTypes.SQL_OP_NEQ, SqlElementTypes.SQL_OP_LE, SqlElementTypes.SQL_OP_LT, SqlElementTypes.SQL_OP_GE, SqlElementTypes.SQL_OP_EQ, SqlElementTypes.SQL_OP_GT, SqlElementTypes.SQL_OP_CONCAT, SqlElementTypes.SQL_AND, SqlElementTypes.SQL_NOT, SqlElementTypes.SQL_OR, SqlElementTypes.SQL_IS, SqlElementTypes.SQL_LIKE, SqlElementTypes.SQL_COLLATE, SqlElementTypes.SQL_IN, SqlElementTypes.SQL_OP_LOGICAL_AND, SqlElementTypes.SQL_OP_BITWISE_AND, SqlElementTypes.SQL_OP_BITWISE_NOT, SqlElementTypes.SQL_OP_BITWISE_OR, SqlElementTypes.SQL_OP_LOGICAL_OR, SqlElementTypes.SQL_OP_BITWISE_XOR, SqlElementTypes.SQL_OP_MODULO, SqlElementTypes.SQL_OP_NEQ2, SqlElementTypes.SQL_OP_NOT_LT, SqlElementTypes.SQL_OP_NOT_GT, SqlElementTypes.SQL_OP_PLUS_EQ, SqlElementTypes.SQL_OP_MINUS_EQ, SqlElementTypes.SQL_OP_MUL_EQ, SqlElementTypes.SQL_OP_DIV_EQ, SqlElementTypes.SQL_OP_MODULO_EQ, SqlElementTypes.SQL_OP_BITWISE_AND_EQ, SqlElementTypes.SQL_OP_BITWISE_OR_EQ, SqlElementTypes.SQL_OP_BITWISE_XOR_EQ});
        static final ReservedEntity RE_ACTION = new ReservedEntity("$action", ObjectKind.COLUMN);
        static final ReservedEntity RE_IDENTITY = new ReservedEntity("$IDENTITY", ObjectKind.COLUMN);
        static final ReservedEntity RE_ROWGUID = new ReservedEntity("$ROWGUID", ObjectKind.COLUMN);
        private static final EnterHandlerDelegate ENTER_HANDLER = new SqlEnterHandlerImpl(new SqlCloseBlockProcessorImpl(new SubstitutionDescriptorImpl(new IElementType[]{SqlElementTypes.SQL_BEGIN, SqlElementTypes.SQL_BLOCK_STATEMENT}, "", "end", 1, SubstitutionDescriptorImpl.TailCheck.tail(new IElementType[]{SqlElementTypes.SQL_END, SqlElementTypes.SQL_SEMICOLON}).mask(true, false)), new SubstitutionDescriptorImpl(new IElementType[]{MssqlTypes.MSSQL_TRY, MssqlElementTypes.MSSQL_TRY_CATCH_STATEMENT}, "", "end try\nbegin catch\nend catch", 1, SubstitutionDescriptorImpl.TailCheck.builder().man(new IElementType[]{SqlElementTypes.SQL_END}).man(MssqlTypes.MSSQL_TRY).opt(new IElementType[]{MssqlElementTypes.MSSQL_CATCH_CLAUSE, SqlElementTypes.SQL_SEMICOLON}).build()), new SubstitutionDescriptorImpl(new IElementType[]{MssqlTypes.MSSQL_CATCH, MssqlElementTypes.MSSQL_CATCH_CLAUSE}, "", "end catch", 1, SubstitutionDescriptorImpl.TailCheck.tail(new IElementType[]{SqlElementTypes.SQL_END, MssqlTypes.MSSQL_CATCH, SqlElementTypes.SQL_SEMICOLON}).mask(true, true, false))));

        private LazyData() {
        }
    }
}

