/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.mysql;

import com.intellij.lexer.Lexer;
import com.intellij.lexer.LookAheadLexer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.dialects.mysql.MysqlElementTypes;
import com.intellij.sql.dialects.mysql.MysqlOptionalKeywords;
import com.intellij.sql.dialects.mysql.MysqlReservedKeywords;
import com.intellij.sql.dialects.mysql.MysqlTokens;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.impl.lexer.SqlLexer;
import com.intellij.sql.psi.impl.lexer._MysqlLexer;
import com.intellij.util.containers.ImmutableUserMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MysqlLexer
extends SqlLexer {
    private boolean myStatementStart;
    private String myDelimiter;
    private boolean myInSpecialComment;

    public MysqlLexer() {
        super(MysqlTokens.class, new _MysqlLexer());
    }

    public void start(@NotNull CharSequence buffer, int startOffset, int endOffset, int initialState) {
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "com/intellij/sql/dialects/mysql/MysqlLexer", "start"));
        }
        this.myStatementStart = true;
        this.myInSpecialComment = false;
        this.myDelimiter = null;
        super.start(buffer, startOffset, endOffset, initialState);
    }

    @Override
    protected void lookAhead(Lexer baseLexer) {
        int delimiterIndex;
        IElementType tokenType = baseLexer.getTokenType();
        if (this.myStatementStart && MysqlOptionalKeywords.MYSQL_DELIMITER.toString().equalsIgnoreCase(baseLexer.getTokenText())) {
            this.advanceAs(baseLexer, (IElementType)MysqlOptionalKeywords.MYSQL_DELIMITER);
            if (baseLexer.getTokenType() != SqlTokens.SQL_WHITE_SPACE) {
                this.advanceAs(baseLexer, SqlTokens.BAD_CHARACTER);
                this.myStatementStart = true;
            } else {
                this.advanceAs(baseLexer, SqlTokens.SQL_WHITE_SPACE);
                this.myStatementStart = this.lookAheadForDelimiter(baseLexer, null);
            }
        } else if (this.myDelimiter != null && (delimiterIndex = baseLexer.getBufferSequence().subSequence(baseLexer.getTokenStart(), Math.min(baseLexer.getBufferEnd(), baseLexer.getTokenEnd() + this.myDelimiter.length() - 1)).toString().indexOf(this.myDelimiter)) > -1) {
            int tokenStart = baseLexer.getTokenStart();
            int bufferEnd = baseLexer.getBufferEnd();
            if (delimiterIndex > 0) {
                baseLexer.start(baseLexer.getBufferSequence(), tokenStart, tokenStart + delimiterIndex, baseLexer.getState());
                while (baseLexer.getTokenType() != null) {
                    this.advanceAs(baseLexer, this.getSqlTokenType(baseLexer));
                }
            }
            int delimiterEnd = tokenStart + delimiterIndex + this.myDelimiter.length();
            this.addToken(delimiterEnd, (IElementType)SqlTokens.MYSQL_DELIMITER_TOKEN);
            baseLexer.start(baseLexer.getBufferSequence(), delimiterEnd, bufferEnd, 0);
            this.myStatementStart = true;
        } else if (tokenType == SqlTokens.SQL_SEMICOLON) {
            this.myStatementStart = true;
            this.advanceAs(baseLexer, (IElementType)SqlTokens.SQL_SEMICOLON);
        } else if (tokenType == SqlTokens.SQL_BLOCK_COMMENT) {
            CharSequence tokenSequence = baseLexer.getBufferSequence().subSequence(baseLexer.getTokenStart(), Math.min(baseLexer.getBufferEnd(), baseLexer.getTokenEnd()));
            if (StringUtil.startsWith((CharSequence)tokenSequence, (CharSequence)"/*!")) {
                char c;
                int start;
                this.myInSpecialComment = true;
                int len = tokenSequence.length();
                for (start = 3; start < len && '0' <= (c = tokenSequence.charAt(start)) && c <= '9'; ++start) {
                }
                this.addToken(start += baseLexer.getTokenStart(), (IElementType)SqlTokens.MYSQL_PRAGMA_BEGIN);
                baseLexer.start(baseLexer.getBufferSequence(), start, baseLexer.getBufferEnd(), baseLexer.getState());
            } else {
                this.myInSpecialComment = false;
                super.lookAhead(baseLexer);
            }
        } else if (this.myInSpecialComment && tokenType == SqlTokens.SQL_ASTERISK && baseLexer.getTokenEnd() < baseLexer.getBufferEnd() && baseLexer.getBufferSequence().charAt(baseLexer.getTokenEnd()) == '/') {
            this.myInSpecialComment = false;
            this.addToken(baseLexer.getTokenEnd() + 1, (IElementType)SqlTokens.MYSQL_PRAGMA_END);
            baseLexer.start(baseLexer.getBufferSequence(), baseLexer.getTokenEnd() + 1, baseLexer.getBufferEnd(), baseLexer.getState());
        } else {
            if (this.myStatementStart && tokenType != SqlTokens.WHITE_SPACE && !SqlTokens.COMMENT_TOKENS.contains(tokenType)) {
                this.myStatementStart = false;
            }
            super.lookAhead(baseLexer);
        }
    }

    private boolean lookAheadForDelimiter(Lexer baseLexer, @Nullable String delimiter) {
        String text;
        int tokenStart = baseLexer.getTokenStart();
        int currentTokenEnd = 0;
        IElementType type = baseLexer.getTokenType();
        while (type != SqlTokens.WHITE_SPACE && type != null) {
            currentTokenEnd = baseLexer.getTokenEnd();
            baseLexer.advance();
            type = baseLexer.getTokenType();
        }
        String string = text = currentTokenEnd > tokenStart ? baseLexer.getBufferSequence().subSequence(tokenStart, currentTokenEnd).toString() : "";
        if (delimiter == null) {
            if (text.equals(";")) {
                this.addToken(currentTokenEnd, (IElementType)SqlTokens.SQL_SEMICOLON);
                this.myDelimiter = null;
                return true;
            }
            if (text.length() > 0) {
                this.myDelimiter = text;
                this.addToken(currentTokenEnd, (IElementType)SqlTokens.MYSQL_DELIMITER_TOKEN);
                return true;
            }
        } else if (delimiter.equals(text)) {
            this.addToken(currentTokenEnd, (IElementType)SqlTokens.MYSQL_DELIMITER_TOKEN);
            return true;
        }
        return false;
    }

    @NotNull
    public LookAheadLexer.LookAheadLexerPosition getCurrentPosition() {
        MyPosition myPosition = new MyPosition(this, ImmutableUserMap.EMPTY);
        if (myPosition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/mysql/MysqlLexer", "getCurrentPosition"));
        }
        return myPosition;
    }

    protected void restore(LookAheadLexer.LookAheadLexerPosition position) {
        super.restore(position);
        if (position instanceof MyPosition) {
            this.myDelimiter = ((MyPosition)position).myDelimiter;
            this.myStatementStart = ((MyPosition)position).myStatementStart;
        }
    }

    static {
        MysqlLexer.initTokensAndFunctions(MysqlElementTypes.MYSQL_SQL_FILE, MysqlTokens.class, MysqlReservedKeywords.class, MysqlOptionalKeywords.class);
    }

    private static class MyPosition
    extends LookAheadLexer.LookAheadLexerPosition {
        final String myDelimiter;
        final boolean myStatementStart;

        public MyPosition(MysqlLexer lookAheadLexer, ImmutableUserMap map) {
            super((LookAheadLexer)lookAheadLexer, map);
            this.myDelimiter = lookAheadLexer.myDelimiter;
            this.myStatementStart = lookAheadLexer.myStatementStart;
        }
    }
}

