/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.editor;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@com.intellij.openapi.components.State(name="SqlEditorOptions", storages={@Storage(value="editor.xml")})
public class SqlEditorOptions
implements PersistentStateComponent<State> {
    private boolean myConcatenateStringsOnEnter = true;
    private QualificationType myQualificationType = QualificationTypeImpl.SMART;

    @Nullable
    public State getState() {
        State state = new State();
        state.setConcatenateStringsOnEnter(this.isConcatenateStringsOnEnter());
        state.setQualificationType(this.myQualificationType.toString());
        return state;
    }

    public void loadState(State state) {
        if (state != null) {
            state.load(this);
        }
    }

    public boolean isConcatenateStringsOnEnter() {
        return this.myConcatenateStringsOnEnter;
    }

    public void setConcatenateStringsOnEnter(boolean concatenateStringsOnEnter) {
        this.myConcatenateStringsOnEnter = concatenateStringsOnEnter;
    }

    @NotNull
    public QualificationType getQualificationType() {
        QualificationType qualificationType = this.myQualificationType;
        if (qualificationType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/editor/SqlEditorOptions", "getQualificationType"));
        }
        return qualificationType;
    }

    public void setQualificationType(QualificationType qualificationType) {
        this.myQualificationType = qualificationType;
    }

    @NotNull
    public static SqlEditorOptions getInstance() {
        SqlEditorOptions sqlEditorOptions = (SqlEditorOptions)ServiceManager.getService(SqlEditorOptions.class);
        if (sqlEditorOptions == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/editor/SqlEditorOptions", "getInstance"));
        }
        return sqlEditorOptions;
    }

    public static class State {
        private boolean myConcatenateStringsOnEnter;
        private String myQualificationType;

        void load(@NotNull SqlEditorOptions options) {
            if (options == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/sql/editor/SqlEditorOptions$State", "load"));
            }
            options.setConcatenateStringsOnEnter(this.isConcatenateStringsOnEnter());
            if (this.getQualificationType() != null) {
                options.setQualificationType(QualificationTypeImpl.of(this.myQualificationType));
            }
        }

        public void setConcatenateStringsOnEnter(boolean concatenateOnEnter) {
            this.myConcatenateStringsOnEnter = concatenateOnEnter;
        }

        public void setQualificationType(@NotNull String qualificationType) {
            if (qualificationType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualificationType", "com/intellij/sql/editor/SqlEditorOptions$State", "setQualificationType"));
            }
            this.myQualificationType = qualificationType;
        }

        public String getQualificationType() {
            return this.myQualificationType;
        }

        public boolean isConcatenateStringsOnEnter() {
            return this.myConcatenateStringsOnEnter;
        }
    }

    static enum QualificationTypeImpl implements QualificationType
    {
        ALWAYS{

            @Override
            public boolean shouldQualify(int conflictedObjectsCount) {
                return true;
            }

            public String toString() {
                return "Always";
            }
        }
        ,
        SMART{

            @Override
            public boolean shouldQualify(int conflictedObjectsCount) {
                return conflictedObjectsCount > 1;
            }

            public String toString() {
                return "On collisions";
            }
        }
        ,
        NOT_QUALIFY{

            @Override
            public boolean shouldQualify(int conflictedObjectsCount) {
                return false;
            }

            public String toString() {
                return "Never";
            }
        };


        @NotNull
        static QualificationType of(@NotNull String string) {
            if (string == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "string", "com/intellij/sql/editor/SqlEditorOptions$QualificationTypeImpl", "of"));
            }
            for (QualificationTypeImpl type : QualificationTypeImpl.values()) {
                if (!StringUtil.equals((CharSequence)string, (CharSequence)type.toString())) continue;
                QualificationTypeImpl qualificationTypeImpl = type;
                if (qualificationTypeImpl == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/editor/SqlEditorOptions$QualificationTypeImpl", "of"));
                }
                return qualificationTypeImpl;
            }
            QualificationTypeImpl qualificationTypeImpl = SMART;
            if (qualificationTypeImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/editor/SqlEditorOptions$QualificationTypeImpl", "of"));
            }
            return qualificationTypeImpl;
        }
    }

    public static interface QualificationType {
        public boolean shouldQualify(int var1);
    }
}

