/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.editor;

import com.intellij.application.options.editor.EditorOptionsProvider;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.sql.editor.SqlEditorOptions;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlEditorOptionsProvider
implements EditorOptionsProvider {
    private JBCheckBox myConcatenateOnEnterCheckBox;
    private JPanel myMainPanel;
    private ComboBox<SqlEditorOptions.QualificationType> myQualificationTypeCombo;
    private JBLabel myQualificationTypeLabel;

    public SqlEditorOptionsProvider() {
        this.$$$setupUI$$$();
    }

    @NotNull
    public String getId() {
        if ("editor.preferences.sqlOptions" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/editor/SqlEditorOptionsProvider", "getId"));
        }
        return "editor.preferences.sqlOptions";
    }

    @Nullable
    public JComponent createComponent() {
        return this.myMainPanel;
    }

    public boolean isModified() {
        SqlEditorOptions instance = SqlEditorOptions.getInstance();
        return this.myConcatenateOnEnterCheckBox.isSelected() != instance.isConcatenateStringsOnEnter() || this.myQualificationTypeCombo.getSelectedItem() != instance.getQualificationType();
    }

    public void apply() throws ConfigurationException {
        SqlEditorOptions instance = SqlEditorOptions.getInstance();
        instance.setConcatenateStringsOnEnter(this.myConcatenateOnEnterCheckBox.isSelected());
        instance.setQualificationType((SqlEditorOptions.QualificationType)this.myQualificationTypeCombo.getSelectedItem());
    }

    public void reset() {
        SqlEditorOptions instance = SqlEditorOptions.getInstance();
        this.myConcatenateOnEnterCheckBox.setSelected(instance.isConcatenateStringsOnEnter());
        this.myQualificationTypeCombo.setSelectedItem((Object)instance.getQualificationType());
    }

    @Nls
    public String getDisplayName() {
        return "Sql";
    }

    @Nullable
    public String getHelpTopic() {
        return null;
    }

    private void createUIComponents() {
        this.myQualificationTypeCombo = new ComboBox((Object[])SqlEditorOptions.QualificationTypeImpl.values());
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBLabel jBLabel;
        JBCheckBox jBCheckBox;
        JPanel jPanel;
        this.createUIComponents();
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel2.add((Component)jPanel, new GridConstraints(0, 0, 1, 1, 8, 2, 3, 3, null, null, null));
        jPanel.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)"SQL", (int)0, (int)0, null, null));
        this.myConcatenateOnEnterCheckBox = jBCheckBox = new JBCheckBox();
        jBCheckBox.setText("Insert string concatenation on Enter");
        jPanel.add((Component)jBCheckBox, new GridConstraints(0, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        this.myQualificationTypeLabel = jBLabel = new JBLabel();
        jBLabel.setText("Qualify object on code completion:");
        jPanel.add((Component)jBLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        ComboBox<SqlEditorOptions.QualificationType> comboBox = this.myQualificationTypeCombo;
        jPanel.add((Component)comboBox, new GridConstraints(1, 1, 1, 1, 8, 0, 2, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
    }
}

