/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl;

import com.intellij.database.model.DasTable;
import com.intellij.database.model.DasTableChild;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.MultiRef;
import com.intellij.database.util.DasUtil;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.sql.psi.SqlAlterStatement;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlExtraDeclarationsProvider;
import com.intellij.sql.psi.SqlIndexDefinition;
import com.intellij.sql.psi.SqlNameElement;
import com.intellij.sql.psi.SqlReferenceElementType;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlReferenceList;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.SqlTableColumnsList;
import com.intellij.sql.psi.impl.SqlColumnDefinitionImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.stubs.SqlStubbedDefinitionImpl;
import com.intellij.sql.psi.stubs.SqlTableKeyStub;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SqlKIFKImpl<T extends SqlTableKeyStub<?>>
extends SqlStubbedDefinitionImpl<T>
implements DasTableChild,
SqlExtraDeclarationsProvider {
    private MultiRef<? extends DasTypedObject> myColumnsRef;

    public SqlKIFKImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/sql/psi/impl/SqlKIFKImpl", "<init>"));
        }
        super(node);
    }

    protected SqlKIFKImpl(T stub, @NotNull IStubElementType nodeType) {
        if (nodeType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodeType", "com/intellij/sql/psi/impl/SqlKIFKImpl", "<init>"));
        }
        super(stub, nodeType);
    }

    @Override
    protected SqlReferenceElementType getExpectedNameReferenceElementType() {
        return SqlCompositeElementTypes.SQL_CONSTRAINT_REFERENCE;
    }

    public String getTableName() {
        SqlTableKeyStub stub = (SqlTableKeyStub)this.getStub();
        if (stub != null) {
            SqlTableColumnsList tableColumnsList = stub.getKeyColumnList();
            return tableColumnsList == null ? null : tableColumnsList.getTableReference().getText();
        }
        SqlStatement statement = (SqlStatement)this.getStubOrPsiParentOfType(SqlStatement.class);
        if (statement instanceof DasTable) {
            return statement.getName();
        }
        if (statement instanceof SqlAlterStatement) {
            SqlReferenceExpression ref = ((SqlAlterStatement)statement).getAlterTargetReference();
            return ref == null ? null : ref.getText();
        }
        return null;
    }

    @Override
    public void subtreeChanged() {
        super.subtreeChanged();
        this.myColumnsRef = null;
    }

    public boolean processExtraDeclarations(PsiScopeProcessor processor, ResolveState state, PsiElement lastParent, PsiElement place) {
        SqlIndexDefinition index = (SqlIndexDefinition)SqlImplUtil.childrenIt((PsiElement)this).filter(SqlIndexDefinition.class).first();
        return index == null || processor.execute((PsiElement)index, state);
    }

    @NotNull
    public MultiRef<? extends DasTypedObject> getColumnsRef() {
        if (this.myColumnsRef == null) {
            SqlColumnDefinitionImpl column = (SqlColumnDefinitionImpl)this.getStubOrPsiParentOfType(SqlColumnDefinitionImpl.class);
            if (column != null) {
                this.myColumnsRef = DasUtil.asRef(Collections.singletonList(column));
            } else {
                List<SqlReferenceExpression> list = SqlImplUtil.getReferenceList(this.getColumnsList());
                this.myColumnsRef = SqlKIFKImpl.asColumnsRef(list);
            }
        }
        MultiRef<? extends DasTypedObject> multiRef = this.myColumnsRef;
        if (multiRef == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlKIFKImpl", "getColumnsRef"));
        }
        return multiRef;
    }

    public DasTable getTable() {
        SqlColumnDefinitionImpl column = (SqlColumnDefinitionImpl)this.getStubOrPsiParentOfType(SqlColumnDefinitionImpl.class);
        if (column != null) {
            return column.getTable();
        }
        SqlStatement statement = (SqlStatement)this.getStubOrPsiParentOfType(SqlStatement.class);
        if (statement instanceof DasTable) {
            return (DasTable)statement;
        }
        if (statement instanceof SqlAlterStatement) {
            PsiElement element;
            SqlReferenceExpression targetRef = ((SqlAlterStatement)statement).getAlterTargetReference();
            PsiElement psiElement = element = targetRef == null ? null : targetRef.resolve();
            if (element instanceof DasTable) {
                return (DasTable)element;
            }
        }
        return null;
    }

    @Nullable
    protected SqlReferenceList getColumnsList() {
        SqlTableKeyStub stub = (SqlTableKeyStub)this.getStub();
        if (stub != null) {
            SqlTableColumnsList tableColumnsList = stub.getKeyColumnList();
            return tableColumnsList == null ? null : tableColumnsList.getColumnsReferenceList();
        }
        return (SqlReferenceList)this.findChildByClass(SqlReferenceList.class);
    }

    public boolean isPrimary() {
        return false;
    }

    protected static MultiRef<DasTypedObject> asColumnsRef(Iterable<SqlReferenceExpression> refList) {
        return DasUtil.asRef(refList, SqlNameElement::getName, expression -> {
            for (ResolveResult result : expression.multiResolve(false)) {
                if (!(result.getElement() instanceof DasTypedObject)) continue;
                return (DasTypedObject)result.getElement();
            }
            return null;
        });
    }
}

