/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl.lexer;

import com.intellij.database.util.TokenPattern;
import com.intellij.lexer.DelegateLexer;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.tree.IElementType;
import java.util.regex.MatchResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PreprocessingLexer
extends DelegateLexer {
    private static final Logger LOG = Logger.getInstance(PreprocessingLexer.class);
    private Integer myStoredState;
    private MatchState myMatchState;
    private int myEndOffset;

    public PreprocessingLexer(@NotNull Lexer delegate, TokenPattern pattern) {
        if (delegate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "com/intellij/sql/psi/impl/lexer/PreprocessingLexer", "<init>"));
        }
        super(delegate);
        this.myMatchState = new MatchState(pattern);
    }

    public void start(@NotNull CharSequence buffer, int startOffset, int endOffset, int initialState) {
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "com/intellij/sql/psi/impl/lexer/PreprocessingLexer", "start"));
        }
        super.start(buffer, startOffset, endOffset, initialState < 0 ? -initialState - 1 : initialState);
        this.myMatchState.reset(buffer);
        this.myEndOffset = endOffset;
        this.myMatchState.findMatchOn(startOffset, this.myEndOffset);
        this.processCurrentState();
    }

    private void processTokenMatch(int state) {
        this.myStoredState = state;
        this.onNextMatched();
    }

    private void correctCurrentMatch() {
        int start = super.getTokenStart();
        int end = super.getTokenEnd();
        assert (this.myMatchState.myStart >= start);
        if (this.myMatchState.myStart >= end) {
            return;
        }
        if (this.skipToken(super.getTokenType(), this.myMatchState.myStart > start)) {
            this.myMatchState.findMatchOn(end, this.myEndOffset);
        }
    }

    protected boolean skipToken(IElementType tokenType, boolean strict) {
        return false;
    }

    public int getBufferEnd() {
        return this.myEndOffset;
    }

    public void advance() {
        if (this.myStoredState != null) {
            if (!this.advanceInMatched()) {
                if (this.myMatchState.myEnd == super.getTokenEnd()) {
                    super.advance();
                    this.myMatchState.findMatchOn(this.myMatchState.myEnd, this.myEndOffset);
                    this.processCurrentState();
                } else {
                    this.proceedAtMatchEnd(this.myMatchState.myEnd, this.myEndOffset, this.myStoredState);
                }
            }
        } else if (this.myMatchState.myStart < this.myEndOffset && this.myMatchState.myStart < super.getTokenEnd()) {
            this.processTokenMatch(this.getState());
        } else {
            super.advance();
            this.processCurrentState();
        }
    }

    protected void proceedAtMatchEnd(int startOffset, int endOffset, int state) {
        CharSequence buffer = this.getBufferSequence();
        String id = "id";
        super.start((CharSequence)id, 0, id.length(), state < 0 ? -state - 1 : state);
        super.advance();
        this.start(buffer, startOffset, endOffset, state < 0 ? -super.getState() - 1 : super.getState());
    }

    private void processCurrentState() {
        this.correctCurrentMatch();
        if (this.myMatchState.myStart == super.getTokenStart()) {
            this.processTokenMatch(this.getState());
        } else {
            this.myStoredState = null;
        }
    }

    public int getState() {
        return this.myStoredState != null ? -this.myStoredState.intValue() - 1 : super.getState();
    }

    @Nullable
    public IElementType getTokenType() {
        return this.myStoredState != null ? this.getMatchedTokenType() : super.getTokenType();
    }

    public int getTokenStart() {
        return this.myStoredState != null ? this.getMatchedTokenStart() : super.getTokenStart();
    }

    public int getTokenEnd() {
        return this.myStoredState != null ? this.getMatchedTokenEnd() : Math.min(super.getTokenEnd(), this.myMatchState.myStart);
    }

    protected void onNextMatched() {
    }

    protected MatchResult getMatch() {
        return this.myMatchState.myMatcher.getResult();
    }

    protected boolean advanceInMatched() {
        return false;
    }

    protected abstract IElementType getMatchedTokenType();

    protected int getMatchedTokenStart() {
        return this.myMatchState.myStart;
    }

    protected int getMatchedTokenEnd() {
        return this.myMatchState.myEnd;
    }

    private static class MatchState {
        private final TokenPattern.Matcher myMatcher;
        private int myStart = -1;
        private int myEnd = -1;

        public MatchState(TokenPattern pattern) {
            this.myMatcher = pattern.newMatcher();
        }

        public void reset(CharSequence buffer) {
            this.myMatcher.reset(buffer);
            this.myStart = -1;
            this.myEnd = -1;
        }

        public boolean findMatchOn(int offset, int limit) {
            if (offset <= limit) {
                boolean found = this.myMatcher.find(offset, limit);
                if (found && this.myMatcher.start() == this.myMatcher.end()) {
                    LOG.warn("Pattern matches empty text");
                    found = false;
                }
                if (found) {
                    this.myStart = this.myMatcher.start();
                    this.myEnd = this.myMatcher.end();
                    return true;
                }
            }
            this.myStart = Integer.MAX_VALUE;
            this.myEnd = Integer.MIN_VALUE;
            return false;
        }
    }
}

