/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.stubs;

import com.intellij.database.dataSource.srcStorage.DbSrcUtils;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.LightPsiParser;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiBuilderFactory;
import com.intellij.lang.PsiParser;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IStubFileElementType;
import com.intellij.sql.dialects.SqlDialectMappings;
import com.intellij.sql.psi.impl.lexer.SqlPreprocessingLexer;
import com.intellij.sql.psi.stubs.SqlFileStub;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class SqlFileElementType
extends IStubFileElementType<SqlFileStub> {
    public static final int VERSION = 5;

    public SqlFileElementType(@NonNls String debugName, Language language) {
        super(debugName, language);
    }

    public int getStubVersion() {
        return 5;
    }

    public void indexStub(@NotNull SqlFileStub stub, @NotNull IndexSink sink) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "com/intellij/sql/psi/stubs/SqlFileElementType", "indexStub"));
        }
        if (sink == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sink", "com/intellij/sql/psi/stubs/SqlFileElementType", "indexStub"));
        }
    }

    public boolean shouldBuildStubFor(VirtualFile file) {
        return DbSrcUtils.isDbSrcFile(file) || file.getUserData(SqlDialectMappings.SQL_DIALECT_KEY) != null;
    }

    public PsiBuilder parseLight(ASTNode chameleon) {
        PsiElement psi = chameleon.getPsi();
        PsiLanguageInjectionHost host = InjectedLanguageUtil.findInjectionHost((PsiElement)psi);
        if (host == null && psi.getParent() != null) {
            host = psi.getParent();
        }
        Language language = this.getLanguageForParser(psi);
        ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(language);
        Project project = psi.getProject();
        Lexer lexer = SqlPreprocessingLexer.withPreprocessingIfNeeded(project, parserDefinition, (PsiElement)host);
        PsiParser parser = parserDefinition.createParser(project);
        PsiBuilder builder = PsiBuilderFactory.getInstance().createBuilder(project, chameleon, lexer, language, chameleon.getChars());
        ((LightPsiParser)parser).parseLight((IElementType)this, builder);
        return builder;
    }

    protected ASTNode doParseContents(@NotNull ASTNode chameleon, @NotNull PsiElement psi) {
        if (chameleon == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chameleon", "com/intellij/sql/psi/stubs/SqlFileElementType", "doParseContents"));
        }
        if (psi == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psi", "com/intellij/sql/psi/stubs/SqlFileElementType", "doParseContents"));
        }
        return this.parseLight(chameleon).getTreeBuilt().getFirstChildNode();
    }
}

