/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.navigation;

import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.navigation.CssRelatedToHtmlFilesContributor;
import com.intellij.navigation.GotoRelatedItem;
import com.intellij.navigation.GotoRelatedProvider;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.css.CssStylesheet;
import com.intellij.psi.css.StylesheetFile;
import com.intellij.util.containers.HashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class CssGotoRelatedProvider
extends GotoRelatedProvider {
    @NotNull
    public List<? extends GotoRelatedItem> getItems(@NotNull PsiElement context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/navigation/CssGotoRelatedProvider", "getItems"));
        }
        PsiFile file = context.getContainingFile();
        if (file == null || !CssGotoRelatedProvider.isAvailable(file)) {
            List list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/navigation/CssGotoRelatedProvider", "getItems"));
            }
            return list;
        }
        HashSet resultSet = new HashSet();
        CssGotoRelatedProvider.fillRelatedFiles(file, (Set<PsiFile>)resultSet);
        ArrayList<GotoRelatedItem> items = new ArrayList<GotoRelatedItem>(resultSet.size());
        for (PsiFile relatedFile : resultSet) {
            items.add(new GotoRelatedItem((PsiElement)relatedFile, "HTML"));
        }
        ArrayList<GotoRelatedItem> arrayList = items;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/navigation/CssGotoRelatedProvider", "getItems"));
        }
        return arrayList;
    }

    private static void fillRelatedFiles(@NotNull PsiFile file, @NotNull Set<PsiFile> resultSet) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/navigation/CssGotoRelatedProvider", "fillRelatedFiles"));
        }
        if (resultSet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resultSet", "com/intellij/navigation/CssGotoRelatedProvider", "fillRelatedFiles"));
        }
        StylesheetFile stylesheetFile = (StylesheetFile)file;
        CssStylesheet stylesheet = stylesheetFile.getStylesheet();
        if (stylesheet != null) {
            CssRelatedToHtmlFilesContributor.processImports(stylesheet, resultSet);
        }
    }

    private static boolean isAvailable(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/navigation/CssGotoRelatedProvider", "isAvailable"));
        }
        return file instanceof StylesheetFile && InjectedLanguageManager.getInstance((Project)file.getProject()).getInjectionHost((PsiElement)file) == null;
    }
}

