/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.actions.colors;

import com.intellij.openapi.project.Project;
import com.intellij.psi.css.actions.colors.CssConvertColorIntention;
import com.intellij.psi.css.browse.ColorDeclarationType;
import com.intellij.psi.css.impl.util.CssPsiColorUtil;
import java.awt.Color;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssConvertToRgbIntention
extends CssConvertColorIntention {
    public CssConvertToRgbIntention() {
        super("RGB/RGBA");
    }

    @Override
    @NotNull
    protected String convert(@NotNull Color color, @Nullable Project project) {
        if (color == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "color", "com/intellij/psi/css/actions/colors/CssConvertToRgbIntention", "convert"));
        }
        String string = CssPsiColorUtil.toRgbColor(color);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/actions/colors/CssConvertToRgbIntention", "convert"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String getNewColorTypeName(boolean withAlphaChannel) {
        String string = withAlphaChannel ? "RGBA" : "RGB";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/actions/colors/CssConvertToRgbIntention", "getNewColorTypeName"));
        }
        return string;
    }

    @Override
    protected boolean isApplied(@NotNull ColorDeclarationType colorType, @NotNull Color color) {
        if (colorType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "colorType", "com/intellij/psi/css/actions/colors/CssConvertToRgbIntention", "isApplied"));
        }
        if (color == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "color", "com/intellij/psi/css/actions/colors/CssConvertToRgbIntention", "isApplied"));
        }
        return colorType != ColorDeclarationType.RGB && colorType != ColorDeclarationType.RGBA;
    }
}

