/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.LiteralTextEscaper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.css.CssElement;
import com.intellij.psi.css.CssExpression;
import com.intellij.psi.css.impl.CssElementImpl;
import com.intellij.psi.css.impl.CssElementTypes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssExpressionImpl
extends CssElementImpl
implements CssExpression {
    CssExpressionImpl() {
        super(CssElementTypes.CSS_EXPRESSION);
    }

    @Nullable
    public CssElement getValueNode() {
        return (CssElement)this.findPsiChildByType(CssElementTypes.CSS_EXPRESSION_PARAMETER);
    }

    public boolean isValidHost() {
        return true;
    }

    public PsiLanguageInjectionHost updateText(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/psi/css/impl/CssExpressionImpl", "updateText"));
        }
        return (PsiLanguageInjectionHost)ElementManipulators.handleContentChange((PsiElement)this, (String)text);
    }

    @NotNull
    public LiteralTextEscaper<CssExpressionImpl> createLiteralTextEscaper() {
        MyLiteralEscaper myLiteralEscaper = new MyLiteralEscaper(this);
        if (myLiteralEscaper == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/CssExpressionImpl", "createLiteralTextEscaper"));
        }
        return myLiteralEscaper;
    }

    private static boolean parseStringCharacters(String chars, StringBuilder outChars, int[] sourceOffsets) {
        outChars.append(chars);
        if (sourceOffsets != null) {
            for (int i = 0; i < sourceOffsets.length; ++i) {
                sourceOffsets[i] = i;
            }
        }
        return true;
    }

    private static class MyLiteralEscaper
    extends LiteralTextEscaper<CssExpressionImpl> {
        private int[] outSourceOffsets;

        protected MyLiteralEscaper(@NotNull CssExpressionImpl host) {
            if (host == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "com/intellij/psi/css/impl/CssExpressionImpl$MyLiteralEscaper", "<init>"));
            }
            super((PsiLanguageInjectionHost)host);
        }

        public boolean decode(@NotNull TextRange rangeInsideHost, @NotNull StringBuilder outChars) {
            if (rangeInsideHost == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rangeInsideHost", "com/intellij/psi/css/impl/CssExpressionImpl$MyLiteralEscaper", "decode"));
            }
            if (outChars == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outChars", "com/intellij/psi/css/impl/CssExpressionImpl$MyLiteralEscaper", "decode"));
            }
            String subText = rangeInsideHost.substring(((CssExpressionImpl)this.myHost).getText());
            this.outSourceOffsets = new int[subText.length() + 1];
            return CssExpressionImpl.parseStringCharacters(subText, outChars, this.outSourceOffsets);
        }

        public int getOffsetInHost(int offsetInDecoded, @NotNull TextRange rangeInsideHost) {
            int result;
            if (rangeInsideHost == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rangeInsideHost", "com/intellij/psi/css/impl/CssExpressionImpl$MyLiteralEscaper", "getOffsetInHost"));
            }
            int n = result = offsetInDecoded < this.outSourceOffsets.length ? this.outSourceOffsets[offsetInDecoded] : -1;
            if (result == -1) {
                return -1;
            }
            return (result <= rangeInsideHost.getLength() ? result : rangeInsideHost.getLength()) + rangeInsideHost.getStartOffset();
        }

        public boolean isOneLine() {
            return true;
        }
    }
}

