/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl;

import com.intellij.navigation.ItemPresentation;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.css.CssNamedElement;
import com.intellij.psi.presentation.java.SymbolPresentationUtil;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssNamedItemPresentation
implements ItemPresentation {
    @NotNull
    private final PsiNamedElement myElement;
    @Nullable
    private final String myCustomText;

    public CssNamedItemPresentation(@NotNull PsiNamedElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/css/impl/CssNamedItemPresentation", "<init>"));
        }
        this(element, null);
    }

    public CssNamedItemPresentation(@NotNull PsiNamedElement element, @Nullable String customText) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/css/impl/CssNamedItemPresentation", "<init>"));
        }
        this.myElement = element;
        this.myCustomText = customText;
    }

    @Nullable
    public String getPresentableText() {
        return this.myCustomText != null ? this.myCustomText : this.myElement.getName();
    }

    @Nullable
    public String getLocationString() {
        int lineNumber;
        String filePathPresentation = SymbolPresentationUtil.getFilePathPresentation((PsiFile)this.myElement.getContainingFile());
        if (this.myElement instanceof CssNamedElement && (lineNumber = ((CssNamedElement)this.myElement).getLineNumber()) > 0) {
            filePathPresentation = filePathPresentation + ":" + lineNumber;
        }
        return filePathPresentation;
    }

    @Nullable
    public Icon getIcon(boolean open) {
        return this.myElement.getIcon(0);
    }
}

