/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl.util;

import com.intellij.openapi.project.Project;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.css.codeStyle.CssCodeStyleSettings;
import com.intellij.psi.css.impl.util.CssPsiColorUtil;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssColorUtil {
    @NotNull
    public static String formatHexColorAccordingToCodeStyle(@NotNull String colorString, @Nullable Project project) {
        if (colorString == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "colorString", "com/intellij/psi/css/impl/util/CssColorUtil", "formatHexColorAccordingToCodeStyle"));
        }
        CodeStyleSettings settings = CodeStyleSettingsManager.getInstance((Project)project).getCurrentSettings();
        CssCodeStyleSettings cssCodeStyleSettings = (CssCodeStyleSettings)settings.getCustomSettings(CssCodeStyleSettings.class);
        String newColorText = colorString;
        if (cssCodeStyleSettings.HEX_COLOR_LONG_FORMAT && colorString.length() == 4) {
            newColorText = CssPsiColorUtil.normalizeHexColor(colorString);
        } else if (cssCodeStyleSettings.HEX_COLOR_SHORT_FORMAT && colorString.length() == 7) {
            newColorText = CssPsiColorUtil.toShortHexColor(colorString);
        }
        if (cssCodeStyleSettings.HEX_COLOR_UPPER_CASE) {
            newColorText = newColorText.toUpperCase(Locale.US);
        } else if (cssCodeStyleSettings.HEX_COLOR_LOWER_CASE) {
            newColorText = newColorText.toLowerCase(Locale.US);
        }
        String string = newColorText;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/CssColorUtil", "formatHexColorAccordingToCodeStyle"));
        }
        return string;
    }
}

