/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl.util.editor;

import com.intellij.formatting.Block;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.css.codeStyle.CssCodeStyleSettings;
import com.intellij.psi.formatter.DocumentBasedFormattingModel;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.LocalTimeCounter;

class CssFormattingModel
extends DocumentBasedFormattingModel {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.css.impl.util.editor.CssFormattingModel");

    public CssFormattingModel(PsiFile file, CssCodeStyleSettings settings, Block rootBlock) {
        super(rootBlock, file.getProject(), settings.getContainer(), file.getFileType(), file);
    }

    public void commitChanges() {
        super.commitChanges();
        PsiFile file = this.getFile();
        if (!file.isPhysical()) {
            Document document = this.getDocument();
            FileType fileType = file.getFileType();
            PsiFile newFile = PsiFileFactory.getInstance((Project)file.getProject()).createFileFromText("b." + fileType.getDefaultExtension(), fileType, (CharSequence)document.getText(), LocalTimeCounter.currentTime(), false, false);
            try {
                file.getFirstChild().replace(newFile.getFirstChild());
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }
    }
}

