/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl.util.editor;

import com.intellij.formatting.ASTBlock;
import com.intellij.formatting.Alignment;
import com.intellij.formatting.ChildAttributes;
import com.intellij.formatting.Indent;
import com.intellij.lang.ASTNode;
import com.intellij.psi.css.codeStyle.CssCodeStyleSettings;
import com.intellij.psi.css.impl.util.editor.CssFormattingModelBuilder;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class IndentedRulesetBlock
extends CssFormattingModelBuilder.CssRulesetBlock {
    public IndentedRulesetBlock(ASTNode _node, CssCodeStyleSettings settings, Indent indent, int maxPropertyLength, CssFormattingModelBuilder.CssFormattingExtension extension, @Nullable Alignment alignment) {
        super(_node, settings, indent, maxPropertyLength, extension, alignment);
    }

    @Nullable
    private ASTNode getNodeBefore(int childIndex) {
        if (childIndex == 0) {
            return null;
        }
        int prevIndex = childIndex - 1;
        ASTBlock insertAfterBlock = (ASTBlock)this.getSubBlocks().get(prevIndex);
        return insertAfterBlock.getNode();
    }

    protected boolean shouldNodeHandleTypedEnter(@NotNull ASTNode node, int typedEnterOffset) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/psi/css/impl/util/editor/IndentedRulesetBlock", "shouldNodeHandleTypedEnter"));
        }
        return this.getElementsHandlingEnter().contains(node.getElementType());
    }

    protected boolean shouldIndentChild() {
        return this.getElementsIndentingChildren().contains(this.myNode.getElementType());
    }

    @Nullable
    private ASTNode findElementToHandleEnter(@NotNull ASTNode afterNode) {
        ASTNode result;
        if (afterNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "afterNode", "com/intellij/psi/css/impl/util/editor/IndentedRulesetBlock", "findElementToHandleEnter"));
        }
        for (result = TreeUtil.findLastLeaf((ASTNode)afterNode); result != null && !this.shouldNodeHandleTypedEnter(result, afterNode.getTextRange().getEndOffset()) && result != this.myNode; result = result.getTreeParent()) {
        }
        return result;
    }

    private boolean shouldDelegateToChild(@NotNull ASTNode afterNode) {
        if (afterNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "afterNode", "com/intellij/psi/css/impl/util/editor/IndentedRulesetBlock", "shouldDelegateToChild"));
        }
        ASTNode elementToHandleEnter = this.findElementToHandleEnter(afterNode);
        return elementToHandleEnter != this.myNode;
    }

    @Override
    @NotNull
    public ChildAttributes getChildAttributes(int newChildIndex) {
        ASTNode afterNode = this.getNodeBefore(newChildIndex);
        if (afterNode != null && this.shouldDelegateToChild(afterNode)) {
            ChildAttributes childAttributes = ChildAttributes.DELEGATE_TO_PREV_CHILD;
            if (childAttributes == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/editor/IndentedRulesetBlock", "getChildAttributes"));
            }
            return childAttributes;
        }
        if (this.shouldIndentChild()) {
            ChildAttributes childAttributes = new ChildAttributes(Indent.getNormalIndent((boolean)true), null);
            if (childAttributes == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/editor/IndentedRulesetBlock", "getChildAttributes"));
            }
            return childAttributes;
        }
        ChildAttributes childAttributes = new ChildAttributes(Indent.getNoneIndent(), null);
        if (childAttributes == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/editor/IndentedRulesetBlock", "getChildAttributes"));
        }
        return childAttributes;
    }

    protected abstract TokenSet getElementsHandlingEnter();

    protected abstract TokenSet getElementsIndentingChildren();
}

