/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.auth.basic;

import com.microsoft.alm.auth.BaseAuthenticator;
import com.microsoft.alm.auth.PromptBehavior;
import com.microsoft.alm.auth.basic.CredentialPrompt;
import com.microsoft.alm.auth.basic.DefaultCredentialPrompt;
import com.microsoft.alm.helpers.Debug;
import com.microsoft.alm.secret.Credential;
import com.microsoft.alm.storage.InsecureInMemoryStore;
import com.microsoft.alm.storage.SecretStore;
import java.net.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicAuthAuthenticator
extends BaseAuthenticator {
    private static final Logger logger = LoggerFactory.getLogger(BasicAuthAuthenticator.class);
    private static final String TYPE = "BasicAuth";
    private final SecretStore<Credential> store;
    private final CredentialPrompt prompter;

    public BasicAuthAuthenticator() {
        this((SecretStore<Credential>)new InsecureInMemoryStore(), new DefaultCredentialPrompt());
    }

    public BasicAuthAuthenticator(SecretStore<Credential> store, CredentialPrompt prompter) {
        Debug.Assert((store != null ? 1 : 0) != 0, (String)"store cannot be null");
        Debug.Assert((prompter != null ? 1 : 0) != 0, (String)"prompter cannot be null");
        this.store = store;
        this.prompter = prompter;
    }

    @Override
    public String getAuthType() {
        return TYPE;
    }

    protected SecretStore<Credential> getStore() {
        return this.store;
    }

    @Override
    public boolean isCredentialSupported() {
        return true;
    }

    @Override
    public Credential getCredential(URI uri) {
        logger.debug("Retrieving credential for uri: {}", (Object)uri);
        return this.getCredential(uri, PromptBehavior.AUTO);
    }

    @Override
    public Credential getCredential(final URI uri, PromptBehavior promptBehavior) {
        Debug.Assert((uri != null ? 1 : 0) != 0, (String)"getCrednetial uri key cannot be null");
        Debug.Assert((promptBehavior != null ? 1 : 0) != 0, (String)"getCrednetial promptBehavior cannot be null");
        logger.debug("Retrieving credential for uri: {} with prompt behavior: {}.", (Object)uri, (Object)promptBehavior.name());
        String key = this.getKey(uri);
        BaseAuthenticator.SecretRetriever<Credential> secretRetriever = new BaseAuthenticator.SecretRetriever<Credential>(){

            @Override
            protected Credential doRetrieve() {
                logger.debug("Prompt user for credential for uri: {}", (Object)uri);
                return BasicAuthAuthenticator.this.prompter.prompt(uri);
            }
        };
        return secretRetriever.retrieve(key, this.getStore(), promptBehavior);
    }
}

