/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.auth.oauth;

import com.microsoft.alm.auth.oauth.DeviceFlow;
import com.microsoft.alm.auth.oauth.DeviceFlowResponse;
import com.microsoft.alm.auth.oauth.Global;
import com.microsoft.alm.helpers.HttpClient;
import com.microsoft.alm.helpers.HttpResponse;
import com.microsoft.alm.helpers.PropertyBag;
import com.microsoft.alm.helpers.QueryString;
import com.microsoft.alm.helpers.StringContent;
import com.microsoft.alm.helpers.StringHelper;
import com.microsoft.alm.oauth2.useragent.AuthorizationException;
import com.microsoft.alm.secret.TokenPair;
import java.io.IOException;
import java.net.URI;
import java.util.Calendar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeviceFlowImpl
implements DeviceFlow {
    private static final Logger logger = LoggerFactory.getLogger(DeviceFlowImpl.class);

    @Override
    public DeviceFlowResponse requestAuthorization(URI deviceEndpoint, String clientId, String scope) {
        String responseText;
        QueryString bodyParameters = new QueryString();
        bodyParameters.put((Object)"response_type", (Object)"device_code");
        bodyParameters.put((Object)"client_id", (Object)clientId);
        if (!StringHelper.isNullOrEmpty((String)scope)) {
            bodyParameters.put((Object)"scope", (Object)scope);
        }
        this.contributeAuthorizationRequestParameters(bodyParameters);
        StringContent requestBody = StringContent.createUrlEncoded((QueryString)bodyParameters);
        HttpClient client = Global.getHttpClientFactory().createHttpClient();
        try {
            responseText = client.getPostResponseText(deviceEndpoint, requestBody);
        }
        catch (IOException e) {
            throw new Error(e);
        }
        DeviceFlowResponse result = this.buildDeviceFlowResponse(responseText);
        return result;
    }

    protected void contributeAuthorizationRequestParameters(QueryString bodyParameters) {
    }

    protected DeviceFlowResponse buildDeviceFlowResponse(String responseText) {
        return DeviceFlowResponse.fromJson(responseText);
    }

    @Override
    public TokenPair requestToken(URI tokenEndpoint, String clientId, DeviceFlowResponse deviceFlowResponse) throws AuthorizationException {
        QueryString bodyParameters = new QueryString();
        bodyParameters.put((Object)"grant_type", (Object)"device_code");
        bodyParameters.put((Object)"code", (Object)deviceFlowResponse.getDeviceCode());
        bodyParameters.put((Object)"client_id", (Object)clientId);
        this.contributeTokenRequestParameters(bodyParameters);
        StringContent requestBody = StringContent.createUrlEncoded((QueryString)bodyParameters);
        int intervalSeconds = deviceFlowResponse.getInterval();
        int intervalMilliseconds = intervalSeconds * 1000;
        HttpClient client = Global.getHttpClientFactory().createHttpClient();
        String responseText = null;
        Calendar expiresAt = deviceFlowResponse.getExpiresAt();
        do {
            if (deviceFlowResponse.cancelRequestedByUser()) {
                throw new AuthorizationException("request_cancelled", "Stop polling for Token.", null, null);
            }
            try {
                HttpResponse response = client.getPostResponse(tokenEndpoint, requestBody);
                if (response.status == 200) {
                    responseText = response.responseText;
                    break;
                }
                String errorResponseText = response.errorText;
                if (response.status == 400) {
                    PropertyBag bag = PropertyBag.fromJson((String)errorResponseText);
                    String errorCode = bag.readOptionalString("error", "unknown_error");
                    if ("authorization_pending".equals(errorCode)) {
                        try {
                            Thread.sleep(intervalMilliseconds);
                            continue;
                        }
                        catch (InterruptedException e) {
                            throw new Error(e);
                        }
                    }
                    if ("slow_down".equals(errorCode)) {
                        intervalMilliseconds *= 2;
                        try {
                            Thread.sleep(intervalMilliseconds);
                            continue;
                        }
                        catch (InterruptedException e) {
                            throw new Error(e);
                        }
                    }
                    String errorDescription = bag.readOptionalString("error_description", null);
                    String errorUriString = bag.readOptionalString("error_uri", null);
                    URI errorUri = errorUriString == null ? null : URI.create(errorUriString);
                    throw new AuthorizationException(errorCode, errorDescription, errorUri, null);
                }
                throw new Error("Token endpoint returned HTTP " + response.status + ":\n" + errorResponseText);
            }
            catch (IOException e) {
                throw new Error(e);
            }
        } while (Calendar.getInstance().compareTo(expiresAt) <= 0);
        if (responseText == null) {
            throw new AuthorizationException("code_expired", "The verification code expired.", null, null);
        }
        TokenPair tokenPair = this.buildTokenPair(responseText);
        deviceFlowResponse.setTokenAcquired();
        return tokenPair;
    }

    protected void contributeTokenRequestParameters(QueryString bodyParameters) {
    }

    protected TokenPair buildTokenPair(String responseText) {
        TokenPair tokenPair = new TokenPair(responseText);
        return tokenPair;
    }
}

