/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.auth.oauth;

import com.microsoft.alm.oauth2.useragent.Provider;
import com.microsoft.alm.oauth2.useragent.ProviderScanner;
import com.microsoft.alm.oauth2.useragent.StandardWidgetToolkitProvider;
import com.microsoft.alm.oauth2.useragent.UserAgentImpl;
import java.util.List;
import java.util.Map;

public class OAuth2UseragentValidator {
    private final ProviderScanner scanner = new UserAgentImpl();

    public boolean isOAuth2ProviderAvailable() {
        Provider provider = this.scanner.findCompatibleProvider();
        return provider != null;
    }

    public boolean isOnlyMissingRuntimeFromSwtProvider() {
        Map unmetProviderRequirements = this.scanner.getUnmetProviderRequirements();
        List unmetSwtProviderRequirement = (List)unmetProviderRequirements.get(Provider.STANDARD_WIDGET_TOOLKIT);
        if (unmetSwtProviderRequirement != null && unmetSwtProviderRequirement.size() == 1) {
            return ((String)unmetSwtProviderRequirement.get(0)).contains(StandardWidgetToolkitProvider.getDefaultSwtJarPath());
        }
        return false;
    }
}

