/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.auth.oauth.helper;

import com.microsoft.alm.auth.oauth.AzureAuthority;
import com.microsoft.alm.auth.oauth.OAuth2Authenticator;
import java.io.IOException;
import java.net.URI;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AzureAuthorityProvider {
    private static final Logger logger = LoggerFactory.getLogger(AzureAuthorityProvider.class);

    public AzureAuthority getAzureAuthority(URI uri) throws IOException {
        if (uri == OAuth2Authenticator.APP_VSSPS_VISUALSTUDIO) {
            return AzureAuthority.DefaultAzureAuthority;
        }
        logger.debug("Lookup tenant id for {}", (Object)uri);
        UUID tenantId = AzureAuthority.detectTenantId(uri);
        logger.debug("tenant id for {} is {}", (Object)uri, (Object)tenantId);
        if (tenantId == null) {
            return AzureAuthority.DefaultAzureAuthority;
        }
        return new AzureAuthority("https://login.microsoftonline.com/" + tenantId);
    }
}

