/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.auth.oauth.helper;

import com.microsoft.alm.helpers.IOHelper;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.CRC32;

public class FileHashHelper {
    public static long crc32Hash(File f) throws IOException {
        if (!f.isFile()) {
            throw new IOException(f.getAbsolutePath() + " is not a valid file.");
        }
        FileInputStream fis = new FileInputStream(f);
        long hash = FileHashHelper.crc32Hash(fis);
        IOHelper.closeQuietly((Closeable)fis);
        return hash;
    }

    public static long crc32Hash(InputStream is) throws IOException {
        int bytesRead;
        if (is == null) {
            throw new IOException("InputStream is null.");
        }
        CRC32 crcMaker = new CRC32();
        byte[] buffer = new byte[65536];
        while ((bytesRead = is.read(buffer)) != -1) {
            crcMaker.update(buffer, 0, bytesRead);
        }
        return crcMaker.getValue();
    }
}

