/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.auth.oauth.helper;

import com.microsoft.alm.auth.oauth.helper.FileHashHelper;
import com.microsoft.alm.helpers.IOHelper;
import com.microsoft.alm.helpers.SystemHelper;
import com.microsoft.alm.oauth2.useragent.StandardWidgetToolkitProvider;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwtJarLoader {
    private static final Logger logger = LoggerFactory.getLogger(SwtJarLoader.class);
    private static final String BASE_URL = "https://az771546.vo.msecnd.net/swt-binary-for-auth-library/";
    private static String jarName;
    private static File targetSwtJar;
    private static String SWT_VERSION;
    static final Map<String, Long> CRC32_HASHES;

    static String getJarName(boolean isWindows, boolean isLinux, boolean isMac, boolean isx64) {
        String jarName = "org.eclipse.swt." + (isWindows ? "win32.win32" : (isMac ? "cocoa.macosx" : (isLinux ? "gtk.linux" : ""))) + (isx64 ? ".x86_64-" : ".x86-") + SWT_VERSION + ".jar";
        return jarName;
    }

    public static boolean tryGetSwtJar(AtomicReference<File> swtJarReference) {
        String swtJarUrl = BASE_URL + jarName;
        logger.info("Downloading {}", (Object)swtJarUrl);
        try {
            HttpURLConnection cloudSwtUrlConn = (HttpURLConnection)new URL(swtJarUrl).openConnection();
            int statusCode = cloudSwtUrlConn.getResponseCode();
            if (statusCode != 200) {
                throw new IOException(String.format("Failed to download SWT Runtime jar from %s.  Server return code is %d", swtJarUrl, statusCode));
            }
            File parent = targetSwtJar.getParentFile();
            if (parent != null && !parent.exists()) {
                parent.mkdirs();
            }
            targetSwtJar.createNewFile();
            FileOutputStream fos = new FileOutputStream(targetSwtJar);
            InputStream is = cloudSwtUrlConn.getInputStream();
            IOHelper.copyStream((InputStream)is, (OutputStream)fos);
            IOHelper.closeQuietly((Closeable)is);
            IOHelper.closeQuietly((Closeable)fos);
            if (SwtJarLoader.isValid(targetSwtJar)) {
                swtJarReference.set(targetSwtJar);
                return true;
            }
            SwtJarLoader.cleanup(targetSwtJar);
        }
        catch (IOException ioe) {
            logger.warn("Failed to download SWT Runtime jar.", (Throwable)ioe);
            SwtJarLoader.cleanup(targetSwtJar);
        }
        swtJarReference.set(null);
        return false;
    }

    private static void cleanup(File target) {
        if (target.exists()) {
            target.delete();
        }
    }

    private static boolean isValid(File swtJar) {
        try {
            long hash = CRC32_HASHES.get(jarName);
            return swtJar.isFile() && FileHashHelper.crc32Hash(swtJar) == hash;
        }
        catch (IOException e) {
            logger.error("Failed to calculate CRC32 Hash of {}", (Object)swtJar, (Object)e);
            return false;
        }
    }

    static {
        SWT_VERSION = "4.4.2";
        boolean isWindows = SystemHelper.isWindows();
        boolean isMac = SystemHelper.isMac();
        boolean isLinux = SystemHelper.isLinux();
        boolean isx64 = System.getProperty("os.arch").contains("64");
        jarName = SwtJarLoader.getJarName(isWindows, isLinux, isMac, isx64);
        targetSwtJar = new File(StandardWidgetToolkitProvider.getDefaultSwtJarPath());
        HashMap<String, Long> hashes = new HashMap<String, Long>();
        hashes.put("org.eclipse.swt.cocoa.macosx.x86-4.4.2.jar", 2804720395L);
        hashes.put("org.eclipse.swt.cocoa.macosx.x86_64-4.4.2.jar", 3069467037L);
        hashes.put("org.eclipse.swt.gtk.linux.x86-4.4.2.jar", 466147888L);
        hashes.put("org.eclipse.swt.gtk.linux.x86_64-4.4.2.jar", 3777958147L);
        hashes.put("org.eclipse.swt.win32.win32.x86-4.4.2.jar", 2366837566L);
        hashes.put("org.eclipse.swt.win32.win32.x86_64-4.4.2.jar", 3238843570L);
        CRC32_HASHES = Collections.unmodifiableMap(hashes);
    }
}

