/*
 * Decompiled with CFR 0.152.
 */
package git4idea.attributes;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum GitAttribute {
    TEXT("text"),
    CRLF("crlf");

    @NotNull
    private final String myName;

    private GitAttribute(String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "git4idea/attributes/GitAttribute", "<init>"));
        }
        this.myName = name;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/attributes/GitAttribute", "getName"));
        }
        return string;
    }

    @Nullable
    public static GitAttribute forName(String attribute) {
        for (GitAttribute attr : GitAttribute.values()) {
            if (!attr.myName.equalsIgnoreCase(attribute)) continue;
            return attr;
        }
        return null;
    }
}

